/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.config;

import de.maxhenkel.audioplayer.configbuilder.ConfigBuilder;
import de.maxhenkel.audioplayer.configbuilder.entry.ConfigEntry;

public class ServerConfig {
    public final ConfigEntry<String> filebinUrl;
    public final ConfigEntry<Long> maxUploadSize;
    public final ConfigEntry<Integer> goatHornCooldown;
    public final ConfigEntry<Float> musicDiscRange;
    public final ConfigEntry<Float> noteBlockRange;
    public final ConfigEntry<Float> goatHornRange;
    public final ConfigEntry<Float> maxGoatHornRange;
    public final ConfigEntry<Float> maxNoteBlockRange;
    public final ConfigEntry<Float> maxMusicDiscRange;
    public final ConfigEntry<Boolean> allowWavUpload;
    public final ConfigEntry<Boolean> allowMp3Upload;
    public final ConfigEntry<Integer> maxMusicDiscDuration;
    public final ConfigEntry<Integer> maxNoteBlockDuration;
    public final ConfigEntry<Integer> maxGoatHornDuration;
    public final ConfigEntry<Integer> cacheSize;
    public final ConfigEntry<Boolean> allowStaticAudio;
    public final ConfigEntry<Boolean> runWebServer;

    public ServerConfig(ConfigBuilder builder) {
        this.filebinUrl = builder.stringEntry("filebin_url", "https://filebin.net/", "The URL of the Filebin service that the mod should use");
        this.maxUploadSize = builder.longEntry("max_upload_size", (Long)20000000L, 1L, (Long)Integer.MAX_VALUE, "The maximum allowed size of an uploaded file in bytes");
        this.goatHornCooldown = builder.integerEntry("goat_horn_cooldown", (Integer)140, 1, (Integer)Short.MAX_VALUE, "The cooldown of goat horns with custom audio in ticks");
        this.musicDiscRange = builder.floatEntry("music_disc_range", Float.valueOf(65.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The range of music discs with custom audio in blocks");
        this.noteBlockRange = builder.floatEntry("note_block_range", Float.valueOf(16.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The range of note blocks with custom audio in blocks");
        this.goatHornRange = builder.floatEntry("goat_horn_range", Float.valueOf(256.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The range of goat horns with custom audio in blocks");
        this.maxMusicDiscRange = builder.floatEntry("max_music_disc_range", Float.valueOf(256.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The maximum allowed range of a music disc with custom audio in blocks");
        this.maxNoteBlockRange = builder.floatEntry("max_note_block_range", Float.valueOf(256.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The maximum allowed range of a note block with custom audio in blocks");
        this.maxGoatHornRange = builder.floatEntry("max_goat_horn_range", Float.valueOf(512.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The maximum allowed range of a goat horn with custom audio in blocks");
        this.allowWavUpload = builder.booleanEntry("allow_wav_upload", true, "Whether users should be able to upload .wav files", "Note that .wav files are not compressed and can be very large", "Playing .wav files may result in more RAM usage");
        this.allowMp3Upload = builder.booleanEntry("allow_mp3_upload", true, "Whether users should be able to upload .mp3 files", "Note that .mp3 files require Simple Voice Chats mp3 decoder", "Playing .mp3 files can be slightly more CPU intensive");
        this.maxMusicDiscDuration = builder.integerEntry("max_music_disc_duration", (Integer)300, 1, Integer.MAX_VALUE, "The maximum allowed duration of a custom music disc in seconds");
        this.maxNoteBlockDuration = builder.integerEntry("max_note_block_duration", (Integer)300, 1, Integer.MAX_VALUE, "The maximum allowed duration of a note block with custom audio in seconds");
        this.maxGoatHornDuration = builder.integerEntry("max_goat_horn_duration", (Integer)20, 1, Integer.MAX_VALUE, "The maximum allowed duration of a custom goat horn in seconds");
        this.cacheSize = builder.integerEntry("cache_size", (Integer)16, 0, Integer.MAX_VALUE, "The maximum amount of audio files that are cached in memory", "Setting this to 0 will disable the cache", "A higher value will result in less disk reads, but more RAM usage");
        this.allowStaticAudio = builder.booleanEntry("allow_static_audio", true, "Static audio does not have directionality or falloff (volume does not decrease with distance)", "The /audioplayer setstatic [enabled] command can be used when this is set to true", "If this config option is disabled, static audio is completely disabled and will play as if the option wouldn't be set");
        this.runWebServer = builder.booleanEntry("run_web_server", false, "If the mod should run a webserver for uploads", "You can configure the webserver in the webserver.properties config", "The webserver.properties will only be generated if this option is set to true", "NOTE: This option is experimental and subject to change");
    }
}

