/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.elements;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.StringUtil;
import mezz.jei.core.util.Pair;
import net.minecraft.class_2477;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8029;
import org.jetbrains.annotations.Nullable;

public class TextWidget
implements ITextWidget,
IRecipeWidget {
    private final List<class_5348> text;
    private ImmutableRect2i availableArea;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private class_327 font;
    private int color;
    private boolean shadow;
    private int lineSpacing;
    @Nullable
    private List<class_5348> wrappedText;
    private boolean truncated = false;

    public TextWidget(List<class_5348> text, int xPos, int yPos, int maxWidth, int maxHeight) {
        this.availableArea = new ImmutableRect2i(xPos, yPos, maxWidth, maxHeight);
        class_310 minecraft = class_310.method_1551();
        this.font = minecraft.field_1772;
        this.color = -16777216;
        this.text = text;
        this.lineSpacing = 2;
        this.horizontalAlignment = HorizontalAlignment.LEFT;
        this.verticalAlignment = VerticalAlignment.TOP;
    }

    private void invalidateCachedValues() {
        this.wrappedText = null;
        this.truncated = false;
    }

    @Override
    public int getWidth() {
        return this.availableArea.width();
    }

    @Override
    public int getHeight() {
        return this.availableArea.height();
    }

    @Override
    public TextWidget setPosition(int xPos, int yPos) {
        this.availableArea = this.availableArea.setPosition(xPos, yPos);
        this.invalidateCachedValues();
        return this;
    }

    @Override
    public TextWidget setTextAlignment(HorizontalAlignment horizontalAlignment) {
        if (this.horizontalAlignment.equals((Object)horizontalAlignment)) {
            return this;
        }
        this.horizontalAlignment = horizontalAlignment;
        this.invalidateCachedValues();
        return this;
    }

    @Override
    public TextWidget setTextAlignment(VerticalAlignment verticalAlignment) {
        if (this.verticalAlignment.equals((Object)verticalAlignment)) {
            return this;
        }
        this.verticalAlignment = verticalAlignment;
        this.invalidateCachedValues();
        return this;
    }

    @Override
    public ITextWidget setFont(class_327 font) {
        this.font = font;
        this.invalidateCachedValues();
        return this;
    }

    @Override
    public ITextWidget setColor(int color) {
        this.color = color;
        this.invalidateCachedValues();
        return this;
    }

    @Override
    public ITextWidget setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        this.invalidateCachedValues();
        return this;
    }

    @Override
    public ITextWidget setShadow(boolean shadow) {
        this.shadow = shadow;
        this.invalidateCachedValues();
        return this;
    }

    @Override
    public class_8029 getPosition() {
        return this.availableArea.getScreenPosition();
    }

    private List<class_5348> calculateWrappedText() {
        if (this.wrappedText != null) {
            return this.wrappedText;
        }
        int lineHeight = this.getLineHeight();
        int maxLines = this.availableArea.height() / lineHeight;
        Objects.requireNonNull(this.font);
        if (maxLines * lineHeight + 9 <= this.availableArea.height()) {
            ++maxLines;
        }
        Pair<List<class_5348>, Boolean> result = StringUtil.splitLines(this.font, this.text, this.availableArea.width(), maxLines);
        this.wrappedText = result.first();
        this.truncated = result.second();
        return this.wrappedText;
    }

    private int getLineHeight() {
        Objects.requireNonNull(this.font);
        return 9 + this.lineSpacing;
    }

    @Override
    public void drawWidget(class_332 guiGraphics, double mouseX, double mouseY) {
        class_2477 language = class_2477.method_10517();
        int lineHeight = this.getLineHeight();
        List<class_5348> lines = this.calculateWrappedText();
        int yPos = this.getYPosStart(lineHeight, lines);
        for (class_5348 line : lines) {
            class_5481 charSequence = language.method_30934(line);
            int xPos = this.getXPos(charSequence);
            guiGraphics.method_51430(this.font, charSequence, xPos, yPos, this.color, this.shadow);
            yPos += lineHeight;
        }
        if (DebugConfig.isDebugGuisEnabled()) {
            guiGraphics.method_25294(0, 0, this.availableArea.width(), this.availableArea.height(), -1431655936);
        }
    }

    @Override
    public void getTooltip(ITooltipBuilder tooltip, double mouseX, double mouseY) {
        if (mouseX >= 0.0 && mouseX < (double)this.availableArea.width() && mouseY >= 0.0 && mouseY < (double)this.availableArea.height()) {
            this.calculateWrappedText();
            if (this.truncated) {
                tooltip.addAll(this.text);
            }
        }
    }

    private int getXPos(class_5481 text) {
        return this.getXPos(this.font.method_30880(text));
    }

    private int getXPos(int lineWidth) {
        return this.horizontalAlignment.getXPos(this.availableArea.width(), lineWidth);
    }

    private int getYPosStart(int lineHeight, List<class_5348> text) {
        int linesHeight = lineHeight * text.size() - this.lineSpacing - 1;
        return this.verticalAlignment.getYPos(this.availableArea.height(), linesHeight);
    }
}

