/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.cooking;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.library.util.RecipeUtil;
import net.minecraft.class_1856;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public abstract class AbstractCookingCategory<T extends class_1874>
extends AbstractRecipeCategory<T> {
    protected final int regularCookTime;

    public AbstractCookingCategory(IGuiHelper guiHelper, RecipeType<T> recipeType, class_2248 icon, String translationKey, int regularCookTime) {
        this(guiHelper, recipeType, icon, translationKey, regularCookTime, 82, 54);
    }

    public AbstractCookingCategory(IGuiHelper guiHelper, RecipeType<T> recipeType, class_2248 icon, String translationKey, int regularCookTime, int width, int height) {
        super(recipeType, (class_2561)class_2561.method_43471((String)translationKey), guiHelper.createDrawableItemLike((class_1935)icon), width, height);
        this.regularCookTime = regularCookTime;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addInputSlot(1, 1).setStandardSlotBackground().addIngredients((class_1856)recipe.method_8117().get(0));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 37).setStandardSlotBackground();
        builder.addOutputSlot(61, 19).setOutputSlotBackground().addItemStack(RecipeUtil.getResultItem(recipe));
    }

    @Override
    public void createRecipeExtras(IRecipeExtrasBuilder builder, T recipe, IFocusGroup focuses) {
        int cookTime = recipe.method_8167();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        builder.addAnimatedRecipeArrow(cookTime).setPosition(26, 17);
        builder.addAnimatedRecipeFlame(300).setPosition(1, 20);
        this.addExperience(builder, recipe);
        this.addCookTime(builder, recipe);
    }

    protected void addExperience(IRecipeExtrasBuilder builder, T recipe) {
        float experience = recipe.method_8171();
        if (experience > 0.0f) {
            class_5250 experienceString = class_2561.method_43469((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            ((ITextWidget)builder.addText((class_5348)experienceString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.TOP)).setTextAlignment(HorizontalAlignment.RIGHT).setColor(-8355712);
        }
    }

    protected void addCookTime(IRecipeExtrasBuilder builder, T recipe) {
        int cookTime = recipe.method_8167();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            class_5250 timeString = class_2561.method_43469((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            ((ITextWidget)builder.addText((class_5348)timeString, this.getWidth() - 20, 10).setPosition(0, 0, this.getWidth(), this.getHeight(), HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM)).setTextAlignment(HorizontalAlignment.RIGHT).setTextAlignment(VerticalAlignment.BOTTOM).setColor(-8355712);
        }
    }

    @Override
    public boolean isHandled(T recipe) {
        return !recipe.method_8118();
    }

    @Override
    public class_2960 getRegistryName(T recipe) {
        return recipe.method_8114();
    }
}

