/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.ingredients.IngredientSet;
import mezz.jei.library.util.ResourceLocationUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrewingRecipeMakerCommon {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Set<IJeiBrewingRecipe> getVanillaBrewingRecipes(IVanillaRecipeFactory recipeFactory, IIngredientManager ingredientManager) {
        boolean foundNewPotions;
        HashSet<IJeiBrewingRecipe> recipes = new HashSet<IJeiBrewingRecipe>();
        IPlatformRegistry<class_1842> potionRegistry = Services.PLATFORM.getRegistry(class_7924.field_41215);
        IIngredientHelper<class_1799> itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet<class_1799> knownPotions = BrewingRecipeMakerCommon.getBaseKnownPotions(ingredientManager, potionRegistry);
        IngredientSet potionReagents = ingredientManager.getAllItemStacks().stream().filter(BrewingRecipeMakerCommon::isIngredient).collect(Collectors.toCollection(() -> new IngredientSet(itemStackHelper, UidContext.Ingredient)));
        do {
            List<class_1799> newPotions;
            foundNewPotions = !(newPotions = BrewingRecipeMakerCommon.getNewPotions(recipeFactory, itemStackHelper, knownPotions, potionReagents, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
        return recipes;
    }

    private static boolean isIngredient(class_1799 itemStack) {
        try {
            return class_1845.method_8077((class_1799)itemStack);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is a potion reagent {}.", (Object)itemStackInfo, (Object)e);
            return false;
        }
    }

    private static IngredientSet<class_1799> getBaseKnownPotions(IIngredientManager ingredientManager, IPlatformRegistry<class_1842> potionRegistry) {
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        IIngredientHelper itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet potionContainers = ingredientHelper.getPotionContainers().stream().flatMap(potionItem -> Arrays.stream(potionItem.method_8105())).collect(Collectors.toCollection(() -> new IngredientSet(itemStackHelper, UidContext.Ingredient)));
        IngredientSet<class_1799> knownPotions = new IngredientSet<class_1799>(itemStackHelper, UidContext.Ingredient);
        knownPotions.addAll(potionContainers);
        potionRegistry.getValues().filter(potion -> potion != class_1847.field_8984).forEach(potion -> {
            for (class_1799 potionContainer : potionContainers) {
                class_1799 result = class_1844.method_8061((class_1799)potionContainer.method_7972(), (class_1842)potion);
                knownPotions.add(result);
            }
        });
        return knownPotions;
    }

    private static List<class_1799> getNewPotions(IVanillaRecipeFactory recipeFactory, IIngredientHelper<class_1799> itemStackHelper, Collection<class_1799> knownPotions, Collection<class_1799> potionReagents, Collection<IJeiBrewingRecipe> recipes) {
        ArrayList<class_1799> newPotions = new ArrayList<class_1799>();
        for (class_1799 potionInput : knownPotions) {
            String inputId = itemStackHelper.getUniqueId(potionInput, UidContext.Recipe);
            String inputPathId = ResourceLocationUtil.sanitizePath(inputId);
            for (class_1799 potionReagent : potionReagents) {
                String outputId;
                class_1842 potionOutputType;
                class_1799 potionOutput = BrewingRecipeMakerCommon.getOutput(potionInput.method_7972(), potionReagent);
                if (potionOutput.method_7960() || potionInput.method_7909() instanceof class_1812 && potionOutput.method_7909() instanceof class_1812 && (potionOutputType = class_1844.method_8063((class_1799)potionOutput)) == class_1847.field_8991 || Objects.equals(inputId, outputId = itemStackHelper.getUniqueId(potionOutput, UidContext.Recipe))) continue;
                String outputModId = itemStackHelper.getResourceLocation(potionOutput).method_12836();
                String uidPath = inputPathId + ".to." + ResourceLocationUtil.sanitizePath(outputId);
                IJeiBrewingRecipe recipe = recipeFactory.createBrewingRecipe(List.of(potionReagent), potionInput.method_7972(), potionOutput, new class_2960(outputModId, uidPath));
                if (recipes.contains(recipe)) continue;
                recipes.add(recipe);
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    private static class_1799 getOutput(class_1799 potion, class_1799 itemStack) {
        class_1799 result = class_1845.method_8078((class_1799)itemStack, (class_1799)potion);
        if (result != itemStack) {
            return result;
        }
        return class_1799.field_8037;
    }
}

