/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.misc;

import com.mojang.blaze3d.platform.NativeImage;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL32;

public class LightMapWrapper
implements ILightMapWrapper {
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private int textureId = 0;

    public void uploadLightmap(NativeImage image) {
        int currentTexture = GLMC.getActiveTexture();
        if (this.textureId == 0) {
            this.createLightmap(image);
        } else {
            GLMC.glBindTexture(this.textureId);
        }
        image.m_85040_(0, 0, 0, false);
        if (GL32.glIsTexture((int)currentTexture)) {
            GLMC.glBindTexture(currentTexture);
        }
    }

    private void createLightmap(NativeImage image) {
        this.textureId = GLMC.glGenTextures();
        GLMC.glBindTexture(this.textureId);
        GL32.glTexImage2D((int)3553, (int)0, (int)image.m_85102_().m_85170_(), (int)image.m_84982_(), (int)image.m_85084_(), (int)0, (int)image.m_85102_().m_85170_(), (int)5121, (ByteBuffer)null);
    }

    public void setLightmapId(int minecraftLightmapTetxureId) {
        this.textureId = minecraftLightmapTetxureId;
    }

    @Override
    public void bind() {
        GLMC.glActiveTexture(33984);
        GLMC.glBindTexture(this.textureId);
    }

    @Override
    public void unbind() {
        GLMC.glBindTexture(0);
    }
}

