/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling.ChunkFileReader;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import org.jetbrains.annotations.Nullable;

public class RegionFileStorageExternalCache
implements AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    @Nullable
    public final RegionFileStorage storage;
    public static final int MAX_CACHE_SIZE = 16;
    public static boolean regionCacheNullPointerWarningSent = false;
    ReentrantLock getRegionFileLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<RegionFileCache> regionFileCache = new ConcurrentLinkedQueue();

    public RegionFileStorageExternalCache(RegionFileStorage storage) {
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public RegionFile getRegionFile(ChunkPos chunkPos) throws IOException {
        if (this.storage == null) {
            if (!regionCacheNullPointerWarningSent) {
                regionCacheNullPointerWarningSent = true;
                LOGGER.warn("Unable to access Minecraft's chunk cache. This may be due to another mod changing said cache. DH will be unable to access any Minecraft chunk data until said mod is removed.", new Object[0]);
            }
            return null;
        }
        long chunkPosLong = ChunkPos.m_45589_((int)chunkPos.m_45610_(), (int)chunkPos.m_45612_());
        RegionFile regionFile = null;
        int retryCount = 0;
        int maxRetryCount = 8;
        while (retryCount < maxRetryCount) {
            ++retryCount;
            try {
                this.getRegionFileLock.lock();
                regionFile = (RegionFile)this.storage.f_63699_.getOrDefault(chunkPosLong, null);
                break;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (NullPointerException e) {
                if (regionCacheNullPointerWarningSent) break;
                regionCacheNullPointerWarningSent = true;
                LOGGER.warn("Unable to access Minecraft's chunk cache. This may be due to another mod changing said cache. Falling back to DH's internal cache.", new Object[0]);
                break;
            }
            finally {
                this.getRegionFileLock.unlock();
            }
        }
        if (retryCount >= maxRetryCount) {
            ChunkFileReader.CHUNK_LOAD_LOGGER.warn("Concurrency issue detected when getting region file for chunk at [" + String.valueOf(chunkPos) + "].", new Object[0]);
        }
        if (regionFile != null) {
            return regionFile;
        }
        for (RegionFileCache cache : this.regionFileCache) {
            if (cache.pos != chunkPosLong) continue;
            return cache.file;
        }
        Path storageFolderPath = this.storage.f_63700_;
        if (!Files.exists(storageFolderPath, new LinkOption[0])) {
            return null;
        }
        Path regionFilePath = storageFolderPath.resolve("r." + chunkPos.m_45610_() + "." + chunkPos.m_45612_() + ".mca");
        regionFile = new RegionFile(regionFilePath, storageFolderPath, false);
        this.regionFileCache.add(new RegionFileCache(ChunkPos.m_45589_((int)chunkPos.m_45610_(), (int)chunkPos.m_45612_()), regionFile));
        while (this.regionFileCache.size() > 16) {
            this.regionFileCache.poll().file.close();
        }
        return regionFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public CompoundTag read(ChunkPos pos) throws IOException {
        RegionFile file = this.getRegionFile(pos);
        if (file == null) {
            return null;
        }
        try (DataInputStream stream = file.m_63645_(pos);){
            if (stream == null) {
                CompoundTag compoundTag2 = null;
                return compoundTag2;
            }
            CompoundTag compoundTag = NbtIo.m_128928_((DataInput)stream);
            return compoundTag;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        RegionFileCache cache;
        while ((cache = this.regionFileCache.poll()) != null) {
            cache.file.close();
        }
    }

    private static class RegionFileCache {
        public final long pos;
        public final RegionFile file;

        public RegionFileCache(long pos, RegionFile file) {
            this.pos = pos;
            this.file = file;
        }
    }
}

