/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.infrastructure;

import io.github.mortuusars.exposure.util.Fov;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;

public class EntitiesInFrame {
    public static List<class_1297> get(class_1657 player, double fov, int limit, boolean inSelfieMode) {
        double currentFov = fov / (double)1.142857f;
        double currentFocalLength = Fov.fovToFocalLength(currentFov);
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        List entities = player.method_37908().method_8333((class_1297)player, new class_238(player.method_24515()).method_1014(128.0), entity -> entity instanceof class_1309);
        entities.sort((entity, entity2) -> {
            float dist2;
            float dist1 = player.method_5739(entity);
            if (dist1 == (dist2 = player.method_5739(entity2))) {
                return 0;
            }
            return dist1 > dist2 ? 1 : -1;
        });
        ArrayList<class_1297> entitiesInFrame = new ArrayList<class_1297>();
        for (class_1297 entity3 : entities) {
            if (entitiesInFrame.size() >= limit) break;
            if (!EntitiesInFrame.isInFOV(currentFov, entity3) || EntitiesInFrame.getPerceivedDistance(cameraPos, entity3) > currentFocalLength || !player.method_6057(entity3)) continue;
            entitiesInFrame.add(entity3);
        }
        if (inSelfieMode) {
            entitiesInFrame.add(0, (class_1297)player);
        }
        return entitiesInFrame;
    }

    public static double getPerceivedDistance(class_243 cameraPos, class_1297 entity) {
        double distanceInBlocks = Math.sqrt(entity.method_5707(cameraPos));
        class_238 boundingBox = entity.method_5830();
        double size = boundingBox.method_995();
        if (Double.isNaN(size) || size == 0.0) {
            size = 0.1;
        }
        double sizeModifier = (size - 1.0) * 0.6 + 1.0;
        return distanceInBlocks / sizeModifier / (double)1.142857f;
    }

    public static boolean isInFOV(double fov, class_1297 target) {
        class_243 targetEyePos;
        class_243 cameraLookAngle;
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        double relativeAngle = EntitiesInFrame.getRelativeAngle(cameraPos, cameraLookAngle = new class_243(camera.method_19335()), targetEyePos = target.method_19538().method_1031(0.0, (double)target.method_5751(), 0.0));
        return relativeAngle <= fov / 2.0;
    }

    public static double getRelativeAngle(class_243 cameraPos, class_243 cameraLookAngle, class_243 targetEyePos) {
        class_243 originToTargetAngle = targetEyePos.method_1020(cameraPos).method_1029();
        return Math.toDegrees(Math.acos(cameraLookAngle.method_1026(originToTargetAngle)));
    }
}

