/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui;

import io.github.mortuusars.exposure.gui.screen.PhotographScreen;
import io.github.mortuusars.exposure.gui.screen.camera.ViewfinderControlsScreen;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.recipe.FilmDevelopingRecipe;
import io.github.mortuusars.exposure.recipe.PhotographCopyingRecipe;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientGUI {
    public static void openPhotographScreen(List<ItemAndStack<PhotographItem>> photographs) {
        class_310.method_1551().method_1507((class_437)new PhotographScreen(photographs));
    }

    public static void openViewfinderControlsScreen() {
        class_310.method_1551().method_1507((class_437)new ViewfinderControlsScreen());
    }

    public static void addFilmRollDevelopingTooltip(class_1799 filmStack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        ClientGUI.addRecipeTooltip(filmStack, level, tooltipComponents, isAdvanced, r -> {
            FilmDevelopingRecipe filmDevelopingRecipe;
            return r instanceof FilmDevelopingRecipe && (filmDevelopingRecipe = (FilmDevelopingRecipe)((Object)r)).getTransferIngredient().method_8093(filmStack);
        }, "item.exposure.film_roll.tooltip.details.develop");
    }

    public static void addPhotographCopyingTooltip(class_1799 photographStack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced) {
        ClientGUI.addRecipeTooltip(photographStack, level, tooltipComponents, isAdvanced, r -> {
            PhotographCopyingRecipe photographCopyingRecipe;
            return r instanceof PhotographCopyingRecipe && (photographCopyingRecipe = (PhotographCopyingRecipe)((Object)r)).getTransferIngredient().method_8093(photographStack);
        }, "item.exposure.photograph.tooltip.details.copy");
    }

    private static void addRecipeTooltip(class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 isAdvanced, Predicate<class_3955> recipeFilter, String detailsKey) {
        if (level == null) {
            return;
        }
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.exposure.hold_for_details"));
        if (!class_437.method_25442()) {
            return;
        }
        Optional<class_2371> recipeIngredients = level.method_8433().method_30027(class_3956.field_17545).stream().filter(recipeFilter).findFirst().map(class_1860::method_8117);
        if (recipeIngredients.isEmpty() || recipeIngredients.get().isEmpty()) {
            return;
        }
        class_2371 ingredients = recipeIngredients.get();
        tooltipComponents.add((class_2561)class_2561.method_43473());
        class_2583 orange = class_2583.field_24360.method_36139(13079883);
        class_2583 yellow = class_2583.field_24360.method_36139(15653496);
        tooltipComponents.add((class_2561)class_2561.method_43471((String)detailsKey).method_27696(orange));
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1799[] stacks = ((class_1856)ingredients.get(i)).method_8105();
            if (stacks.length == 0) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)class_2561.method_43470((String)"?").method_27696(yellow)));
                continue;
            }
            if (stacks.length == 1) {
                tooltipComponents.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)stacks[0].method_7964().method_27661().method_27696(yellow)));
                continue;
            }
            int val = (int)Math.ceil((float)(level.method_8510() + (long)(10 * i)) % (20.0f * (float)stacks.length) / 20.0f);
            int index = class_3532.method_15340((int)(val - 1), (int)0, (int)(stacks.length - 1));
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)stacks[index].method_7964().method_27661().method_27696(yellow)));
        }
    }
}

