/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.camera.capture.converter.DitheringColorConverter;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.CreateChromaticExposureS2CP;
import io.github.mortuusars.exposure.network.packet.client.WaitForExposureChangeS2CP;
import io.github.mortuusars.exposure.render.image.ExposureDataImage;
import io.github.mortuusars.exposure.render.image.IImage;
import io.github.mortuusars.exposure.util.ColorChannel;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChromaticSheetItem
extends class_1792 {
    public static final String EXPOSURES_TAG = "Exposures";

    public ChromaticSheetItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public List<class_2487> getExposures(class_1799 stack) {
        if (stack.method_7969() == null || !stack.method_7969().method_10573(EXPOSURES_TAG, 9)) {
            return Collections.emptyList();
        }
        class_2499 channelsList = stack.method_7969().method_10554(EXPOSURES_TAG, 10);
        return channelsList.stream().map(t -> (class_2487)t).collect(Collectors.toList());
    }

    public void addExposure(class_1799 stack, class_2487 frame) {
        class_2499 channelsList = this.getOrCreateExposuresTag(stack);
        channelsList.add((Object)frame);
        stack.method_7948().method_10566(EXPOSURES_TAG, (class_2520)channelsList);
    }

    private class_2499 getOrCreateExposuresTag(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        class_2499 list = tag.method_10554(EXPOSURES_TAG, 10);
        tag.method_10566(EXPOSURES_TAG, (class_2520)list);
        return list;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        List<class_2487> exposures = this.getExposures(stack);
        if (!exposures.isEmpty()) {
            class_5250 component = class_2561.method_43471((String)"gui.exposure.channel.red").method_27696(class_2583.field_24360.method_36139(ColorChannel.RED.getRepresentationColor()));
            if (exposures.size() >= 2) {
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.separator").method_27692(class_124.field_1080));
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.green").method_27696(class_2583.field_24360.method_36139(ColorChannel.GREEN.getRepresentationColor())));
            }
            if (exposures.size() >= 3) {
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.separator").method_27692(class_124.field_1080));
                component.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure.channel.blue").method_27696(class_2583.field_24360.method_36139(ColorChannel.BLUE.getRepresentationColor())));
            }
            tooltipComponents.add((class_2561)component);
            if (exposures.size() >= 3) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.exposure.chromatic_sheet.use_tooltip").method_27692(class_124.field_1080));
            } else {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"item.exposure.chromatic_sheet.info").method_27692(class_124.field_1080));
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (stack.method_7969() != null && stack.method_7969().method_10577("RequiresDeferredFinalization")) {
                class_1799 finalizedItem = this.finalize(level, stack, player.method_5820(), player);
                player.method_31548().method_5447(slotId, finalizedItem);
            }
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 stack = player.method_5998(usedHand);
        if (!level.field_9236 && this.getExposures(stack).size() >= 3) {
            class_3222 serverPlayer;
            class_1799 result = this.finalize(level, stack, player.method_5820(), player instanceof class_3222 ? (serverPlayer = (class_3222)player) : null);
            player.method_6122(usedHand, result);
            return class_1271.method_22427((Object)result);
        }
        return super.method_7836(level, player, usedHand);
    }

    public class_1799 finalize(@NotNull class_1937 level, class_1799 stack, String idPrefix, @Nullable class_3222 player) {
        Preconditions.checkState((!level.field_9236 ? 1 : 0) != 0, (Object)"Can only finalize server-side.");
        List<class_2487> exposures = this.getExposures(stack);
        Preconditions.checkState((exposures.size() >= 3 ? 1 : 0) != 0, (Object)("Finalizing Chromatic Fragment requires 3 exposures. " + String.valueOf(stack)));
        class_2487 redFrame = exposures.get(0);
        class_2487 greenFrame = exposures.get(1);
        class_2487 blueFrame = exposures.get(2);
        String exposureId = ChromaticSheetItem.getChromaticExposureId(level, idPrefix);
        class_1799 photograph = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
        class_2487 tag = redFrame.method_10553();
        tag = tag.method_10543(greenFrame);
        tag = tag.method_10543(blueFrame);
        tag.method_10551("ChromaticChannel");
        tag.method_10582("Id", exposureId);
        tag.method_10556("Chromatic", true);
        tag.method_10582("RedChannel", this.getFrameName(redFrame));
        tag.method_10582("GreenChannel", this.getFrameName(greenFrame));
        tag.method_10582("BlueChannel", this.getFrameName(blueFrame));
        tag.method_10582("Type", FilmType.COLOR.method_15434());
        photograph.method_7980(tag);
        boolean hasTexture = this.hasTextureFrame(redFrame, greenFrame, blueFrame);
        if (!hasTexture) {
            return this.finalizeServerside(stack, photograph, level, exposureId, redFrame, greenFrame, blueFrame);
        }
        if (player != null) {
            Packets.sendToClient(new CreateChromaticExposureS2CP(redFrame, greenFrame, blueFrame, exposureId), player);
            return photograph;
        }
        stack.method_7948().method_10556("RequiresDeferredFinalization", true);
        return stack;
    }

    @NotNull
    private static String getChromaticExposureId(@NotNull class_1937 level, String idPrefix) {
        return String.format("%s_chromatic_%s", idPrefix, level.method_8510());
    }

    protected String getFrameName(class_2487 frame) {
        if (frame.method_10545("Id")) {
            return frame.method_10558("Id");
        }
        if (frame.method_10545("Texture")) {
            return frame.method_10558("Texture");
        }
        return "unknown";
    }

    protected boolean hasTextureFrame(class_2487 red, class_2487 green, class_2487 blue) {
        if (!red.method_10545("Id") && red.method_10545("Texture")) {
            return true;
        }
        if (!green.method_10545("Id") && green.method_10545("Texture")) {
            return true;
        }
        return !blue.method_10545("Id") && blue.method_10545("Texture");
    }

    protected class_1799 finalizeServerside(class_1799 chromaticSheetStack, class_1799 photographStack, @NotNull class_1937 level, String exposureId, class_2487 redFrame, class_2487 greenFrame, class_2487 blueFrame) {
        @Nullable IImage redImage = this.getExposureImage(redFrame);
        if (redImage == null) {
            Exposure.LOGGER.error("Cannot create Chromatic Photograph: Red channel image is not found in frame {}.", (Object)redFrame);
            return chromaticSheetStack;
        }
        @Nullable IImage greenImage = this.getExposureImage(greenFrame);
        if (greenImage == null) {
            Exposure.LOGGER.error("Cannot create Chromatic Photograph: Green channel image is not found in frame {}.", (Object)greenFrame);
            return chromaticSheetStack;
        }
        @Nullable IImage blueImage = this.getExposureImage(blueFrame);
        if (blueImage == null) {
            Exposure.LOGGER.error("Cannot create Chromatic Photograph: Blue channel image is not found in frame {}.", (Object)blueFrame);
            return chromaticSheetStack;
        }
        Packets.sendToAllClients(new WaitForExposureChangeS2CP(exposureId));
        new Thread(() -> {
            try {
                this.processAndSaveTrichrome(redImage, greenImage, blueImage, exposureId);
            }
            catch (Exception e) {
                Exposure.LOGGER.error("Cannot process and save Chromatic Photograph: {}", (Object)e.toString());
            }
        }).start();
        return photographStack;
    }

    @Nullable
    protected IImage getExposureImage(class_2487 frame) {
        if (frame.method_10573("Id", 8)) {
            String exposureId = frame.method_10558("Id");
            return ExposureServer.getExposureStorage().getOrQuery(exposureId).map(data -> new ExposureDataImage(exposureId, (ExposureSavedData)((Object)data))).orElse(null);
        }
        return null;
    }

    protected boolean processAndSaveTrichrome(IImage red, IImage green, IImage blue, String id) {
        int width = Math.min(red.getWidth(), Math.min(green.getWidth(), blue.getWidth()));
        int height = Math.min(red.getHeight(), Math.min(green.getHeight(), blue.getHeight()));
        if (width <= 0 || height <= 0) {
            Exposure.LOGGER.error("Cannot create Chromatic Photograph: Width and Height should be larger than 0. Width '{}', Height: '{}'.", (Object)width, (Object)height);
            return false;
        }
        int[][] pixels = new int[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int abgr;
                int a = class_5253.class_8045.method_48342((int)red.getPixelABGR(x, y));
                int b = class_5253.class_8045.method_48347((int)blue.getPixelABGR(x, y));
                int g = class_5253.class_8045.method_48346((int)green.getPixelABGR(x, y));
                int r = class_5253.class_8045.method_48345((int)red.getPixelABGR(x, y));
                pixels[y][x] = abgr = class_5253.class_5254.method_27764((int)a, (int)r, (int)g, (int)b);
            }
        }
        byte[] mapColorPixels = new DitheringColorConverter().convert(pixels);
        class_2487 properties = new class_2487();
        properties.method_10582("Type", FilmType.COLOR.method_15434());
        long unixTime = System.currentTimeMillis() / 1000L;
        properties.method_10544("Timestamp", unixTime);
        ExposureSavedData resultData = new ExposureSavedData(width, height, mapColorPixels, properties);
        ExposureServer.getExposureStorage().put(id, resultData);
        ExposureServer.getExposureStorage().sendExposureChanged(id);
        return true;
    }
}

