/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.client;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.infrastructure.FocalRange;
import io.github.mortuusars.exposure.network.PacketDirection;
import io.github.mortuusars.exposure.network.handler.ClientPacketsHandler;
import io.github.mortuusars.exposure.network.packet.IPacket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1657;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public record SyncLensesS2CP(ConcurrentMap<class_1856, FocalRange> lenses) implements IPacket
{
    public static final class_2960 ID = Exposure.resource("sync_lenses");

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public class_2540 toBuffer(class_2540 buffer) {
        buffer.method_10804(this.lenses.size());
        for (Map.Entry lens : this.lenses.entrySet()) {
            class_1856 ingredient = (class_1856)lens.getKey();
            ingredient.method_8088(buffer);
            FocalRange focalRange = (FocalRange)lens.getValue();
            focalRange.toNetwork(buffer);
        }
        return buffer;
    }

    public static SyncLensesS2CP fromBuffer(class_2540 buffer) {
        ConcurrentHashMap<class_1856, FocalRange> lenses = new ConcurrentHashMap<class_1856, FocalRange>();
        int lensCount = buffer.method_10816();
        for (int i = 0; i < lensCount; ++i) {
            class_1856 ingredient = class_1856.method_8086((class_2540)buffer);
            FocalRange focalRange = FocalRange.fromNetwork(buffer);
            lenses.put(ingredient, focalRange);
        }
        return new SyncLensesS2CP(lenses);
    }

    @Override
    public boolean handle(PacketDirection direction, @Nullable class_1657 player) {
        ClientPacketsHandler.syncLenses(this);
        return true;
    }
}

