/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.entity.PhotographFrameEntity;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1944;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5617;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

public class PhotographFrameEntityRenderer<T extends PhotographFrameEntity>
extends class_897<T> {
    private final class_776 blockRenderer;

    public PhotographFrameEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.blockRenderer = context.method_43337();
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull T pEntity) {
        return class_1723.field_21668;
    }

    public boolean shouldRender(T livingEntity, class_4604 camera, double camX, double camY, double camZ) {
        return super.method_3933(livingEntity, camera, camX, camY, camZ);
    }

    public void render(@NotNull T entity, float entityYaw, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight) {
        class_1799 item;
        class_3966 entityHitResult;
        class_239 class_2392 = class_310.method_1551().field_1765;
        if (class_2392 instanceof class_3966 && (entityHitResult = (class_3966)class_2392).method_17782() == entity) {
            class_310.method_1551().field_1692 = entity;
        }
        class_2350 direction = entity.method_5735();
        int size = ((PhotographFrameEntity)((Object)entity)).getSize();
        boolean isStripped = ((PhotographFrameEntity)((Object)entity)).isStripped();
        poseStack.method_22903();
        poseStack.method_46416((float)direction.method_10148() * 0.3f, (float)direction.method_10164() * 0.3f, (float)direction.method_10165() * 0.3f);
        super.method_3936(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.method_22909();
        poseStack.method_22903();
        double hangOffset = 0.46875;
        poseStack.method_22904((double)direction.method_10148() * hangOffset, (double)direction.method_10164() * hangOffset, (double)direction.method_10165() * hangOffset);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(entity.method_36455()));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - entity.method_36454()));
        if (!entity.method_5767()) {
            this.renderFrame(entity, poseStack, bufferSource, packedLight, size, isStripped);
        }
        if (!(item = ((PhotographFrameEntity)((Object)entity)).getItem()).method_7960()) {
            this.renderPhotograph(entity, poseStack, bufferSource, packedLight, item, size, isStripped);
        }
        poseStack.method_22909();
    }

    private void renderFrame(@NotNull T entity, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight, int size, boolean isStripped) {
        poseStack.method_22903();
        poseStack.method_46416(-0.5f, -0.5f, -0.5f);
        class_1091 modelLocation = this.getModelLocation(entity, size, isStripped);
        class_1087 model = this.blockRenderer.method_3351().method_3333().method_4742(modelLocation);
        this.blockRenderer.method_3350().method_3367(poseStack.method_23760(), bufferSource.getBuffer(class_4722.method_24073()), null, model, 1.0f, 1.0f, 1.0f, packedLight, class_4608.field_21444);
        poseStack.method_22909();
    }

    public class_1091 getModelLocation(T entity, int size, boolean isStripped) {
        if (size == 0) {
            return isStripped ? ExposureClient.Models.PHOTOGRAPH_FRAME_SMALL_STRIPPED : ExposureClient.Models.PHOTOGRAPH_FRAME_SMALL;
        }
        if (size == 1) {
            return isStripped ? ExposureClient.Models.PHOTOGRAPH_FRAME_MEDIUM_STRIPPED : ExposureClient.Models.PHOTOGRAPH_FRAME_MEDIUM;
        }
        return isStripped ? ExposureClient.Models.PHOTOGRAPH_FRAME_LARGE_STRIPPED : ExposureClient.Models.PHOTOGRAPH_FRAME_LARGE;
    }

    private void renderPhotograph(@NotNull T entity, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight, class_1799 item, int size, boolean isStripped) {
        poseStack.method_22903();
        boolean frameInvisible = entity.method_5767();
        float frameBorderOffset = frameInvisible || isStripped ? 0.0f : 0.125f;
        float offsetFromCenter = frameInvisible ? 0.497f : 0.48f;
        float desiredSize = (float)(size + 1) - frameBorderOffset * 2.0f;
        float scale = desiredSize / (float)ExposureClient.getExposureRenderer().getSize();
        poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)((PhotographFrameEntity)((Object)entity)).getItemRotation() * 360.0f / 4.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        poseStack.method_22904(-0.5 * (double)(size + 1) + (double)frameBorderOffset, -0.5 * (double)(size + 1) + (double)frameBorderOffset, (double)offsetFromCenter);
        poseStack.method_22905(scale, scale, 1.0f);
        boolean isGlowing = ((PhotographFrameEntity)((Object)entity)).isGlowing();
        if (isGlowing) {
            packedLight = 0xF000F0;
        }
        int brightness = isGlowing ? 255 : this.getPhotographBrightness(entity);
        PhotographRenderer.render(item, false, false, poseStack, bufferSource, packedLight, brightness, brightness, brightness, 255);
        poseStack.method_22909();
    }

    public int getPhotographBrightness(T entity) {
        if (entity.method_5735() == class_2350.field_11036) {
            return 255;
        }
        int lightLevel = entity.method_37908().method_8314(class_1944.field_9282, entity.method_24515());
        float shadeFactor = entity.method_37908().method_24852(entity.method_5735(), true);
        shadeFactor += (1.0f - shadeFactor) * 0.2f;
        int shadedBrightness = (int)(255.0f * shadeFactor);
        int missingLight = 255 - shadedBrightness;
        int lightUp = (int)((float)missingLight * ((float)lightLevel / 15.0f * 0.5f));
        return Math.min(255, shadedBrightness + lightUp);
    }

    protected boolean shouldShowName(T entity) {
        if (class_310.method_1498() && !((PhotographFrameEntity)((Object)entity)).getItem().method_7960() && ((PhotographFrameEntity)((Object)entity)).getItem().method_7938() && class_310.method_1551().field_1692 == entity) {
            double distSqr = class_310.method_1551().field_1692.method_5858(entity);
            float showRangeSqr = entity.method_21751() ? 32.0f : 64.0f;
            return distSqr < (double)(showRangeSqr * showRangeSqr);
        }
        return false;
    }

    protected void renderNameTag(T entity, class_2561 displayName, class_4587 poseStack, class_4597 buffer, int packedLight) {
        super.method_3926(entity, ((PhotographFrameEntity)((Object)entity)).getItem().method_7964(), poseStack, buffer, packedLight);
    }
}

