/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.render.PhotographRenderProperties;
import io.github.mortuusars.exposure.render.image.RenderedImageProvider;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class PhotographRenderer {
    public static void render(class_1799 stack, boolean renderPaper, boolean renderBackside, class_4587 poseStack, class_4597 bufferSource, int packedLight, int r, int g, int b, int a) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof PhotographItem) {
            PhotographItem photographItem = (PhotographItem)class_17922;
            PhotographRenderer.renderPhotograph(photographItem, stack, renderPaper, renderBackside, poseStack, bufferSource, packedLight, r, g, b, a);
        } else {
            class_17922 = stack.method_7909();
            if (class_17922 instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)class_17922;
                PhotographRenderer.renderStackedPhotographs(stackedPhotographsItem, stack, poseStack, bufferSource, packedLight, r, g, b, a);
            }
        }
    }

    public static void renderPhotograph(PhotographItem photographItem, class_1799 stack, boolean renderPaper, boolean renderBackside, class_4587 poseStack, class_4597 bufferSource, int packedLight, int r, int g, int b, int a) {
        PhotographRenderProperties properties = PhotographRenderProperties.get(stack);
        int size = ExposureClient.getExposureRenderer().getSize();
        float rotateOffset = (float)size / 2.0f;
        @Nullable class_2487 frame = stack.method_7969();
        RenderedImageProvider imageProvider = frame != null ? RenderedImageProvider.fromFrame(frame) : RenderedImageProvider.EMPTY;
        int rotation = imageProvider.getInstanceId().hashCode() % 4;
        if (renderPaper) {
            poseStack.method_22903();
            poseStack.method_46416(rotateOffset, rotateOffset, 0.0f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)(rotation * 90)));
            poseStack.method_46416(-rotateOffset, -rotateOffset, 0.0f);
            PhotographRenderer.renderTexture(properties.getPaperTexture(), poseStack, bufferSource, 0.0f, 0.0f, size, size, packedLight, r, g, b, a);
            poseStack.method_22909();
            if (renderBackside) {
                poseStack.method_22903();
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                poseStack.method_22904((double)(-size), 0.0, -0.5);
                poseStack.method_46416(rotateOffset, rotateOffset, 0.0f);
                poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)(rotation * 90)));
                poseStack.method_46416(-rotateOffset, -rotateOffset, 0.0f);
                PhotographRenderer.renderTexture(properties.getPaperTexture(), poseStack, bufferSource, packedLight, (int)((float)r * 0.85f), (int)((float)g * 0.85f), (int)((float)b * 0.85f), a);
                poseStack.method_22909();
            }
        }
        if (renderPaper) {
            poseStack.method_22903();
            float offset = (float)size * 0.0625f;
            poseStack.method_46416(offset, offset, 1.0f);
            poseStack.method_22905(0.875f, 0.875f, 0.875f);
            ExposureClient.getExposureRenderer().render(imageProvider, properties.getModifier(), poseStack, bufferSource, packedLight, r, g, b, a);
            poseStack.method_22909();
        } else {
            ExposureClient.getExposureRenderer().render(imageProvider, properties.getModifier(), poseStack, bufferSource, packedLight, r, g, b, a);
        }
        if (renderPaper && properties.hasPaperOverlayTexture()) {
            poseStack.method_22903();
            poseStack.method_46416(rotateOffset, rotateOffset, 0.0f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)(rotation * 90)));
            poseStack.method_46416(-rotateOffset, -rotateOffset, 0.0f);
            poseStack.method_46416(0.0f, 0.0f, 2.0f);
            PhotographRenderer.renderTexture(properties.getPaperOverlayTexture(), poseStack, bufferSource, packedLight, r, g, b, a);
            poseStack.method_22909();
        }
    }

    public static void renderStackedPhotographs(StackedPhotographsItem stackedPhotographsItem, class_1799 stack, class_4587 poseStack, class_4597 bufferSource, int packedLight, int r, int g, int b, int a) {
        List<ItemAndStack<PhotographItem>> photographs = stackedPhotographsItem.getPhotographs(stack, 3);
        PhotographRenderer.renderStackedPhotographs(photographs, poseStack, bufferSource, packedLight, r, g, b, a);
    }

    public static void renderStackedPhotographs(List<ItemAndStack<PhotographItem>> photographs, class_4587 poseStack, class_4597 bufferSource, int packedLight, int r, int g, int b, int a) {
        if (photographs.isEmpty()) {
            return;
        }
        for (int i = 2; i >= 0; --i) {
            if (photographs.size() - 1 < i) continue;
            ItemAndStack<PhotographItem> photograph = photographs.get(i);
            PhotographRenderProperties properties = PhotographRenderProperties.get(photograph.getStack());
            if (i == 0) {
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 0.0f, 2.0f);
                PhotographRenderer.renderPhotograph(photograph.getItem(), photograph.getStack(), true, false, poseStack, bufferSource, packedLight, r, g, b, a);
                poseStack.method_22909();
                break;
            }
            @Nullable class_2487 frame = photograph.getStack().method_7969();
            RenderedImageProvider imageProvider = frame != null ? RenderedImageProvider.fromFrame(frame) : RenderedImageProvider.EMPTY;
            int rotation = imageProvider.getInstanceId().hashCode() % 4;
            float posOffset = PhotographRenderer.getStackedPhotographOffset() * (float)i;
            float rotateOffset = (float)ExposureClient.getExposureRenderer().getSize() / 2.0f;
            poseStack.method_22903();
            poseStack.method_46416(posOffset, posOffset, (float)(2 - i));
            poseStack.method_46416(rotateOffset, rotateOffset, 0.0f);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)(rotation * 90)));
            poseStack.method_46416(-rotateOffset, -rotateOffset, 0.0f);
            float brightnessMul = 1.0f - PhotographRenderer.getStackedBrightnessStep() * (float)i;
            PhotographRenderer.renderTexture(properties.getPaperTexture(), poseStack, bufferSource, packedLight, (int)((float)r * brightnessMul), (int)((float)g * brightnessMul), (int)((float)b * brightnessMul), a);
            poseStack.method_22909();
        }
    }

    public static float getStackedBrightnessStep() {
        return 0.15f;
    }

    public static float getStackedPhotographOffset() {
        return (float)ExposureClient.getExposureRenderer().getSize() * 0.03125f;
    }

    private static void renderTexture(class_2960 resource, class_4587 poseStack, class_4597 bufferSource, int packedLight, int r, int g, int b, int a) {
        PhotographRenderer.renderTexture(resource, poseStack, bufferSource, 0.0f, 0.0f, ExposureClient.getExposureRenderer().getSize(), ExposureClient.getExposureRenderer().getSize(), packedLight, r, g, b, a);
    }

    private static void renderTexture(class_2960 resource, class_4587 poseStack, class_4597 bufferSource, float x, float y, float width, float height, int packedLight, int r, int g, int b, int a) {
        PhotographRenderer.renderTexture(resource, poseStack, bufferSource, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, packedLight, r, g, b, a);
    }

    private static void renderTexture(class_2960 resource, class_4587 poseStack, class_4597 bufferSource, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, int packedLight, int r, int g, int b, int a) {
        RenderSystem.setShaderTexture((int)0, (class_2960)resource);
        RenderSystem.setShader(class_757::method_34548);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        Matrix4f matrix = poseStack.method_23760().method_23761();
        class_4588 bufferBuilder = bufferSource.getBuffer(class_1921.method_23028((class_2960)resource));
        bufferBuilder.method_22918(matrix, minX, maxY, 0.0f).method_1336(r, g, b, a).method_22913(minU, maxV).method_22916(packedLight).method_1344();
        bufferBuilder.method_22918(matrix, maxX, maxY, 0.0f).method_1336(r, g, b, a).method_22913(maxU, maxV).method_22916(packedLight).method_1344();
        bufferBuilder.method_22918(matrix, maxX, minY, 0.0f).method_1336(r, g, b, a).method_22913(maxU, minV).method_22916(packedLight).method_1344();
        bufferBuilder.method_22918(matrix, minX, minY, 0.0f).method_1336(r, g, b, a).method_22913(minU, minV).method_22916(packedLight).method_1344();
    }
}

