/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render.image;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.render.image.IImage;
import java.io.IOException;
import java.util.concurrent.Executor;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureImage
extends class_1049
implements IImage {
    private final String name;
    @Nullable
    private class_1011 image;

    public TextureImage(class_2960 location) {
        super(location);
        this.name = location.toString();
    }

    @Override
    public String getImageId() {
        return this.name;
    }

    @Override
    public int getWidth() {
        @Nullable class_1011 image = this.getImage();
        return image != null ? image.method_4307() : 1;
    }

    @Override
    public int getHeight() {
        @Nullable class_1011 image = this.getImage();
        return image != null ? image.method_4323() : 1;
    }

    @Override
    public int getPixelABGR(int x, int y) {
        @Nullable class_1011 image = this.getImage();
        return image != null ? image.method_4315(x, y) : 0;
    }

    @Nullable
    public static TextureImage getTexture(class_2960 location) {
        class_1060 textureManager = class_310.method_1551().method_1531();
        @Nullable class_1044 existingTexture = (class_1044)textureManager.field_5286.get(location);
        if (existingTexture != null) {
            TextureImage exposureTexture;
            return existingTexture instanceof TextureImage ? (exposureTexture = (TextureImage)existingTexture) : null;
        }
        try {
            TextureImage texture = new TextureImage(location);
            textureManager.method_4616(location, (class_1044)texture);
            return texture;
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Cannot load texture [{}]. {}", (Object)location, (Object)e);
            return null;
        }
    }

    @Nullable
    public class_1011 getImage() {
        if (this.image != null) {
            return this.image;
        }
        try {
            class_1011 image;
            this.image = image = super.method_18153(class_310.method_1551().method_1478()).method_18157();
            return image;
        }
        catch (IOException e) {
            Exposure.LOGGER.error("Cannot load texture: {}", (Object)e.toString());
            return null;
        }
    }

    public void method_18169(@NotNull class_1060 pTextureManager, @NotNull class_3300 pResourceManager, @NotNull class_2960 pPath, @NotNull Executor pExecutor) {
        super.method_18169(pTextureManager, pResourceManager, pPath, pExecutor);
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.image != null) {
            this.image.close();
            this.image = null;
        }
    }
}

