/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.blocks;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1540;
import net.minecraft.class_1676;
import net.minecraft.class_1685;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5546;
import net.minecraft.class_5688;
import net.minecraft.class_5691;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@class_6328
public class SpecialPointedDripstoneBlock
extends class_2248
implements class_5688,
class_3737 {
    public static final class_2753 TIP_DIRECTION = class_2741.field_28062;
    public static final class_2754<class_5691> THICKNESS = class_2741.field_28063;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 TIP_MERGE_SHAPE = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 TIP_SHAPE_UP = class_2248.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final class_265 TIP_SHAPE_DOWN = class_2248.method_9541((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 FRUSTUM_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 MIDDLE_SHAPE = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final class_265 REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public SpecialPointedDripstoneBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)TIP_DIRECTION, (Comparable)class_2350.field_11036)).method_11657(THICKNESS, (Comparable)class_5691.field_28065)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, (class_2350)state.method_11654((class_2769)TIP_DIRECTION));
    }

    @NotNull
    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 currentPos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(currentPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        if (direction != class_2350.field_11036 && direction != class_2350.field_11033) {
            return state;
        }
        class_2350 direction2 = (class_2350)state.method_11654((class_2769)TIP_DIRECTION);
        if (direction2 == class_2350.field_11033 && level.method_8397().method_8674(currentPos, (Object)this)) {
            return state;
        }
        if (direction == direction2.method_10153() && !this.method_9558(state, (class_4538)level, currentPos)) {
            if (direction2 == class_2350.field_11033) {
                level.method_39279(currentPos, (class_2248)this, 2);
            } else {
                level.method_39279(currentPos, (class_2248)this, 1);
            }
            return state;
        }
        boolean bl = state.method_11654(THICKNESS) == class_5691.field_28064;
        class_5691 dripstoneThickness = SpecialPointedDripstoneBlock.calculateDripstoneThickness((class_4538)level, currentPos, direction2, bl);
        return (class_2680)state.method_11657(THICKNESS, (Comparable)dripstoneThickness);
    }

    public void method_19286(class_1937 level, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_2338 blockPos = hit.method_17777();
        if (!level.field_9236 && projectile.method_36971(level, blockPos) && projectile instanceof class_1685 && projectile.method_18798().method_1033() > 0.6) {
            level.method_22352(blockPos, true);
        }
    }

    public void method_9554(class_1937 level, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (state.method_11654((class_2769)TIP_DIRECTION) == class_2350.field_11036 && state.method_11654(THICKNESS) == class_5691.field_28065) {
            entity.method_5747(fallDistance + 2.0f, 2.0f, level.method_48963().method_48837());
        } else {
            super.method_9554(level, state, pos, entity, fallDistance);
        }
    }

    public void animateTick(class_2680 state, class_1937 level, class_2338 pos, Random random) {
        float f;
        if (SpecialPointedDripstoneBlock.canDrip(state) && !((f = random.nextFloat()) > 0.12f)) {
            SpecialPointedDripstoneBlock.getFluidAboveStalactite(level, pos, state).filter(fluid -> f < 0.02f || SpecialPointedDripstoneBlock.canFillCauldron(fluid)).ifPresent(fluid -> SpecialPointedDripstoneBlock.spawnDripParticle(level, pos, state, fluid));
        }
    }

    public void tick(class_2680 state, class_3218 level, class_2338 pos, Random random) {
        if (SpecialPointedDripstoneBlock.isStalagmite(state) && !this.method_9558(state, (class_4538)level, pos)) {
            level.method_22352(pos, true);
        } else {
            SpecialPointedDripstoneBlock.spawnFallingStalactite(state, level, pos);
        }
    }

    public void randomTick(class_2680 state, class_3218 level, class_2338 pos, Random random) {
        SpecialPointedDripstoneBlock.maybeFillCauldron(state, level, pos, random.nextFloat());
        if (random.nextFloat() < 0.011377778f && SpecialPointedDripstoneBlock.isStalactiteStartPos(state, (class_4538)level, pos)) {
            SpecialPointedDripstoneBlock.growStalactiteOrStalagmiteIfPossible(state, level, pos, random);
        }
    }

    @VisibleForTesting
    public static void maybeFillCauldron(class_2680 state, class_3218 level, class_2338 pos, float randChance) {
        if (!(randChance > 0.17578125f && randChance > 0.05859375f || !SpecialPointedDripstoneBlock.isStalactiteStartPos(state, (class_4538)level, pos))) {
            class_2338 blockPos2;
            class_2338 blockPos;
            float f;
            class_3611 fluid = SpecialPointedDripstoneBlock.getCauldronFillFluidType((class_1937)level, pos);
            if (fluid == class_3612.field_15910) {
                f = 0.17578125f;
            } else {
                if (fluid != class_3612.field_15908) {
                    return;
                }
                f = 0.05859375f;
            }
            if (!(randChance >= f) && (blockPos = SpecialPointedDripstoneBlock.findTip(state, (class_1936)level, pos, 11, false)) != null && (blockPos2 = SpecialPointedDripstoneBlock.findFillableCauldronBelowStalactiteTip((class_1937)level, blockPos, fluid)) != null) {
                level.method_20290(1504, blockPos, 0);
                int i = blockPos.method_10264() - blockPos2.method_10264();
                int j = 50 + i;
                class_2680 blockState = level.method_8320(blockPos2);
                level.method_39279(blockPos2, blockState.method_26204(), j);
            }
        }
    }

    @NotNull
    public class_3619 getPistonPushReaction(class_2680 state) {
        return class_3619.field_15971;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2350 direction;
        class_2338 blockPos;
        class_1937 levelAccessor = context.method_8045();
        class_2350 direction2 = SpecialPointedDripstoneBlock.calculateTipDirection((class_4538)levelAccessor, blockPos = context.method_8037(), direction = context.method_32760().method_10153());
        if (direction2 == null) {
            return null;
        }
        boolean bl = !context.method_8046();
        class_5691 dripstoneThickness = SpecialPointedDripstoneBlock.calculateDripstoneThickness((class_4538)levelAccessor, blockPos, direction2, bl);
        return dripstoneThickness == null ? null : (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)TIP_DIRECTION, (Comparable)direction2)).method_11657(THICKNESS, (Comparable)dripstoneThickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.method_8316(blockPos).method_15772() == class_3612.field_15910));
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @NotNull
    public class_265 method_9571(class_2680 state, class_1922 level, class_2338 pos) {
        return class_259.method_1073();
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_5691 dripstoneThickness = (class_5691)state.method_11654(THICKNESS);
        class_265 voxelShape = dripstoneThickness == class_5691.field_28064 ? TIP_MERGE_SHAPE : (dripstoneThickness == class_5691.field_28065 ? (state.method_11654((class_2769)TIP_DIRECTION) == class_2350.field_11033 ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstoneThickness == class_5691.field_28066 ? FRUSTUM_SHAPE : (dripstoneThickness == class_5691.field_28067 ? MIDDLE_SHAPE : BASE_SHAPE)));
        class_243 vec3 = state.method_26226(level, pos);
        return voxelShape.method_1096(vec3.field_1352, 0.0, vec3.field_1350);
    }

    public boolean method_37403(class_2680 state, class_1922 level, class_2338 pos) {
        return false;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_4970.class_2250 getOffsetType() {
        return class_4970.class_2250.field_10657;
    }

    public float method_32913() {
        return 0.125f;
    }

    public void method_10129(class_1937 level, class_2338 pos, class_1540 fallingBlock) {
        if (!fallingBlock.method_5701()) {
            level.method_20290(1045, pos, 0);
        }
    }

    @NotNull
    public Predicate<class_1297> getHurtsEntitySelector() {
        return class_1301.field_6156.and(class_1301.field_6157);
    }

    private static void spawnFallingStalactite(class_2680 state, class_3218 level, class_2338 pos) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        class_2680 blockState = state;
        while (SpecialPointedDripstoneBlock.isStalactite(blockState)) {
            class_1540 fallingBlockEntity = class_1540.method_40005((class_1937)level, (class_2338)mutableBlockPos, (class_2680)blockState);
            if (SpecialPointedDripstoneBlock.isTip(blockState, true)) {
                int i = Math.max(1 + pos.method_10264() - mutableBlockPos.method_10264(), 6);
                float f = i;
                fallingBlockEntity.method_6965(f, 40);
                break;
            }
            mutableBlockPos.method_10098(class_2350.field_11033);
            blockState = level.method_8320((class_2338)mutableBlockPos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(class_2680 state, class_3218 level, class_2338 pos, Random random) {
        class_2680 blockState3;
        class_2338 blockPos;
        class_2680 blockState2;
        class_2680 blockState = level.method_8320(pos.method_10086(1));
        if (SpecialPointedDripstoneBlock.canGrow(blockState, blockState2 = level.method_8320(pos.method_10086(2))) && (blockPos = SpecialPointedDripstoneBlock.findTip(state, (class_1936)level, pos, 7, false)) != null && SpecialPointedDripstoneBlock.canDrip(blockState3 = level.method_8320(blockPos)) && SpecialPointedDripstoneBlock.canTipGrow(blockState3, level, blockPos)) {
            if (random.nextBoolean()) {
                SpecialPointedDripstoneBlock.grow(level, blockPos, class_2350.field_11033);
            } else {
                SpecialPointedDripstoneBlock.growStalagmiteBelow(level, blockPos);
            }
        }
    }

    private static void growStalagmiteBelow(class_3218 level, class_2338 pos) {
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        for (int i = 0; i < 10; ++i) {
            mutableBlockPos.method_10098(class_2350.field_11033);
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
            if (!blockState.method_26227().method_15769()) {
                return;
            }
            if (SpecialPointedDripstoneBlock.isUnmergedTipWithDirection(blockState, class_2350.field_11036) && SpecialPointedDripstoneBlock.canTipGrow(blockState, level, (class_2338)mutableBlockPos)) {
                SpecialPointedDripstoneBlock.grow(level, (class_2338)mutableBlockPos, class_2350.field_11036);
                return;
            }
            if (SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement((class_4538)level, (class_2338)mutableBlockPos, class_2350.field_11036) && !level.method_22351(mutableBlockPos.method_10074())) {
                SpecialPointedDripstoneBlock.grow(level, mutableBlockPos.method_10074(), class_2350.field_11036);
                return;
            }
            if (SpecialPointedDripstoneBlock.canDripThrough((class_1922)level, (class_2338)mutableBlockPos, blockState)) continue;
            return;
        }
    }

    private static void grow(class_3218 server, class_2338 pos, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = server.method_8320(blockPos);
        if (SpecialPointedDripstoneBlock.isUnmergedTipWithDirection(blockState, direction.method_10153())) {
            SpecialPointedDripstoneBlock.createMergedTips(blockState, (class_1936)server, blockPos);
        } else if (blockState.method_26215() || blockState.method_27852(class_2246.field_10382)) {
            SpecialPointedDripstoneBlock.createDripstone((class_1936)server, blockPos, direction, class_5691.field_28065);
        }
    }

    private static void createDripstone(class_1936 level, class_2338 pos, class_2350 direction, class_5691 thickness) {
        class_2248 class_22482 = level.method_8320(pos).method_26204();
        if (class_22482 instanceof SpecialPointedDripstoneBlock) {
            SpecialPointedDripstoneBlock block = (SpecialPointedDripstoneBlock)class_22482;
            class_2680 blockState = (class_2680)((class_2680)((class_2680)block.method_9564().method_11657((class_2769)TIP_DIRECTION, (Comparable)direction)).method_11657(THICKNESS, (Comparable)thickness)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(level.method_8316(pos).method_15772() == class_3612.field_15910));
            level.method_8652(pos, blockState, 3);
        }
    }

    private static void createMergedTips(class_2680 state, class_1936 level, class_2338 pos) {
        class_2338 blockPos2;
        class_2338 blockPos;
        if (state.method_11654((class_2769)TIP_DIRECTION) == class_2350.field_11036) {
            blockPos = pos;
            blockPos2 = pos.method_10084();
        } else {
            blockPos2 = pos;
            blockPos = pos.method_10074();
        }
        SpecialPointedDripstoneBlock.createDripstone(level, blockPos2, class_2350.field_11033, class_5691.field_28064);
        SpecialPointedDripstoneBlock.createDripstone(level, blockPos, class_2350.field_11036, class_5691.field_28064);
    }

    private static void spawnDripParticle(class_1937 level, class_2338 pos, class_2680 state, class_3611 fluid) {
        class_243 vec3 = state.method_26226((class_1922)level, pos);
        double e = (double)pos.method_10263() + 0.5 + vec3.field_1352;
        double f = (double)((float)(pos.method_10264() + 1) - 0.6875f) - 0.0625;
        double g = (double)pos.method_10260() + 0.5 + vec3.field_1350;
        class_3611 fluid2 = SpecialPointedDripstoneBlock.getDripFluid(level, fluid);
        class_2400 particleOptions = fluid2.method_15791(class_3486.field_15518) ? class_2398.field_28076 : class_2398.field_28078;
        level.method_8406((class_2394)particleOptions, e, f, g, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static class_2338 findTip(class_2680 state, class_1936 level, class_2338 pos, int maxIterations, boolean isTipMerge) {
        if (SpecialPointedDripstoneBlock.isTip(state, isTipMerge)) {
            return pos;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)TIP_DIRECTION);
        BiPredicate<class_2338, class_2680> biPredicate = (blockPos, blockState) -> blockState.method_26204() instanceof SpecialPointedDripstoneBlock && blockState.method_11654((class_2769)TIP_DIRECTION) == direction;
        return SpecialPointedDripstoneBlock.findBlockVertical(level, pos, direction.method_10171(), biPredicate, blockState -> SpecialPointedDripstoneBlock.isTip(blockState, isTipMerge), maxIterations).orElse(null);
    }

    @Nullable
    private static class_2350 calculateTipDirection(class_4538 level, class_2338 pos, class_2350 dir) {
        class_2350 direction;
        if (SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, dir)) {
            direction = dir;
        } else {
            if (!SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, dir.method_10153())) {
                return null;
            }
            direction = dir.method_10153();
        }
        return direction;
    }

    private static class_5691 calculateDripstoneThickness(class_4538 level, class_2338 pos, class_2350 dir, boolean isTipMerge) {
        class_2350 direction = dir.method_10153();
        class_2680 blockState = level.method_8320(pos.method_10093(dir));
        if (SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, direction)) {
            return !isTipMerge && blockState.method_11654(THICKNESS) != class_5691.field_28064 ? class_5691.field_28065 : class_5691.field_28064;
        }
        if (!SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, dir)) {
            return class_5691.field_28065;
        }
        class_5691 dripstoneThickness = (class_5691)blockState.method_11654(THICKNESS);
        if (dripstoneThickness != class_5691.field_28065 && dripstoneThickness != class_5691.field_28064) {
            class_2680 blockState2 = level.method_8320(pos.method_10093(direction));
            return !SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState2, dir) ? class_5691.field_28068 : class_5691.field_28067;
        }
        return class_5691.field_28066;
    }

    public static boolean canDrip(class_2680 state) {
        return SpecialPointedDripstoneBlock.isStalactite(state) && state.method_11654(THICKNESS) == class_5691.field_28065 && (Boolean)state.method_11654((class_2769)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(class_2680 state, class_3218 level, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)TIP_DIRECTION);
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = level.method_8320(blockPos);
        if (!blockState.method_26227().method_15769()) {
            return false;
        }
        return blockState.method_26215() || SpecialPointedDripstoneBlock.isUnmergedTipWithDirection(blockState, direction.method_10153());
    }

    private static Optional<class_2338> findRootBlock(class_1937 level, class_2338 pos, class_2680 state, int maxIterations) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)TIP_DIRECTION);
        BiPredicate<class_2338, class_2680> biPredicate = (blockPos, blockState) -> blockState.method_26204() instanceof SpecialPointedDripstoneBlock && blockState.method_11654((class_2769)TIP_DIRECTION) == direction;
        return SpecialPointedDripstoneBlock.findBlockVertical((class_1936)level, pos, direction.method_10153().method_10171(), biPredicate, blockState -> !(blockState.method_26204() instanceof SpecialPointedDripstoneBlock), maxIterations);
    }

    private static boolean isValidPointedDripstonePlacement(class_4538 level, class_2338 pos, class_2350 dir) {
        class_2338 blockPos = pos.method_10093(dir.method_10153());
        class_2680 blockState = level.method_8320(blockPos);
        return blockState.method_26206((class_1922)level, blockPos, dir) || SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, dir);
    }

    private static boolean isTip(class_2680 state, boolean isTipMerge) {
        if (!(state.method_26204() instanceof SpecialPointedDripstoneBlock)) {
            return false;
        }
        class_5691 dripstoneThickness = (class_5691)state.method_11654(THICKNESS);
        return dripstoneThickness == class_5691.field_28065 || isTipMerge && dripstoneThickness == class_5691.field_28064;
    }

    private static boolean isUnmergedTipWithDirection(class_2680 state, class_2350 dir) {
        return SpecialPointedDripstoneBlock.isTip(state, false) && state.method_11654((class_2769)TIP_DIRECTION) == dir;
    }

    private static boolean isStalactite(class_2680 state) {
        return SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(state, class_2350.field_11033);
    }

    private static boolean isStalagmite(class_2680 state) {
        return SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(state, class_2350.field_11036);
    }

    private static boolean isStalactiteStartPos(class_2680 state, class_4538 level, class_2338 pos) {
        return SpecialPointedDripstoneBlock.isStalactite(state) && !(level.method_8320(pos.method_10084()).method_26204() instanceof SpecialPointedDripstoneBlock);
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(class_2680 state, class_2350 dir) {
        return state.method_26204() instanceof SpecialPointedDripstoneBlock && state.method_11654((class_2769)TIP_DIRECTION) == dir;
    }

    @Nullable
    private static class_2338 findFillableCauldronBelowStalactiteTip(class_1937 level, class_2338 pos, class_3611 fluid) {
        Predicate<class_2680> predicate = blockState -> blockState.method_26204() instanceof class_5546;
        BiPredicate<class_2338, class_2680> biPredicate = (blockPos, blockState) -> SpecialPointedDripstoneBlock.canDripThrough((class_1922)level, blockPos, blockState);
        return SpecialPointedDripstoneBlock.findBlockVertical((class_1936)level, pos, class_2350.field_11033.method_10171(), biPredicate, predicate, 11).orElse(null);
    }

    public static class_3611 getCauldronFillFluidType(class_1937 level, class_2338 pos) {
        return SpecialPointedDripstoneBlock.getFluidAboveStalactite(level, pos, level.method_8320(pos)).filter(SpecialPointedDripstoneBlock::canFillCauldron).orElse(class_3612.field_15906);
    }

    private static Optional<class_3611> getFluidAboveStalactite(class_1937 level, class_2338 pos, class_2680 state) {
        return !SpecialPointedDripstoneBlock.isStalactite(state) ? Optional.empty() : SpecialPointedDripstoneBlock.findRootBlock(level, pos, state, 11).map(blockPos -> level.method_8316(blockPos.method_10084()).method_15772());
    }

    private static boolean canFillCauldron(class_3611 fluid) {
        return fluid == class_3612.field_15908 || fluid == class_3612.field_15910;
    }

    private static boolean canGrow(class_2680 dripstoneState, class_2680 state) {
        return dripstoneState.method_27852(class_2246.field_28049) && state.method_27852(class_2246.field_10382) && state.method_26227().method_15771();
    }

    private static class_3611 getDripFluid(class_1937 level, class_3611 fluid) {
        if (fluid.method_15780(class_3612.field_15906)) {
            return level.method_8597().comp_644() ? class_3612.field_15908 : class_3612.field_15910;
        }
        return fluid;
    }

    private static Optional<class_2338> findBlockVertical(class_1936 level, class_2338 pos, class_2350.class_2352 axis, BiPredicate<class_2338, class_2680> positionalStatePredicate, Predicate<class_2680> statePredicate, int maxIterations) {
        class_2350 direction = class_2350.method_10156((class_2350.class_2352)axis, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_2338.class_2339 mutableBlockPos = pos.method_25503();
        for (int i = 1; i < maxIterations; ++i) {
            mutableBlockPos.method_10098(direction);
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos);
            if (statePredicate.test(blockState)) {
                return Optional.of(mutableBlockPos.method_10062());
            }
            if (!level.method_31601(mutableBlockPos.method_10264()) && positionalStatePredicate.test((class_2338)mutableBlockPos, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(class_1922 level, class_2338 pos, class_2680 state) {
        if (state.method_26215()) {
            return true;
        }
        if (state.method_26216(level, pos)) {
            return false;
        }
        if (!state.method_26227().method_15769()) {
            return false;
        }
        class_265 voxelShape = state.method_26220(level, pos);
        return !class_259.method_1074((class_265)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (class_265)voxelShape, (class_247)class_247.field_16896);
    }
}

