/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.energy;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.fabric.energy.PlatformEnergyManager;
import earth.terrarium.botarium.fabric.energy.PlatformItemEnergyManager;
import earth.terrarium.botarium.util.Updatable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class EnergyApi {
    private static final Map<Supplier<class_2591<?>>, BlockEnergyGetter<?>> BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<class_2248>, BlockEnergyGetter<?>> BLOCK_LOOKUP_MAP = new HashMap();
    private static final Map<Supplier<class_1792>, ItemEnergyGetter<?>> ITEM_LOOKUP_MAP = new HashMap();
    public static final Map<class_2591<?>, BlockEnergyGetter<?>> FINALIZED_BLOCK_ENTITY_LOOKUP_MAP = new HashMap();
    public static final Map<class_2248, BlockEnergyGetter<?>> FINALIZED_BLOCK_LOOKUP_MAP = new HashMap();
    public static boolean blocksFinalized = false;
    public static final Map<class_1792, ItemEnergyGetter<?>> FINALIZED_ITEM_LOOKUP_MAP = new HashMap();
    public static boolean itemsFinalized = false;

    public static void finalizeBlockRegistration() {
        if (!blocksFinalized) {
            System.out.println("Finalizing energy block registration");
            for (Map.Entry<Supplier<class_2591<?>>, BlockEnergyGetter<?>> entry : BLOCK_ENTITY_LOOKUP_MAP.entrySet()) {
                FINALIZED_BLOCK_ENTITY_LOOKUP_MAP.put(entry.getKey().get(), entry.getValue());
            }
            for (Map.Entry<Supplier<class_2591<?>>, BlockEnergyGetter<?>> entry : BLOCK_LOOKUP_MAP.entrySet()) {
                FINALIZED_BLOCK_LOOKUP_MAP.put((class_2248)entry.getKey().get(), entry.getValue());
            }
            blocksFinalized = true;
        }
    }

    public static void finalizeItemRegistration() {
        if (!itemsFinalized) {
            System.out.println("Finalizing energy item registration");
            for (Map.Entry<Supplier<class_1792>, ItemEnergyGetter<?>> entry : ITEM_LOOKUP_MAP.entrySet()) {
                FINALIZED_ITEM_LOOKUP_MAP.put(entry.getKey().get(), entry.getValue());
            }
            itemsFinalized = true;
        }
    }

    public static void registerEnergyBlockEntity(Supplier<class_2591<?>> block, BlockEnergyGetter<?> getter) {
        BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerEnergyBlockEntity(BlockEnergyGetter<?> getter, Supplier<class_2591<?>> ... blocks) {
        for (Supplier<class_2591<?>> block : blocks) {
            BLOCK_ENTITY_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerEnergyBlock(Supplier<class_2248> block, BlockEnergyGetter<?> getter) {
        BLOCK_LOOKUP_MAP.put(block, getter);
    }

    @SafeVarargs
    public static void registerEnergyBlock(BlockEnergyGetter<?> getter, Supplier<class_2248> ... blocks) {
        for (Supplier<class_2248> block : blocks) {
            BLOCK_LOOKUP_MAP.put(block, getter);
        }
    }

    public static void registerEnergyItem(Supplier<class_1792> item, ItemEnergyGetter<?> getter) {
        ITEM_LOOKUP_MAP.put(item, getter);
    }

    @SafeVarargs
    public static void registerEnergyItem(ItemEnergyGetter<?> getter, Supplier<class_1792> ... items) {
        for (Supplier<class_1792> item : items) {
            ITEM_LOOKUP_MAP.put(item, getter);
        }
    }

    @Nullable
    public static EnergyContainer getItemEnergyContainer(ItemStackHolder stack) {
        return EnergyApi.isEnergyItem(stack.getStack()) ? new PlatformItemEnergyManager(stack) : null;
    }

    @Nullable
    public static EnergyContainer getBlockEnergyContainer(class_2586 entity, @Nullable class_2350 direction) {
        return EnergyApi.isEnergyBlock(entity, direction) ? new PlatformEnergyManager(entity, direction) : null;
    }

    public static boolean isEnergyItem(class_1799 stack) {
        return EnergyStorageUtil.isEnergyStorage((class_1799)stack);
    }

    public static boolean isEnergyBlock(class_2586 block, @Nullable class_2350 direction) {
        return EnergyStorage.SIDED.find(block.method_10997(), block.method_11016(), (Object)direction) != null;
    }

    public static long distributeEnergyNearby(class_2586 energyBlock, @Nullable class_2350 extractDirection, long amount) {
        return EnergyApi.distributeEnergyNearby(energyBlock.method_10997(), energyBlock.method_11016(), extractDirection, amount);
    }

    public static long distributeEnergyNearby(class_2586 energyBlock, long amount) {
        return EnergyApi.distributeEnergyNearby(energyBlock.method_10997(), energyBlock.method_11016(), null, amount);
    }

    public static long distributeEnergyNearby(class_1937 level, class_2338 energyPos, @Nullable class_2350 extractDirection, long amount) {
        EnergyContainer internalEnergy = EnergyContainer.of(level, energyPos, extractDirection);
        long amountToDistribute = internalEnergy.extractEnergy(amount, true);
        if (amountToDistribute == 0L) {
            return 0L;
        }
        List<EnergyContainer> list = class_2350.method_42013().map(direction -> EnergyContainer.of(level, energyPos.method_10093(direction), direction.method_10153())).filter(Objects::nonNull).sorted(Comparator.comparingLong(energy -> energy.insertEnergy(amount, true))).toList();
        int receiverCount = list.size();
        for (EnergyContainer energy2 : list) {
            if (energy2 == null) continue;
            long inserted = EnergyApi.moveEnergy(internalEnergy, energy2, amountToDistribute / (long)receiverCount, false);
            amountToDistribute -= inserted;
            --receiverCount;
        }
        return amount - amountToDistribute;
    }

    public static long moveEnergy(EnergyContainer from, EnergyContainer to, long amount, boolean simulate) {
        long extracted = from.extractEnergy(amount, true);
        long inserted = to.insertEnergy(extracted, true);
        long simulatedExtraction = from.extractEnergy(inserted, true);
        if (!simulate && inserted > 0L && simulatedExtraction == inserted) {
            from.extractEnergy(inserted, false);
            to.insertEnergy(inserted, false);
        }
        return Math.max(0L, inserted);
    }

    public static long moveEnergy(ItemStackHolder from, ItemStackHolder to, long amount, boolean simulate) {
        if (!EnergyApi.isEnergyItem(from.getStack()) || !EnergyApi.isEnergyItem(to.getStack())) {
            return 0L;
        }
        EnergyContainer fromEnergy = EnergyApi.getItemEnergyContainer(from);
        EnergyContainer toEnergy = EnergyApi.getItemEnergyContainer(to);
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(class_2586 from, class_2586 to, long amount, boolean simulate) {
        if (!EnergyApi.isEnergyBlock(from, null) || !EnergyApi.isEnergyBlock(to, null)) {
            return 0L;
        }
        EnergyContainer fromEnergy = EnergyApi.getBlockEnergyContainer(from, null);
        EnergyContainer toEnergy = EnergyApi.getBlockEnergyContainer(to, null);
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(class_1937 level, class_2338 fromPos, @Nullable class_2350 fromDirection, class_2338 toPos, @Nullable class_2350 toDirection, long amount, boolean simulate) {
        if (!EnergyContainer.holdsEnergy(level, fromPos, fromDirection) || !EnergyContainer.holdsEnergy(level, toPos, toDirection)) {
            return 0L;
        }
        EnergyContainer fromEnergy = EnergyContainer.of(level, fromPos, fromDirection);
        EnergyContainer toEnergy = EnergyContainer.of(level, toPos, toDirection);
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(class_2586 from, class_2350 direction, ItemStackHolder to, long amount, boolean simulate) {
        if (!EnergyApi.isEnergyBlock(from, direction) || !EnergyApi.isEnergyItem(to.getStack())) {
            return 0L;
        }
        EnergyContainer fromEnergy = EnergyApi.getBlockEnergyContainer(from, direction);
        EnergyContainer toEnergy = EnergyApi.getItemEnergyContainer(to);
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    public static long moveEnergy(ItemStackHolder from, class_2586 to, class_2350 direction, long amount, boolean simulate) {
        if (!EnergyApi.isEnergyItem(from.getStack()) || !EnergyApi.isEnergyBlock(to, direction)) {
            return 0L;
        }
        EnergyContainer fromEnergy = EnergyApi.getItemEnergyContainer(from);
        EnergyContainer toEnergy = EnergyApi.getBlockEnergyContainer(to, direction);
        return EnergyApi.moveEnergy(fromEnergy, toEnergy, amount, simulate);
    }

    @FunctionalInterface
    public static interface BlockEnergyGetter<T extends EnergyContainer & Updatable<class_2586>> {
        public T getEnergyContainer(class_1937 var1, class_2338 var2, class_2680 var3, class_2586 var4, class_2350 var5);
    }

    @FunctionalInterface
    public static interface ItemEnergyGetter<T extends EnergyContainer & Updatable<class_1799>> {
        public T getEnergyContainer(class_1799 var1);
    }
}

