/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.utils;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class FluidIngredient
implements Predicate<FluidHolder> {
    private static final Codec<FluidIngredient> NEW_CODEC = FluidIngredient.listAndObjectCodec(Codec.either(FluidValue.CODEC, TagValue.CODEC), FluidIngredient::getRawValues, FluidIngredient::new);
    private static final Codec<FluidIngredient> OLD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either(FluidValue.CODEC, TagValue.CODEC).listOf().fieldOf("fluids").forGetter(FluidIngredient::getRawValues)).apply((Applicative)instance, FluidIngredient::new));
    public static final Codec<FluidIngredient> CODEC = Codec.either(NEW_CODEC, OLD_CODEC).xmap(p -> (FluidIngredient)p.map(a -> a, b -> b), Either::left);
    private final List<Either<FluidValue, TagValue>> values;
    private List<FluidHolder> cachedFluids;

    public static <A, B> Codec<B> listAndObjectCodec(Codec<A> codec, Function<B, List<A>> from, Function<List<A>, B> to) {
        return Codec.either(codec, (Codec)codec.listOf()).xmap(eitherListEither -> eitherListEither.map(either -> to.apply(List.of(either)), to), a -> ((List)from.apply(a)).size() == 1 ? Either.left(((List)from.apply(a)).get(0)) : Either.right((Object)((List)from.apply(a))));
    }

    protected FluidIngredient(List<Either<FluidValue, TagValue>> stream) {
        this.values = stream;
    }

    public static FluidIngredient of() {
        return new FluidIngredient(List.of());
    }

    public static FluidIngredient of(class_3611 ... fluids) {
        return new FluidIngredient(Arrays.stream(fluids).map(FluidValue::new).map(Either::left).toList());
    }

    public static FluidIngredient of(FluidHolder ... fluids) {
        return FluidIngredient.of(Arrays.stream(fluids));
    }

    public static FluidIngredient of(Stream<FluidHolder> fluids) {
        ArrayList<Either<FluidValue, TagValue>> values = new ArrayList<Either<FluidValue, TagValue>>();
        for (FluidHolder fluid : fluids.filter(Predicate.not(FluidHolder::isEmpty)).toList()) {
            values.add((Either<FluidValue, TagValue>)Either.left((Object)new FluidValue(fluid.getFluid())));
        }
        return new FluidIngredient(values);
    }

    public static FluidIngredient of(class_6862<class_3611> tag) {
        return new FluidIngredient(List.of(Either.right((Object)new TagValue(tag))));
    }

    @Override
    public boolean test(FluidHolder fluidHolder) {
        if (this.values.isEmpty()) {
            return fluidHolder.isEmpty();
        }
        for (FluidHolder value : this.getFluids()) {
            if (!fluidHolder.getFluid().method_15780(value.getFluid())) continue;
            return true;
        }
        return false;
    }

    public List<FluidHolder> getFluids() {
        this.dissolve();
        return this.cachedFluids;
    }

    public void dissolve() {
        if (this.cachedFluids == null) {
            this.cachedFluids = this.values.stream().flatMap(either -> (Stream)either.map(fluidValue -> fluidValue.getFluids().stream(), tagValue -> tagValue.getFluids().stream())).collect(Collectors.toList());
        }
    }

    public List<Either<FluidValue, TagValue>> getRawValues() {
        return this.values;
    }

    public record FluidValue(class_3611 fluid) implements Value
    {
        private static final Codec<FluidValue> NEW_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41173.method_39673().fieldOf("fluid").forGetter(FluidValue::fluid)).apply((Applicative)instance, FluidValue::new));
        private static final Codec<FluidValue> OLD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidHolder.CODEC.fieldOf("fluid").forGetter(value -> FluidHolder.of(value.fluid()))).apply((Applicative)instance, fluidHolder -> new FluidValue(fluidHolder.getFluid())));
        public static final Codec<FluidValue> CODEC = Codec.either(NEW_CODEC, OLD_CODEC).xmap(p -> (FluidValue)p.map(a -> a, b -> b), Either::left);

        @Override
        public Collection<FluidHolder> getFluids() {
            return Collections.singleton(FluidHolder.of(this.fluid));
        }
    }

    public record TagValue(class_6862<class_3611> tag) implements Value
    {
        public static final Codec<TagValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6862.method_40090((class_5321)class_7923.field_41173.method_30517()).fieldOf("tag").forGetter(TagValue::tag)).apply((Applicative)instance, TagValue::new));

        @Override
        public Collection<FluidHolder> getFluids() {
            ArrayList list = Lists.newArrayList();
            for (class_6880 holder : class_7923.field_41173.method_40286(this.tag)) {
                list.add(FluidHolder.of((class_3611)holder.comp_349()));
            }
            return list;
        }
    }

    public static interface Value {
        public Collection<FluidHolder> getFluids();
    }
}

