/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.railwayteam.railways.content.buffer.BufferBlockPlaceContext;
import com.railwayteam.railways.content.buffer.TrackBufferBlock;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import net.createmod.catnip.data.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackBufferBlockItem
extends TrackTargetingBlockItem {
    public static <T extends class_2248> NonNullBiFunction<? super T, class_1792.class_1793, TrackTargetingBlockItem> ofType(EdgePointType<?> type) {
        return (b, p) -> new TrackBufferBlockItem((class_2248)b, (class_1792.class_1793)p, type);
    }

    public TrackBufferBlockItem(class_2248 pBlock, class_1792.class_1793 pProperties, EdgePointType<?> type) {
        super(pBlock, pProperties, type);
    }

    @Nullable
    protected class_2680 method_7707(@NotNull class_1750 context) {
        if (context instanceof BufferBlockPlaceContext) {
            BufferBlockPlaceContext bufferContext = (BufferBlockPlaceContext)context;
            if (bufferContext.overrideBlock != null) {
                class_2680 blockState = bufferContext.overrideBlock.method_9605(context);
                return blockState != null && this.method_7709(context, blockState) ? blockState : null;
            }
        }
        return super.method_7707(context);
    }

    private static boolean isOkShape(class_2680 state) {
        TrackShape shape = (TrackShape)state.method_11654((class_2769)TrackBlock.SHAPE);
        return switch (shape) {
            case TrackShape.ZO, TrackShape.XO, TrackShape.PD, TrackShape.ND, TrackShape.TE, TrackShape.TN, TrackShape.TS, TrackShape.TW -> true;
            default -> false;
        };
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_2338 pos = context.method_8037();
        class_1937 level = context.method_8045();
        class_2680 state = level.method_8320(pos);
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ITrackBlock) {
            ITrackBlock track = (ITrackBlock)class_22482;
            if (level.field_9236) {
                return class_1269.field_5812;
            }
            class_243 lookAngle = player.method_5720();
            Pair nearestTrackAxis = track.getNearestTrackAxis((class_1922)level, pos, state, lookAngle);
            boolean front = nearestTrackAxis.getSecond() == class_2350.class_2352.field_11060;
            class_243 biasedDirection = ((class_243)nearestTrackAxis.getFirst()).method_1024(10.0f);
            class_2350.class_2351 axis = class_2350.method_10142((double)biasedDirection.field_1352, (double)biasedDirection.field_1351, (double)biasedDirection.field_1350).method_10166();
            EdgePointType type = this.getType(stack);
            MutableObject result = new MutableObject(null);
            TrackBufferBlockItem.withGraphLocation((class_1937)level, (class_2338)pos, (boolean)front, null, (EdgePointType)type, (overlap, location) -> result.setValue(overlap));
            if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                player.method_7353((class_2561)CreateLang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).method_27692(class_124.field_1061), true);
                AllSoundEvents.DENY.play(level, null, (class_2382)pos, 0.5f, 1.0f);
                return class_1269.field_5814;
            }
            if (!TrackBufferBlockItem.isOkShape(state)) {
                player.method_7353((class_2561)class_2561.method_43471((String)"railways.buffer.invalid_shape").method_27692(class_124.field_1061), true);
                AllSoundEvents.DENY.play(level, null, (class_2382)pos, 0.5f, 1.0f);
                return class_1269.field_5814;
            }
            class_2487 stackTag = stack.method_7948();
            stack.method_7980(stackTag);
            class_2487 oldTeTag = stackTag.method_10562("BlockEntityTag");
            class_2487 teTag = new class_2487();
            if (oldTeTag != null) {
                if (oldTeTag.method_10573("Material", 10)) {
                    teTag.method_10566("Material", oldTeTag.method_10580("Material"));
                }
                if (oldTeTag.method_10573("Color", 3)) {
                    teTag.method_10566("Color", oldTeTag.method_10580("Color"));
                }
            }
            teTag.method_10556("TargetDirection", front);
            class_2338 placedPos = pos.method_10084();
            class_2350 placeDirection = class_2350.field_11036;
            TrackBufferBlock overrideBlock = null;
            if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE) {
                overrideBlock = (TrackBufferBlock)((Object)CRBlocks.TRACK_BUFFER_NARROW.get());
            } else if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                overrideBlock = (TrackBufferBlock)((Object)CRBlocks.TRACK_BUFFER_WIDE.get());
            } else if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
                overrideBlock = (TrackBufferBlock)((Object)CRBlocks.TRACK_BUFFER_MONO.get());
                placedPos = context.method_8038() == class_2350.field_11033 ? pos.method_10074() : pos.method_10084();
                placeDirection = context.method_8038();
            }
            teTag.method_10566("TargetTrack", (class_2520)class_2512.method_10692((class_2338)pos.method_10059((class_2382)placedPos)));
            stackTag.method_10566("BlockEntityTag", (class_2520)teTag);
            TrackShape shape = (TrackShape)state.method_11654((class_2769)TrackBlock.SHAPE);
            boolean diagonal = shape == TrackShape.PD || shape == TrackShape.ND;
            class_1269 useOn = this.method_7712(BufferBlockPlaceContext.at(new class_1750(context), placedPos, placeDirection, class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)((class_2350.class_2352)nearestTrackAxis.getSecond())), overrideBlock, diagonal));
            teTag.method_10551("TargetTrack");
            teTag.method_10551("TargetDirection");
            return useOn;
        }
        return class_1269.field_5811;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, class_1799 stack) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_638 level = mc.field_1687;
        if (player != null) {
            player.method_7353((class_2561)CreateLang.translateDirect((String)"track_target.invalid", (Object[])new Object[0]).method_27692(class_124.field_1061), true);
            AllSoundEvents.DENY.play((class_1937)level, (class_1657)player, player.method_19538(), 0.5f, 1.0f);
            return false;
        }
        return false;
    }
}

