/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.fabric;

import com.railwayteam.railways.content.buffer.BufferModelUtils;
import com.railwayteam.railways.content.buffer.IDyedBuffer;
import com.railwayteam.railways.content.buffer.IMaterialAdaptingBuffer;
import com.railwayteam.railways.content.buffer.TrackBufferBlock;
import com.simibubi.create.foundation.model.BakedModelHelper;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_777;
import net.minecraft.class_7833;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class BufferModel
extends ForwardingBakedModel {
    private static final Matrix3f diagonalTransform = BufferModel.getDiagonalRotationMatrix();
    private static final RenderContext.QuadTransform diagonalTransformer = quad -> {
        Vector3f faceNormal = quad.faceNormal();
        faceNormal.mulTranspose((Matrix3fc)diagonalTransform);
        for (int i = 0; i < 4; ++i) {
            Vector3f vertexPos = quad.copyPos(i, new Vector3f());
            vertexPos.sub((Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f));
            vertexPos.mulTranspose((Matrix3fc)diagonalTransform);
            vertexPos.add((Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f));
            quad.pos(i, vertexPos);
            quad.normal(i, faceNormal);
        }
        return true;
    };

    public BufferModel(class_1087 wrapped) {
        this.wrapped = wrapped;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        Object be;
        boolean isDiagonal = false;
        if (state.method_26204() instanceof TrackBufferBlock) {
            isDiagonal = (Boolean)state.method_11654((class_2769)TrackBufferBlock.DIAGONAL);
        }
        if (isDiagonal) {
            context.pushTransform(diagonalTransformer);
        }
        UnaryOperator<class_1058> materialSwapper = null;
        UnaryOperator<class_1058> colorSwapper = null;
        class_2586 class_25862 = blockView.method_8321(pos);
        if (class_25862 instanceof IDyedBuffer) {
            be = (IDyedBuffer)class_25862;
            colorSwapper = BufferModelUtils.getSwapper(be.getColor());
        }
        if ((class_25862 = blockView.method_8321(pos)) instanceof IMaterialAdaptingBuffer) {
            be = (IMaterialAdaptingBuffer)class_25862;
            materialSwapper = BufferModelUtils.getSwapper(be.getMaterial());
        }
        if (materialSwapper != null || colorSwapper != null) {
            new SpriteReplacingBakedModel(BufferModelUtils.combineSwappers(materialSwapper, colorSwapper)).emitBlockQuads(blockView, state, pos, randomSupplier, context);
        } else {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        }
        if (isDiagonal) {
            context.popTransform();
        }
    }

    private static Matrix3f getDiagonalRotationMatrix() {
        Matrix3f matrix = new Matrix3f();
        matrix.mul((Matrix3fc)class_7833.field_40716.rotationDegrees(45.0f).get(new Matrix3f()));
        return matrix;
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2487 tag;
        UnaryOperator<class_1058> materialSwapper = null;
        UnaryOperator<class_1058> colorSwapper = null;
        if (stack.method_7985() && (tag = stack.method_7969()).method_10573("BlockEntityTag", 10)) {
            class_2487 blockEntityTag = tag.method_10562("BlockEntityTag");
            if (blockEntityTag.method_10573("Material", 10)) {
                materialSwapper = BufferModelUtils.getSwapper(class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)blockEntityTag.method_10562("Material")));
            }
            if (blockEntityTag.method_10573("Color", 3)) {
                colorSwapper = BufferModelUtils.getSwapper(class_1767.method_7791((int)blockEntityTag.method_10550("Color")));
            }
        }
        if (materialSwapper != null || colorSwapper != null) {
            new SpriteReplacingBakedModel(BufferModelUtils.combineSwappers(materialSwapper, colorSwapper)).emitItemQuads(stack, randomSupplier, context);
        } else {
            super.emitItemQuads(stack, randomSupplier, context);
        }
    }

    private class SpriteReplacingBakedModel
    implements class_1087 {
        private final UnaryOperator<class_1058> spriteSwapper;

        private SpriteReplacingBakedModel(UnaryOperator<class_1058> spriteSwapper) {
            this.spriteSwapper = spriteSwapper;
        }

        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
            return BakedModelHelper.swapSprites((List)BufferModel.this.wrapped.method_4707(state, direction, random), this.spriteSwapper);
        }

        public boolean method_4708() {
            return BufferModel.this.wrapped.method_4708();
        }

        public boolean method_4712() {
            return BufferModel.this.wrapped.method_4712();
        }

        public boolean method_24304() {
            return BufferModel.this.wrapped.method_24304();
        }

        public boolean method_4713() {
            return BufferModel.this.wrapped.method_4713();
        }

        public class_1058 method_4711() {
            return BufferModel.this.wrapped.method_4711();
        }

        public class_809 method_4709() {
            return BufferModel.this.wrapped.method_4709();
        }

        public class_806 method_4710() {
            return BufferModel.this.wrapped.method_4710();
        }
    }
}

