/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.railwayteam.railways.content.coupling.coupler.TrackCoupler;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.util.CustomTrackOverlayRendering;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class TrackCouplerRenderer
extends SmartBlockEntityRenderer<TrackCouplerBlockEntity> {
    public TrackCouplerRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Nullable
    public static PartialModel getCouplerOverlayModel(TrackCouplerBlockEntity te) {
        if (te.areEdgePointsOk()) {
            TrackCouplerBlockEntity.AllowedOperationMode mode = te.getAllowedOperationMode();
            if (mode.canCouple && mode.canDecouple) {
                return CRBlockPartials.COUPLER_BOTH;
            }
            if (mode.canCouple) {
                return CRBlockPartials.COUPLER_COUPLE;
            }
            if (mode.canDecouple) {
                return CRBlockPartials.COUPLER_DECOUPLE;
            }
        } else {
            return CRBlockPartials.COUPLER_NONE;
        }
        return null;
    }

    protected void renderSafe(TrackCouplerBlockEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)te, partialTicks, ms, buffer, light, overlay);
        this.renderEdgePoint(te, ms, buffer, light, overlay, te.edgePoint);
        this.renderEdgePoint(te, ms, buffer, light, overlay, te.secondEdgePoint);
    }

    private void renderEdgePoint(TrackCouplerBlockEntity te, class_4587 ms, class_4597 buffer, int light, int overlay, TrackTargetingBehaviour<TrackCoupler> target) {
        class_2338 pos = te.method_11016();
        boolean offsetToSide = CustomTrackOverlayRendering.overlayWillOverlap(target);
        class_2338 targetPosition = target.getGlobalPosition();
        class_1937 level = te.method_10997();
        class_2680 trackState = level.method_8320(targetPosition);
        class_2248 block = trackState.method_26204();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ms.method_22903();
        TransformStack.of((class_4587)ms).translate((class_2382)targetPosition.method_10059((class_2382)pos));
        CustomTrackOverlayRendering.renderOverlay((class_1936)level, targetPosition, target.getTargetDirection(), target.getTargetBezier(), ms, buffer, light, overlay, TrackCouplerRenderer.getCouplerOverlayModel(te), 1.0f, offsetToSide);
        ms.method_22909();
    }
}

