/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlockEntity;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.util.CustomTrackOverlayRendering;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Map;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class TrackSwitchRenderer
extends SmartBlockEntityRenderer<TrackSwitchBlockEntity> {
    public TrackSwitchRenderer(class_5614.class_5615 ctx) {
        super(ctx);
    }

    protected void renderSafe(TrackSwitchBlockEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_1937 class_19372;
        super.renderSafe((SmartBlockEntity)te, partialTicks, ms, buffer, light, overlay);
        this.renderFlagState(te, partialTicks, ms, buffer, light);
        this.renderTrackOverlay(te, ms, buffer, light, overlay, te.edgePoint);
        if (te.ponderData != null && (class_19372 = te.method_10997()) instanceof PonderLevel) {
            PonderLevel ponderWorld = (PonderLevel)class_19372;
            this.renderPonderData(ponderWorld, te.getState(), te.ponderData, partialTicks, ms, buffer, light, overlay);
        }
    }

    private void renderPonderData(PonderLevel ponderWorld, TrackSwitchBlock.SwitchState state, TrackSwitchBlockEntity.PonderData ponderData, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        ms.method_22903();
        class_243 offset = new class_243(0.0, 0.4, 0.0);
        float width = 0.0625f;
        class_243 from = ponderData.basePos();
        for (Map.Entry<TrackSwitchBlock.SwitchState, class_243> to : ponderData.getBranches().entrySet()) {
            boolean active = to.getKey() == state;
            ponderWorld.scene.getOutliner().showLine(to, from.method_1019(offset), to.getValue().method_1019(offset)).colored(active ? new Color(0, 203, 150) : new Color(255, 50, 150)).lineWidth(width);
        }
        ms.method_22909();
    }

    private void renderFlagState(TrackSwitchBlockEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light) {
        class_2680 state = te.method_11010();
        ms.method_22903();
        float yRot = AngleHelper.horizontalAngle((class_2350)((class_2350)state.method_11654((class_2769)TrackSwitchBlock.field_11177)));
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of((class_4587)ms).center()).rotateYDegrees(yRot)).uncenter();
        if (te.isAutomatic()) {
            ms.method_22903();
            ms.method_22904(0.0, -0.125, 0.0);
            SuperByteBuffer buf = (SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)CRBlockPartials.BRASS_SWITCH_FLAG, (class_2680)state).light(light).rotateCentered(1.5708f, class_2350.field_11036)).translate(0.5, 0.53125, 0.5);
            if (te.isReverseLeft() || te.isNormal() && te.exitCount == 2 && te.hasExit(TrackSwitchBlock.SwitchState.REVERSE_RIGHT)) {
                te.lerpedAngle.updateChaseTarget(-0.4f);
            } else if (te.isReverseRight() || te.isNormal() && te.exitCount == 2 && te.hasExit(TrackSwitchBlock.SwitchState.REVERSE_LEFT)) {
                te.lerpedAngle.updateChaseTarget(0.4f);
            } else {
                te.lerpedAngle.updateChaseTarget(0.0f);
            }
            buf = (SuperByteBuffer)buf.rotate(te.lerpedAngle.getValue(partialTicks), class_2350.field_11043);
            ((SuperByteBuffer)buf.translate(-0.5, -0.46875, -0.5)).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
            ms.method_22909();
        } else {
            SuperByteBuffer buf = CachedBuffers.partial((PartialModel)CRBlockPartials.ANDESITE_SWITCH_FLAG, (class_2680)state).light(light);
            if (te.isReverseLeft()) {
                te.lerpedAngle.updateChaseTarget(1.5708f);
            } else if (te.isReverseRight()) {
                te.lerpedAngle.updateChaseTarget(-1.5708f);
            } else {
                te.lerpedAngle.updateChaseTarget(0.0f);
            }
            buf = (SuperByteBuffer)buf.rotateCentered(te.lerpedAngle.getValue(partialTicks), class_2350.field_11036);
            buf.renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
            ((SuperByteBuffer)CachedBuffers.partial((PartialModel)CRBlockPartials.ANDESITE_SWITCH_HANDLE, (class_2680)state).light(light).rotateCentered(-1.5708f, class_2350.field_11036)).renderInto(ms, buffer.getBuffer(class_1921.method_23577()));
        }
        ms.method_22909();
    }

    private void renderTrackOverlay(TrackSwitchBlockEntity te, class_4587 ms, class_4597 buffer, int light, int overlay, TrackTargetingBehaviour<TrackSwitch> target) {
        class_2338 pos = te.method_11016();
        boolean offsetToSide = CustomTrackOverlayRendering.overlayWillOverlap(target);
        class_2338 targetPosition = target.getGlobalPosition();
        class_1937 level = te.method_10997();
        class_2680 trackState = level.method_8320(targetPosition);
        class_2248 block = trackState.method_26204();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ms.method_22903();
        TransformStack.of((class_4587)ms).translate((class_2382)targetPosition.method_10059((class_2382)pos));
        CustomTrackOverlayRendering.renderOverlay((class_1936)level, targetPosition, target.getTargetDirection(), target.getTargetBezier(), ms, buffer, light, overlay, te.getOverlayModel(), 1.0f, offsetToSide);
        ms.method_22909();
    }
}

