/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandler;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ToolboxHandler.class}, remap=false)
public abstract class MixinToolboxHandler {
    @Shadow
    public static void syncData(class_1657 player) {
        throw new AssertionError();
    }

    @Inject(method={"onLoad", "onUnload"}, at={@At(value="HEAD")}, cancellable=true)
    private static void railways$keepMountedToolboxesOutOfMap(ToolboxBlockEntity be, CallbackInfo ci) {
        if (be instanceof MountedToolbox) {
            ci.cancel();
        }
    }

    @Inject(method={"entityTick"}, remap=false, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isLoaded(Lnet/minecraft/core/BlockPos;)Z", remap=true)})
    private static void railways$connectConductorToolboxes(class_1297 entity, class_1937 world, CallbackInfo ci, @Local class_3222 player, @Local(ordinal=0) class_2487 compound, @Local(ordinal=0) int i, @Local String key, @Local(ordinal=1) class_2487 data, @Local(ordinal=1) int slot) {
        if (!data.method_25928("EntityUUID") || !(world instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)world;
        UUID uuid = data.method_25926("EntityUUID");
        class_1297 toolboxHolder = level.method_14190(uuid);
        if (toolboxHolder instanceof ConductorEntity) {
            ConductorEntity conductor = (ConductorEntity)toolboxHolder;
            MountedToolbox toolbox = conductor.getToolbox();
            if (toolbox != null) {
                toolbox.connectPlayer(slot, (class_1657)player, i);
            }
        } else {
            compound.method_10551(key);
            MixinToolboxHandler.syncData((class_1657)player);
        }
    }

    @ModifyVariable(method={"unequip"}, remap=false, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/level/Level;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;", remap=true))
    private static class_2586 railways$getConductorToolbox(class_2586 be, class_1657 player, int hotbarSlot, boolean keepItems) {
        ConductorEntity conductor;
        class_1937 class_19372 = player.field_6002;
        if (!(class_19372 instanceof class_3218)) {
            return be;
        }
        class_3218 level = (class_3218)class_19372;
        class_2487 toolboxData = EntityUtils.getPersistentData((class_1297)player).method_10562("CreateToolboxData");
        String key = String.valueOf(hotbarSlot);
        class_2487 data = toolboxData.method_10562(key);
        if (!data.method_25928("EntityUUID")) {
            return be;
        }
        UUID uuid = data.method_25926("EntityUUID");
        class_1297 entity = level.method_14190(uuid);
        if (!(entity instanceof ConductorEntity) || !(conductor = (ConductorEntity)entity).isCarryingToolbox()) {
            return be;
        }
        return conductor.getToolbox();
    }

    @Inject(method={"getNearest"}, at={@At(value="RETURN")})
    private static void railways$findNearbyConductors(class_1936 world, class_1657 player, int maxAmount, CallbackInfoReturnable<List<ToolboxBlockEntity>> cir) {
        List toolboxes = (List)cir.getReturnValue();
        Set conductors = (Set)ConductorEntity.WITH_TOOLBOXES.get(world);
        if (conductors.isEmpty()) {
            return;
        }
        class_243 playerPos = player.method_19538();
        double maxRangeSqr = Math.pow(ToolboxHandler.getMaxRange((class_1657)player), 2.0);
        for (ConductorEntity conductor : conductors) {
            if (!(ToolboxHandler.distance((class_243)playerPos, (class_2338)conductor.method_24515()) < maxRangeSqr)) continue;
            toolboxes.add(conductor.getToolbox());
        }
        toolboxes.sort((be1, be2) -> {
            double d1 = ToolboxHandler.distance((class_243)playerPos, (class_2338)be1.method_11016());
            double d2 = ToolboxHandler.distance((class_243)playerPos, (class_2338)be2.method_11016());
            return Double.compare(d1, d2);
        });
    }
}

