/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.nearby_tracker;

import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.List;
import me.jellysquid.mods.lithium.common.entity.nearby_tracker.NearbyEntityListener;
import me.jellysquid.mods.lithium.common.util.tuples.Range6Int;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_4051;
import net.minecraft.class_4076;

public class NearbyEntityTracker<T extends class_1309>
implements NearbyEntityListener {
    private final Class<T> clazz;
    private final class_1309 entity;
    private final Reference2LongOpenHashMap<T> nearbyEntities = new Reference2LongOpenHashMap(0);
    private long counter;
    private final Range6Int chunkBoxRadius;

    public NearbyEntityTracker(Class<T> clazz, class_1309 entity, class_2382 boxRadius) {
        this.clazz = clazz;
        this.entity = entity;
        this.chunkBoxRadius = new Range6Int(1 + class_4076.method_18675((int)boxRadius.method_10263()), 1 + class_4076.method_18675((int)boxRadius.method_10264()), 1 + class_4076.method_18675((int)boxRadius.method_10260()), 1 + class_4076.method_18675((int)boxRadius.method_10263()), 1 + class_4076.method_18675((int)boxRadius.method_10264()), 1 + class_4076.method_18675((int)boxRadius.method_10260()));
    }

    @Override
    public Class<? extends class_1297> getEntityClass() {
        return this.clazz;
    }

    @Override
    public Range6Int getChunkRange() {
        return this.chunkBoxRadius;
    }

    @Override
    public void onEntityEnteredRange(class_1297 entity) {
        if (!this.clazz.isInstance(entity)) {
            return;
        }
        this.nearbyEntities.put((Object)((class_1309)entity), this.counter++);
    }

    @Override
    public void onEntityLeftRange(class_1297 entity) {
        if (this.nearbyEntities.isEmpty() || !this.clazz.isInstance(entity)) {
            return;
        }
        this.nearbyEntities.removeLong((Object)entity);
    }

    public T getClosestEntity(class_238 box, class_4051 targetPredicate, double x, double y, double z) {
        class_1309 nearest = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (class_1309 entity : this.nearbyEntities.keySet()) {
            double d;
            if (box != null && !box.method_994(entity.method_5829())) continue;
            double distance = entity.method_5649(x, y, z);
            if (!(d <= nearestDistance) || !targetPredicate.method_18419(this.getEntity(), entity)) continue;
            nearest = distance == nearestDistance ? this.getFirst(nearest, entity) : entity;
            nearestDistance = distance;
        }
        return (T)nearest;
    }

    private T getFirst(T entity1, T entity2) {
        long pos2;
        if (this.getEntityClass() == class_1657.class) {
            List players = this.getEntity().method_5770().method_18456();
            return players.indexOf((class_1657)entity1) < players.indexOf((class_1657)entity2) ? entity1 : entity2;
        }
        long pos1 = class_4076.method_33706((class_2338)entity1.method_24515());
        if (pos1 < (pos2 = class_4076.method_33706((class_2338)entity2.method_24515()))) {
            return entity1;
        }
        if (pos2 < pos1) {
            return entity2;
        }
        if (this.nearbyEntities.getLong(entity1) < this.nearbyEntities.getLong(entity2)) {
            return entity1;
        }
        return entity2;
    }

    public String toString() {
        return super.toString() + " for entity class: " + this.clazz.getName() + ", around entity: " + this.getEntity().toString() + " with NBT: " + String.valueOf(this.getEntity().method_5647(new class_2487()));
    }

    class_1309 getEntity() {
        return this.entity;
    }
}

