/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.dawn.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Function;
import net.minecraft.class_5699;
import net.minecraft.class_5863;
import net.minecraft.class_6017;

public final class DawnCodecs {
    public static final Codec<Integer> NONNEGATIVE_INT = class_5699.field_33441;
    public static final Codec<Integer> POSITIVE_INT = class_5699.field_33442;
    public static final Codec<Integer> NONPOSITIVE_INT = DawnCodecs.rangedInt(Integer.MIN_VALUE, 0, v -> "Value must be non-positive: " + v);
    public static final Codec<Integer> NEGATIVE_INT = DawnCodecs.rangedInt(Integer.MIN_VALUE, -1, v -> "Value must be negative: " + v);
    public static final Codec<class_6017> INT_PROVIDER = class_6017.field_29946;
    public static final Codec<class_6017> POSITIVE_INT_PROVIDER = class_6017.field_33451;
    public static final Codec<class_6017> NONNEGATIVE_INT_PROVIDER = class_6017.field_33450;
    public static final Codec<class_6017> NON_ZERO_INT_PROVIDER = DawnCodecs.nonZeroIntProvider();
    public static final Codec<Float> POSITIVE_FLOAT = class_5699.field_34387;
    public static final Codec<Float> NONPOSITIVE_FLOAT = DawnCodecs.rangedFloat(0.0f, Float.MAX_VALUE, v -> "Value must be non-negative: " + v);
    public static final Codec<Float> NONNEGATIVE_FLOAT = DawnCodecs.rangedFloat(Float.MIN_VALUE, 0.0f, v -> "Value must be non-positive: " + v);
    public static final Codec<class_5863> FLOAT_PROVIDER = class_5863.field_29007;
    public static final Codec<class_5863> NON_ZERO_FLOAT_PROVIDER = DawnCodecs.nonZeroFloatProvider();
    public static final Codec<Long> NONNEGATIVE_LONG = DawnCodecs.rangedLong(0L, Long.MAX_VALUE, v -> "Value must be non-negative: " + v);
    public static final Codec<Long> POSITIVE_LONG = DawnCodecs.rangedLong(1L, Long.MAX_VALUE, v -> "Value must be positive: " + v);
    public static final Codec<Long> NONPOSITIVE_LONG = DawnCodecs.rangedLong(Long.MIN_VALUE, 0L, v -> "Value must be non-positive: " + v);
    public static final Codec<Long> NEGATIVE_LONG = DawnCodecs.rangedLong(Long.MIN_VALUE, -1L, v -> "Value must be negative: " + v);

    private static Codec<class_6017> nonZeroIntProvider() {
        Function<class_6017, DataResult> function = provider -> {
            if (provider.method_35009() <= 0 && provider.method_35011() >= 0) {
                return DataResult.error(() -> "Value provider should not contain the zero value: [" + provider.method_35009() + "-" + provider.method_35011() + "]");
            }
            return DataResult.success((Object)provider);
        };
        return INT_PROVIDER.flatXmap(function, function);
    }

    private static Codec<class_5863> nonZeroFloatProvider() {
        Function<class_5863, DataResult> function = provider -> {
            if (provider.method_33915() <= 0.0f && provider.method_33921() >= 0.0f) {
                return DataResult.error(() -> "Value provider should not contain the zero value: [" + provider.method_33915() + "-" + provider.method_33921() + "]");
            }
            return DataResult.success((Object)provider);
        };
        return FLOAT_PROVIDER.flatXmap(function, function);
    }

    public static Codec<Integer> rangedInt(int min, int max, Function<Integer, String> messageFactory) {
        Function<Integer, DataResult<Integer>> function = DawnCodecs.createRangeChecker(min, max, messageFactory);
        return Codec.INT.flatXmap(function, function);
    }

    public static Codec<Float> rangedFloat(float min, float max, Function<Float, String> messageFactory) {
        Function<Float, DataResult<Float>> function = DawnCodecs.createRangeChecker(Float.valueOf(min), Float.valueOf(max), messageFactory);
        return Codec.FLOAT.flatXmap(function, function);
    }

    public static Codec<Long> rangedLong(long min, long max, Function<Long, String> messageFactory) {
        Function<Long, DataResult<Long>> function = DawnCodecs.createRangeChecker(min, max, messageFactory);
        return Codec.LONG.flatXmap(function, function);
    }

    private static <N extends Number> Function<N, DataResult<N>> createRangeChecker(N min, N max, Function<N, String> messageFactory) {
        return value -> {
            if (((Comparable)((Object)value)).compareTo(min) >= 0 && ((Comparable)((Object)value)).compareTo(max) <= 0) {
                return DataResult.success((Object)value);
            }
            return DataResult.error(() -> (String)messageFactory.apply(value));
        };
    }
}

