/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.block;

import java.util.List;
import net.conczin.immersive_furniture.InteractionManager;
import net.conczin.immersive_furniture.block.FurnitureProxyBlock;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.entity.SittingEntity;
import net.conczin.immersive_furniture.item.FurnitureItem;
import net.conczin.immersive_furniture.item.Items;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.s2c.FurnitureInteractMessage;
import net.conczin.immersive_furniture.network.s2c.PoseOffsetMessage;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8567;

public abstract class BaseFurnitureBlock
extends class_2248
implements class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"active");

    public BaseFurnitureBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        FurnitureData data = this.getData(state, (class_1922)level, pos);
        if (data != null) {
            class_243 click = new class_243(hit.method_17784().field_1352 - (double)pos.method_10263(), hit.method_17784().field_1351 - (double)pos.method_10264(), hit.method_17784().field_1350 - (double)pos.method_10260());
            FurnitureData.PoseOffset offset = data.getClosestPose(click, (class_2350)state.method_11654((class_2769)FACING));
            boolean consume = false;
            if (offset != null) {
                InteractionManager.INSTANCE.addInteraction((class_1297)player, pos, offset);
                if (offset.pose() == class_4050.field_18078) {
                    BaseFurnitureBlock.startSleeping(pos, player, offset);
                } else if (offset.pose() == class_4050.field_40118) {
                    BaseFurnitureBlock.startSitting(data, level, pos, (class_2350)state.method_11654((class_2769)FACING), player, offset);
                }
                consume = true;
            }
            consume = this.trigger(data, state, level, pos, data.toggleWithRightClick) || consume;
            return consume ? class_1269.field_21466 : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    public boolean trigger(FurnitureData data, class_2680 state, class_1937 level, class_2338 pos, boolean toggle) {
        boolean consume = false;
        if (toggle) {
            state = (class_2680)state.method_28493((class_2769)ACTIVE);
            state = this.toggleLight(data, state, level, pos);
            level.method_8652(pos, state, data.getUniqueSolidStates().size() > 1 ? 3 : 7);
            consume = true;
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (data.hasSounds() || data.hasParticles()) {
                Boolean active = (Boolean)state.method_11654((class_2769)ACTIVE);
                FurnitureInteractMessage message = new FurnitureInteractMessage(pos, active);
                int maxDist = Config.getInstance().maximumInteractDistance;
                serverLevel.method_8503().method_3760().method_14571().forEach(p -> {
                    double dist = pos.method_10268(p.method_23317(), p.method_23318(), p.method_23321());
                    if (maxDist <= 0 || dist < (double)(maxDist * maxDist)) {
                        Network.sendToPlayer(message, p);
                    }
                });
                consume = true;
            }
        }
        return consume;
    }

    public class_2680 toggleLight(FurnitureData data, class_2680 state, class_1937 level, class_2338 pos) {
        return state;
    }

    public void onInteract(class_1937 level, class_2680 blockState, class_2338 pos, boolean active, class_1657 player) {
        FurnitureData data = this.getData(blockState, (class_1922)level, pos);
        if (data != null) {
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)FACING);
            int state = active ? 1 : 0;
            data.playInteractSound(level, pos, state, player);
            data.emitInteractParticles(pos, facing, state, player, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((class_1937)level).method_8406(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), false);
        }
    }

    private static void startSleeping(class_2338 pos, class_1657 player, FurnitureData.PoseOffset offset) {
        class_3222 serverPlayer;
        if (player.method_37908().field_9236) {
            return;
        }
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            PoseOffsetMessage message = new PoseOffsetMessage(pos, offset, (class_1297)serverPlayer);
            Network.sendToAllPlayers(serverPlayer.method_51469().method_8503(), message);
        }
        player.method_7269(pos).ifLeft(problem -> {
            if (problem.method_19206() != null) {
                player.method_7353(problem.method_19206(), true);
            }
        });
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            serverPlayer.method_26284(player.method_37908().method_27983(), pos, player.method_36454(), true, true);
        }
    }

    private static void startSitting(FurnitureData data, class_1937 level, class_2338 pos, class_2350 direction, class_1657 player, FurnitureData.PoseOffset offset) {
        if (!level.field_9236) {
            class_243 position = new class_243((double)((float)pos.method_10263() + offset.offset().x), (double)((float)pos.method_10264() + offset.offset().y), (double)((float)pos.method_10260() + offset.offset().z));
            SittingEntity sittingEntity = new SittingEntity(level, position, pos, data.size, direction, new class_243(player.method_23317(), player.method_23318(), player.method_23321()));
            sittingEntity.method_36456(offset.rotation());
            player.method_5804((class_1297)sittingEntity);
            sittingEntity.clampRotation((class_1297)player);
            level.method_8649((class_1297)sittingEntity);
        }
        player.field_6007 = true;
    }

    public abstract FurnitureData getData(class_2680 var1, class_1922 var2, class_2338 var3);

    public void method_9496(class_2680 blockState, class_1937 level, class_2338 pos, class_5819 random) {
        FurnitureData data = this.getData(blockState, (class_1922)level, pos);
        if (data != null) {
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)FACING);
            int state = (Boolean)blockState.method_11654((class_2769)ACTIVE) != false ? 1 : 0;
            data.tick(level, pos, state, facing, random, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((class_1937)level).method_8406(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), false, false);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            level.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)level));
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_265 shape;
        FurnitureData data = this.getData(state, level, pos);
        if (data != null && (shape = data.getShapeLazy((class_2350)state.method_11654((class_2769)FACING), (Boolean)state.method_11654((class_2769)ACTIVE) != false ? 1 : 0, 0, 0, 0)) != null) {
            return shape;
        }
        return class_2248.method_9541((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public boolean method_10311(class_1936 level, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (!((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && fluidState.method_15772() == class_3612.field_15910) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            level.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)level));
            return true;
        }
        return false;
    }

    public class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_1792 method_8389() {
        return Items.FURNITURE;
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_1799 itemStack = new class_1799((class_1935)this.method_8389());
        FurnitureData data = this.getData(state, level, pos);
        if (data != null) {
            FurnitureItem.setData(itemStack, data);
        }
        return itemStack;
    }

    public boolean method_9516(class_2680 state, class_1922 level, class_2338 pos, class_10 type) {
        return false;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 params) {
        return List.of();
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!level.field_9236) {
            FurnitureData data = this.getData(state, (class_1922)level, pos);
            if (data != null) {
                class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
                for (int x = 0; x < data.size.x; ++x) {
                    for (int y = 0; y < data.size.y; ++y) {
                        for (int z = 0; z < data.size.z; ++z) {
                            class_2338 proxyPos;
                            class_2680 proxyState;
                            if (x == 0 && y == 0 && z == 0 || !((proxyState = level.method_8320(proxyPos = BaseFurnitureBlock.getProxyPosition(pos, facing, x, y, z))).method_26204() instanceof FurnitureProxyBlock)) continue;
                            level.method_8650(proxyPos, false);
                        }
                    }
                }
                class_238 aabb = new class_238(pos, pos.method_10069(data.size.x, data.size.y, data.size.z)).method_1014(1.0);
                level.method_18467(SittingEntity.class, aabb).forEach(class_1297::method_5772);
            }
            if (!player.method_7337()) {
                class_1799 itemStack = this.method_9574((class_1922)level, pos, state);
                class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)itemStack);
            }
        }
        super.method_9576(level, pos, state, player);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 blockState, class_1937 level, class_2338 pos) {
        return class_1703.method_7608((class_2586)level.method_8321(pos));
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        FurnitureData data;
        boolean flag;
        if (!level.field_9236 && (flag = ((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) != level.method_49803(pos) && (data = this.getData(state, (class_1922)level, pos)) != null) {
            this.trigger(data, state, level, pos, true);
        }
    }

    public static class_2338 getProxyPosition(class_2338 basePos, class_2350 facing, int offsetX, int offsetY, int offsetZ) {
        int dx = 0;
        int dz = 0;
        switch (facing) {
            case field_11043: {
                dz = offsetZ;
                dx = offsetX;
                break;
            }
            case field_11035: {
                dz = -offsetZ;
                dx = -offsetX;
                break;
            }
            case field_11034: {
                dx = -offsetZ;
                dz = offsetX;
                break;
            }
            case field_11039: {
                dx = offsetZ;
                dz = -offsetX;
                break;
            }
        }
        return basePos.method_10069(dx, offsetY, dz);
    }
}

