/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client;

import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.minecraft.class_2350;
import net.minecraft.class_5253;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Utils {
    public static Ray inverseTransformRay(float mouseX, float mouseY, Matrix4f modelViewMatrix, FurnitureData.Element element) {
        Vector4f rayStart = new Vector4f(mouseX, mouseY, 1.0f, 1.0f);
        Vector4f rayEnd = new Vector4f(rayStart.x, rayStart.y, -1.0f, 1.0f);
        Matrix4f inverseModelView = new Matrix4f((Matrix4fc)modelViewMatrix).invert();
        Vector4f rayStartModel = inverseModelView.transform(rayStart);
        Vector4f rayEndModel = inverseModelView.transform(rayEnd);
        rayStartModel.div(rayStartModel.w);
        rayEndModel.div(rayEndModel.w);
        Vector3f rayStartPos = new Vector3f(rayStartModel.x, rayStartModel.y, rayStartModel.z);
        ModelUtils.applyInverseElementRotation(rayStartPos, element.getRotation());
        Vector3f rayEndPos = new Vector3f(rayEndModel.x, rayEndModel.y, rayEndModel.z);
        ModelUtils.applyInverseElementRotation(rayEndPos, element.getRotation());
        Vector3f origin = new Vector3f(rayStartPos.x, rayStartPos.y, rayStartPos.z);
        Vector3f direction = new Vector3f(rayEndPos.x - rayStartPos.x, rayEndPos.y - rayStartPos.y, rayEndPos.z - rayStartPos.z).normalize();
        return new Ray(origin, direction);
    }

    public static RaycastResult raycast(Ray ray, FurnitureData.Element element) {
        float tMax;
        float tMin;
        float tMaxZ;
        float tMinZ;
        float tMaxY;
        float tMinY;
        Vector3f min = new Vector3f(element.from.x() / 16.0f, element.from.y() / 16.0f, element.from.z() / 16.0f);
        Vector3f max = new Vector3f(element.to.x() / 16.0f, element.to.y() / 16.0f, element.to.z() / 16.0f);
        float tMinX = (min.x - ray.origin.x) / ray.direction.x;
        float tMaxX = (max.x - ray.origin.x) / ray.direction.x;
        if (tMinX > tMaxX) {
            float temp = tMinX;
            tMinX = tMaxX;
            tMaxX = temp;
        }
        if ((tMinY = (min.y - ray.origin.y) / ray.direction.y) > (tMaxY = (max.y - ray.origin.y) / ray.direction.y)) {
            float temp = tMinY;
            tMinY = tMaxY;
            tMaxY = temp;
        }
        if ((tMinZ = (min.z - ray.origin.z) / ray.direction.z) > (tMaxZ = (max.z - ray.origin.z) / ray.direction.z)) {
            float temp = tMinZ;
            tMinZ = tMaxZ;
            tMaxZ = temp;
        }
        if ((tMin = Math.max(Math.max(tMinX, tMinY), tMinZ)) > (tMax = Math.min(Math.min(tMaxX, tMaxY), tMaxZ))) {
            return null;
        }
        Vector3f intersection = new Vector3f(ray.origin.x + ray.direction.x * tMin, ray.origin.y + ray.direction.y * tMin, ray.origin.z + ray.direction.z * tMin);
        class_2350 face = Utils.getDirection(intersection, min, max);
        if (face == null) {
            return null;
        }
        return new RaycastResult(element, face, -tMin, intersection);
    }

    private static class_2350 getDirection(Vector3f intersection, Vector3f min, Vector3f max) {
        float epsilon = 1.0E-4f;
        if (Math.abs(intersection.x - min.x) < epsilon) {
            return class_2350.field_11039;
        }
        if (Math.abs(intersection.x - max.x) < epsilon) {
            return class_2350.field_11034;
        }
        if (Math.abs(intersection.y - min.y) < epsilon) {
            return class_2350.field_11033;
        }
        if (Math.abs(intersection.y - max.y) < epsilon) {
            return class_2350.field_11036;
        }
        if (Math.abs(intersection.z - min.z) < epsilon) {
            return class_2350.field_11043;
        }
        if (Math.abs(intersection.z - max.z) < epsilon) {
            return class_2350.field_11035;
        }
        return null;
    }

    public static float[] rgbToHsv(int color) {
        float r = (float)class_5253.class_8045.method_48345((int)color) / 255.0f;
        float g = (float)class_5253.class_8045.method_48346((int)color) / 255.0f;
        float b = (float)class_5253.class_8045.method_48347((int)color) / 255.0f;
        return Utils.rgbToHsv(r, g, b);
    }

    public static float[] rgbToHsv(float r, float g, float b) {
        float min;
        float max = Math.max(r, Math.max(g, b));
        float delta = max - (min = Math.min(r, Math.min(g, b)));
        float h = delta == 0.0f ? 0.0f : (max == r ? 60.0f * ((g - b) / delta % 6.0f) : (max == g ? 60.0f * ((b - r) / delta + 2.0f) : 60.0f * ((r - g) / delta + 4.0f)));
        if (h < 0.0f) {
            h += 360.0f;
        }
        float s = max == 0.0f ? 0.0f : delta / max;
        return new float[]{h, s, max};
    }

    public static float[] hsvToRgbRaw(float h, float s, float v) {
        float b;
        float g;
        float r;
        float c = v * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        if (h < 60.0f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (h < 120.0f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (h < 180.0f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (h < 240.0f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (h < 300.0f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        return new float[]{r + m, g + m, b + m};
    }

    public static int hsvToRgb(float h, float s, float v) {
        float[] rgb = Utils.hsvToRgbRaw(h, s, v);
        return class_5253.class_8045.method_48344((int)255, (int)((int)(rgb[0] * 255.0f)), (int)((int)(rgb[1] * 255.0f)), (int)((int)(rgb[2] * 255.0f)));
    }

    public record Ray(Vector3f origin, Vector3f direction) {
    }

    public record RaycastResult(FurnitureData.Element element, class_2350 face, float distance, Vector3f intersection) {
    }
}

