/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.PreviewParticleEngine;
import net.conczin.immersive_furniture.client.model.CompositeBakedModel;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.FurnitureModelBaker;
import net.conczin.immersive_furniture.client.model.MaterialRegistry;
import net.conczin.immersive_furniture.client.model.TransparencyManager;
import net.conczin.immersive_furniture.client.renderer.FurnitureBlockEntityRenderer;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public abstract class ArtisansWorkstationScreen
extends class_437 {
    public static final class_2561 TITLE = class_2561.method_43471((String)"item.immersive_furniture.artisans_workstation");
    public static final class_2960 TEXTURE = Common.locate("textures/gui/gui.png");
    public static final int TEXTURE_SIZE = 256;
    protected class_2561 error;
    protected long lastErrorTime = 0L;
    protected long lastCriticalActionAttempt = 0L;
    int windowWidth = 280;
    int windowHeight = 180;
    int leftPos;
    int topPos;
    boolean nightMode = false;
    public int currentState = 0;
    private static CompositeBakedModel lastBakedModel = null;
    private static final Map<Object, PreviewParticleEngine> objectToParticleEngine = Collections.synchronizedMap(new LinkedHashMap<Object, PreviewParticleEngine>(30, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, PreviewParticleEngine> eldest) {
            return this.size() > 30;
        }
    });

    public ArtisansWorkstationScreen() {
        super(TITLE);
        if (MaterialRegistry.INSTANCE.materials.isEmpty()) {
            new Thread(MaterialRegistry.INSTANCE::sync).start();
        }
    }

    protected void drawRectangle(class_332 graphics, int x, int y, int w, int h) {
        this.drawRectangle(graphics, x, y, w, h, 0, 0);
    }

    protected void drawRectangle(class_332 graphics, int x, int y, int w, int h, int originY, int originX) {
        graphics.method_25290(TEXTURE, x, y, (float)originX, (float)originY, 16, 16, 256, 256);
        graphics.method_25290(TEXTURE, x + w - 16, y, (float)(originX + 32), (float)originY, 16, 16, 256, 256);
        graphics.method_25290(TEXTURE, x + w - 16, y + h - 16, (float)(originX + 32), (float)(originY + 32), 16, 16, 256, 256);
        graphics.method_25290(TEXTURE, x, y + h - 16, (float)originX, (float)(originY + 32), 16, 16, 256, 256);
        graphics.method_25293(TEXTURE, x + 16, y, w - 32, 16, (float)(originX + 16), (float)originY, 16, 16, 256, 256);
        graphics.method_25293(TEXTURE, x + 16, y + h - 16, w - 32, 16, (float)(originX + 16), (float)(originY + 32), 16, 16, 256, 256);
        graphics.method_25293(TEXTURE, x, y + 16, 16, h - 32, (float)originX, (float)(originY + 16), 16, 16, 256, 256);
        graphics.method_25293(TEXTURE, x + w - 16, y + 16, 16, h - 32, (float)(originX + 32), (float)(originY + 16), 16, 16, 256, 256);
        graphics.method_25293(TEXTURE, x + 16, y + 16, w - 32, h - 32, (float)(originX + 16), (float)(originY + 16), 16, 16, 256, 256);
    }

    void renderModel(class_332 graphics, FurnitureData data, double x, double y, double size, float yaw, float pitch) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_22904(x, y, 100.0);
        graphics.method_51448().method_34425(new Matrix4f().scaling((float)(size / Math.max(1.0, data.getSize() / 16.0) * 0.4)));
        graphics.method_51448().method_22907(new Quaternionf().rotateX(pitch).rotateY(yaw));
        graphics.method_51448().method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        class_243 center = data.boundingBox().method_1005();
        graphics.method_51448().method_22904(-center.field_1352 / 16.0, -center.field_1351 / 16.0, -center.field_1350 / 16.0);
        this.renderModel(graphics, data, yaw, pitch, false);
        graphics.method_51448().method_22909();
    }

    void renderModel(class_332 graphics, FurnitureData data, float yaw, float pitch, boolean inEditor) {
        TransparencyManager.heySodiumImInUse(data);
        if (inEditor) {
            TransparencyManager.prepare(data);
        }
        CompositeBakedModel bakedModel = FurnitureModelBaker.getAsyncModel(data, DynamicAtlas.SCRATCH, this.currentState);
        if (inEditor) {
            if (bakedModel == null) {
                bakedModel = lastBakedModel;
            } else {
                lastBakedModel = bakedModel;
            }
        }
        if (bakedModel != null) {
            int light = this.nightMode ? data.lightLevel : 15;
            int packedLight = light << 20 | light << 4 | light;
            FurnitureBlockEntityRenderer.renderFurniture(null, graphics.method_51448(), (class_4597)graphics.method_51450(), packedLight, class_4608.field_21444, bakedModel, DynamicAtlas.SCRATCH);
            assert (this.field_22787 != null);
            class_918 itemRenderer = this.field_22787.method_1480();
            FurnitureBlockEntityRenderer.drawItems(itemRenderer, (class_1937)this.field_22787.field_1687, null, this.currentState, graphics.method_51448(), (class_4597)graphics.method_51450(), packedLight, class_4608.field_21444, data);
        }
        long time = System.currentTimeMillis() / 50L;
        float partialTicks = (float)(System.currentTimeMillis() % 50L) / 50.0f;
        if (time != data.lastTick) {
            data.lastTick = time;
            class_638 level = class_310.method_1551().field_1687;
            class_746 player = class_310.method_1551().field_1724;
            if (level == null || player == null) {
                return;
            }
            if (level.method_8409().method_43057() < 0.2f) {
                data.tick((class_1937)level, player.method_23312(), this.currentState, null, level.method_8409(), ArtisansWorkstationScreen.getParticleEngine(data)::addParticle, true, inEditor);
            }
            ArtisansWorkstationScreen.getParticleEngine(data).tick();
        }
        ArtisansWorkstationScreen.getParticleEngine(data).renderParticles(graphics, yaw, pitch, partialTicks);
        graphics.method_51452();
    }

    void line(class_332 graphics, float x0, float y0, float z0, float x1, float y1, float z1, float width, boolean overlay, float r, float g, float b, float a) {
        float length = (float)Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0));
        float nx = (y1 - y0) / length * width * 0.5f;
        float ny = (x0 - x1) / length * width * 0.5f;
        Matrix4f matrix4f = graphics.method_51448().method_23760().method_23761();
        class_4588 vertexConsumer = graphics.method_51450().getBuffer(overlay ? class_1921.method_51785() : class_1921.method_51784());
        float z = 2.0f;
        vertexConsumer.method_22918(matrix4f, x1 - nx + 0.5f, y1 - ny + 0.5f, z1 + z).method_22915(r, g, b, a).method_1344();
        vertexConsumer.method_22918(matrix4f, x1 + nx + 0.5f, y1 + ny + 0.5f, z1 + z).method_22915(r, g, b, a).method_1344();
        vertexConsumer.method_22918(matrix4f, x0 + nx + 0.5f, y0 + ny + 0.5f, z0 + z).method_22915(r, g, b, a).method_1344();
        vertexConsumer.method_22918(matrix4f, x0 - nx + 0.5f, y0 - ny + 0.5f, z0 + z).method_22915(r, g, b, a).method_1344();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    protected void method_25426() {
        this.method_37067();
        super.method_25426();
        this.leftPos = (this.field_22789 - this.windowWidth) / 2;
        this.topPos = (this.field_22790 - this.windowHeight) / 2;
    }

    public <T extends class_364 & class_4068> T method_37063(T widget) {
        return (T)super.method_37063(widget);
    }

    public static PreviewParticleEngine getParticleEngine(FurnitureData data) {
        return objectToParticleEngine.computeIfAbsent(data, d -> new PreviewParticleEngine());
    }

    public void clearError() {
        this.error = null;
    }

    public void setError(String text) {
        this.error = class_2561.method_43471((String)text);
        this.lastErrorTime = System.currentTimeMillis();
    }

    protected void renderError(class_332 graphics, int y) {
        if (this.error == null) {
            return;
        }
        graphics.method_25294(this.field_22789 / 2 - 80, y - 3, this.field_22789 / 2 + 80, y + 10, Integer.MIN_VALUE);
        graphics.method_27534(this.field_22793, this.error, this.field_22789 / 2, y, -65536);
        if (System.currentTimeMillis() - this.lastErrorTime > 5000L) {
            this.clearError();
        }
    }
}

