/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.components.ListComponent;
import net.conczin.immersive_furniture.client.gui.widgets.MaterialButton;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.client.model.MaterialRegistry;
import net.conczin.immersive_furniture.client.model.MaterialSource;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.class_2960;

public class MaterialsComponent
extends ListComponent {
    private final List<Map.Entry<class_2960, MaterialSource>> filteredMaterials = new LinkedList<Map.Entry<class_2960, MaterialSource>>();
    final List<MaterialButton> materialButtons = new ArrayList<MaterialButton>();
    StateImageButton repeatButton;
    StateImageButton favoriteButton;

    public MaterialsComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        FurnitureData.Element element = this.screen.getFirstElement().orElse(null);
        if (element != null) {
            int i = 0;
            for (FurnitureData.MaterialAxis axis : FurnitureData.MaterialAxis.values()) {
                this.addToggleButton(leftPos + 6 + i * 18, topPos + 22, 16, 16 + i * 16, 192, "", () -> {
                    this.screen.selectedElements.forEach(e -> {
                        e.material.axis = axis;
                    });
                    this.screen.method_25426();
                }).setEnabled(element.material.axis != axis);
                ++i;
            }
            this.repeatButton = this.addToggleButton(leftPos + 6 + 54, topPos + 22, 16, 144, 192, "gui.immersive_furniture.repeat", () -> {
                if (element.material.wrap == FurnitureData.WrapMode.EXPAND) {
                    this.screen.selectedElements.forEach(e -> {
                        e.material.wrap = FurnitureData.WrapMode.REPEAT;
                    });
                    this.repeatButton.setEnabled(false);
                } else {
                    this.screen.selectedElements.forEach(e -> {
                        e.material.wrap = FurnitureData.WrapMode.EXPAND;
                    });
                    this.repeatButton.setEnabled(true);
                }
            });
            this.repeatButton.setEnabled(element.material.wrap == FurnitureData.WrapMode.EXPAND);
            this.favoriteButton = this.addToggleButton(leftPos + 100 - 6 - 16, topPos + 22, 16, 128, 192, "gui.immersive_furniture.favorite", () -> {
                String location = element.material.source.toString();
                if (Config.getInstance().favorites.contains(location)) {
                    Config.getInstance().favorites.remove(location);
                    this.favoriteButton.setEnabled(true);
                } else {
                    Config.getInstance().favorites.add(location);
                    this.favoriteButton.setEnabled(false);
                }
                Config.getInstance().save();
                this.screen.method_25426();
            });
            this.favoriteButton.setEnabled(!Config.getInstance().favorites.contains(element.material.source.toString()));
        }
        this.materialButtons.clear();
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 4; ++x) {
                MaterialButton button = new MaterialButton(leftPos + 6 + x * 22, topPos + 44 + y * 22, 22, 22, 146, 0, b -> {
                    MaterialSource material = ((MaterialButton)b).getMaterial();
                    if (material != null) {
                        this.screen.selectedElements.forEach(e -> {
                            e.material.source = material.location();
                        });
                        this.screen.method_25426();
                    }
                });
                button.setEnabled(element != null && button.getMaterial() != null && button.getMaterial().location().equals((Object)element.material.source));
                this.materialButtons.add(button);
                this.screen.method_37063(button);
            }
        }
        super.init(leftPos, topPos, width, height);
    }

    @Override
    int getPages() {
        return Math.max(0, (this.filteredMaterials.size() - 1) / 20 + 1);
    }

    @Override
    void updateSearch() {
        this.filteredMaterials.clear();
        MaterialRegistry.INSTANCE.materials.entrySet().stream().filter(entry -> Utils.search(this.searchBox.method_1882(), ((class_2960)entry.getKey()).toString())).sorted(Comparator.comparingInt(a -> Config.getInstance().favorites.contains(((class_2960)a.getKey()).toString()) ? 0 : 1)).forEach(this.filteredMaterials::add);
        this.page = Math.min(this.page, this.getPages() - 1);
        for (int i = 0; i < this.materialButtons.size(); ++i) {
            int li = i + this.page * this.materialButtons.size();
            if (li < this.filteredMaterials.size()) {
                this.materialButtons.get(i).setMaterial(this.filteredMaterials.get(li).getValue());
                this.materialButtons.get(i).setEnabled(true);
                continue;
            }
            this.materialButtons.get(i).setMaterial(null);
            this.materialButtons.get(i).setEnabled(false);
        }
    }
}

