/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.components.ListComponent;
import net.conczin.immersive_furniture.client.gui.widgets.SpriteButton;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.client.model.TransparencyManager;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.TransparencyType;
import net.conczin.immersive_furniture.mixin.client.SpriteContentsAccessor;
import net.conczin.immersive_furniture.mixin.client.TextureAtlasAccessor;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7764;

public class SpritesComponent
extends ListComponent {
    private final List<class_7764> allSprites;
    private List<class_2960> filteredSprites = new LinkedList<class_2960>();
    final List<SpriteButton> spriteButtons = new ArrayList<SpriteButton>();
    private boolean vanillaOnly = true;
    public FilterType filterType = FilterType.ANIMATIONS;

    public SpritesComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
        class_1059 atlas = class_310.method_1551().method_1554().method_24153(class_1723.field_21668);
        List<class_7764> sprites = ((TextureAtlasAccessor)atlas).getSprites();
        this.allSprites = sprites.stream().filter(SpritesComponent::sanityFilter).filter(SpritesComponent::isSquare).toList();
    }

    private static boolean sanityFilter(class_7764 s) {
        if (s.method_45816().method_12832().endsWith("_side")) {
            return false;
        }
        if (s.method_45816().method_12832().endsWith("_bottom")) {
            return false;
        }
        return !s.method_45816().method_12832().endsWith("_top");
    }

    private static boolean isSquare(class_7764 spriteContents) {
        int height;
        int width = spriteContents.method_45807();
        return width == (height = spriteContents.method_45815()) && Math.pow((int)Math.sqrt(width), 2.0) == (double)width;
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        int tx = 7;
        int u = 0;
        for (FilterType value : FilterType.values()) {
            StateImageButton button = this.addToggleButton(leftPos + tx, topPos + 22, 16, u, 160, "gui.immersive_furniture.sprite_filter." + value.name().toLowerCase(Locale.ROOT), () -> {
                this.filterType = value;
                this.screen.method_25426();
            });
            button.setEnabled(this.filterType == value);
            tx += 18;
            u += 16;
        }
        this.addToggleButton(leftPos + 80, topPos + 22, 16, 80, 160, "gui.immersive_furniture.vanilla", () -> {
            this.vanillaOnly = !this.vanillaOnly;
            this.screen.method_25426();
        }).setEnabled(this.vanillaOnly);
        FurnitureData.Element firstElement = this.screen.getFirstElement().orElse(null);
        this.spriteButtons.clear();
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 4; ++x) {
                SpriteButton button = new SpriteButton(leftPos + 6 + x * 22, topPos + 44 + y * 22, 22, 22, 146, 0, b -> {
                    class_2960 spriteLocation = ((SpriteButton)b).getSpriteLocation();
                    if (spriteLocation != null) {
                        this.screen.selectedElements.forEach(e -> {
                            e.sprite.sprite = spriteLocation;
                        });
                        this.screen.method_25426();
                    }
                });
                button.setEnabled(firstElement != null && button.getSpriteLocation() != null && button.getSpriteLocation().equals((Object)firstElement.sprite.sprite));
                this.spriteButtons.add(button);
                this.screen.method_37063(button);
            }
        }
        super.init(leftPos, topPos, width, height);
    }

    @Override
    int getPages() {
        return Math.max(0, (this.filteredSprites.size() - 1) / 20 + 1);
    }

    private boolean filter(class_7764 s) {
        return switch (this.filterType) {
            default -> throw new IncompatibleClassChangeError();
            case FilterType.ANIMATIONS -> {
                if (((SpriteContentsAccessor)s).immersiveFurniture$getFrameCount() > 1) {
                    yield true;
                }
                yield false;
            }
            case FilterType.ITEMS -> s.method_45816().toString().contains("item/");
            case FilterType.SPRITES -> {
                if (TransparencyManager.INSTANCE.getTransparencyType(s) != TransparencyType.SOLID && TransparencyManager.INSTANCE.isCornerTransparent(s) && !s.method_45816().toString().contains("item/")) {
                    yield true;
                }
                yield false;
            }
            case FilterType.ALL -> true;
        };
    }

    @Override
    void updateSearch() {
        this.filteredSprites = this.allSprites.stream().filter((? super T s) -> !this.vanillaOnly || s.method_45816().method_12836().equals("minecraft")).filter((? super T s) -> Utils.search(this.searchBox.method_1882(), s.method_45816().toString())).filter(this::filter).map(class_7764::method_45816).toList();
        this.page = Math.max(0, Math.min(this.page, this.getPages() - 1));
        class_1059 blockAtlas = class_310.method_1551().method_1554().method_24153(class_1723.field_21668);
        for (int i = 0; i < this.spriteButtons.size(); ++i) {
            int li = i + this.page * this.spriteButtons.size();
            if (li < this.filteredSprites.size()) {
                class_2960 location = this.filteredSprites.get(li);
                class_1058 sprite = blockAtlas.method_4608(location);
                this.spriteButtons.get(i).setSpriteLocation(location);
                this.spriteButtons.get(i).setSprite(sprite);
                this.spriteButtons.get(i).setEnabled(!this.screen.selectedElements.isEmpty());
                continue;
            }
            this.spriteButtons.get(i).setSpriteLocation(null);
            this.spriteButtons.get(i).setSprite(null);
            this.spriteButtons.get(i).setEnabled(false);
        }
    }

    public static enum FilterType {
        ITEMS,
        SPRITES,
        ANIMATIONS,
        ALL;

    }
}

