/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.conczin.immersive_furniture.data.ElementRotation;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.ModelUtils;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;

public class AmbientOcclusion {
    private static final double SAMPLE_RESOLUTION = Math.sqrt(3.0);
    private static final float RESOLUTION = 0.25f;
    private final Long2ObjectOpenHashMap<ObjectOpenHashSet<PrecomputedElement>> elementCache = new Long2ObjectOpenHashMap();
    static final List<Vector3f> kernel = new ArrayList<Vector3f>();

    private Set<PrecomputedElement> getElements(float x, float y, float z) {
        int gx = Math.round(x * 0.25f);
        int gy = Math.round(y * 0.25f);
        int gz = Math.round(z * 0.25f);
        long key = (long)gx << 40 | (long)gy << 20 | (long)gz;
        return (Set)this.elementCache.computeIfAbsent(key, k -> new ObjectOpenHashSet());
    }

    public void place(FurnitureData.Element element, float opacity) {
        Vector3f center = element.getCenter();
        Vector3i size = element.getSize();
        ElementRotation elementRotation = element.getRotation();
        Quaternionf rotation = ModelUtils.getElementRotation(elementRotation);
        PrecomputedElement precomputed = new PrecomputedElement(element, new Quaternionf((Quaternionfc)rotation).conjugate(), element.getOrigin().mul(16.0f), opacity);
        Vector3f nx = rotation.transform(new Vector3f((float)size.x(), 0.0f, 0.0f));
        Vector3f ny = rotation.transform(new Vector3f(0.0f, (float)size.y(), 0.0f));
        Vector3f nz = rotation.transform(new Vector3f(0.0f, 0.0f, (float)size.z()));
        float buffer = (float)(2.0 * SAMPLE_RESOLUTION * 0.25);
        int width = (int)Math.ceil((double)size.x() * SAMPLE_RESOLUTION * 0.25 + (double)buffer);
        int height = (int)Math.ceil((double)size.y() * SAMPLE_RESOLUTION * 0.25 + (double)buffer);
        int depth = (int)Math.ceil((double)size.z() * SAMPLE_RESOLUTION * 0.25 + (double)buffer);
        for (int ix = 0; ix <= width; ++ix) {
            for (int iy = 0; iy <= height; ++iy) {
                for (int iz = 0; iz <= depth; ++iz) {
                    float sx = ((float)ix - (float)width / 2.0f) / ((float)width - buffer);
                    float sy = ((float)iy - (float)height / 2.0f) / ((float)height - buffer);
                    float sz = ((float)iz - (float)depth / 2.0f) / ((float)depth - buffer);
                    float x = nx.x * sx + ny.x * sy + nz.x * sz + center.x;
                    float y = nx.y * sx + ny.y * sy + nz.y * sz + center.y;
                    float z = nx.z * sx + ny.z * sy + nz.z * sz + center.z;
                    this.getElements(x, y, z).add(precomputed);
                }
            }
        }
    }

    private float is(float x, float y, float z) {
        float e = 1.0E-4f;
        Vector3f pos = new Vector3f();
        for (PrecomputedElement p : this.getElements(x, y, z)) {
            pos.set(x - p.origin.x, y - p.origin.y, z - p.origin.z);
            p.rotation.transform(pos);
            pos.add((Vector3fc)p.origin);
            if (!(pos.x > p.element.from.x + e) || !(pos.x < p.element.to.x - e) || !(pos.y > p.element.from.y + e) || !(pos.y < p.element.to.y - e) || !(pos.z > p.element.from.z + e) || !(pos.z < p.element.to.z - e)) continue;
            return p.opacity;
        }
        return 0.0f;
    }

    public float sample(Vector3f pos, Vector3f normal) {
        float value = 0.0f;
        float totalWeight = 0.0f;
        for (Vector3f offset : kernel) {
            float dot = normal.x * offset.x + normal.y * offset.y + normal.z * offset.z;
            if (dot <= 0.0f) continue;
            value += this.is(pos.x + offset.x, pos.y + offset.y, pos.z + offset.z);
            totalWeight += 1.0f;
        }
        return value / totalWeight;
    }

    static {
        int radius = 4;
        for (float x = (float)(-radius); x <= (float)radius; x += 1.0f) {
            for (float y = (float)(-radius); y <= (float)radius; y += 1.0f) {
                for (float z = (float)(-radius); z <= (float)radius; z += 1.0f) {
                    float distance = x * x + y * y + z * z;
                    if (!(distance > 0.0f) || !(distance <= (float)(radius * radius))) continue;
                    kernel.add(new Vector3f(x, y, z));
                }
            }
        }
    }

    record PrecomputedElement(FurnitureData.Element element, Quaternionf rotation, Vector3f origin, float opacity) {
    }
}

