/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.model.FurnitureModelBaker;
import net.conczin.immersive_furniture.client.model.TextureAtlasSpriteAccessor;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7764;
import net.minecraft.class_7771;

public class DynamicAtlas
extends class_1043 {
    public static final DynamicAtlas BAKED = new DynamicAtlas(1024, "baked");
    public static final DynamicAtlas ENTITY = new DynamicAtlas(512, "entity");
    public static final DynamicAtlas SCRATCH = new DynamicAtlas(512, "scratch");
    int lastStateId;
    boolean full;
    int allocated;
    int size;
    class_2960 location;
    List<Quad> quads = new LinkedList<Quad>();
    public Map<String, FurnitureModelBaker.CachedBakedModelSet> knownFurniture = new ConcurrentHashMap<String, FurnitureModelBaker.CachedBakedModelSet>();
    public Set<String> asyncRequestedFurniture = new ConcurrentSkipListSet<String>();
    public final TextureAtlasSpriteAccessor sprite;
    private boolean dirty = false;

    public DynamicAtlas(int size, String name) {
        super(size, size, false);
        this.size = size;
        this.location = Common.locate("immersive_furniture_atlas/" + name);
        class_310.method_1551().method_1531().method_4616(this.location, (class_1044)this);
        class_7764 contents = new class_7764(this.location, new class_7771(size, size), Objects.requireNonNull(this.method_4525()), class_1079.field_21768);
        this.sprite = new TextureAtlasSpriteAccessor(this.location, contents, size, size, 0, 0);
        this.clear();
    }

    public static void boostrap() {
    }

    public synchronized Quad allocate(int w, int h) {
        Quad best = this.getBestQuad(w, h);
        if (best != null) {
            this.quads.remove(best);
            int dw = best.w - w;
            int dh = best.h - h;
            if (dw > dh) {
                if (dw > 0) {
                    this.quads.add(new Quad(best.x + w, best.y, dw, best.h));
                }
                if (dh > 0) {
                    this.quads.add(new Quad(best.x, best.y + h, w, dh));
                }
            } else {
                if (dw > 0) {
                    this.quads.add(new Quad(best.x + w, best.y, dw, h));
                }
                if (dh > 0) {
                    this.quads.add(new Quad(best.x, best.y + h, best.w, dh));
                }
            }
            this.allocated += w * h;
            return new Quad(best.x, best.y, w, h);
        }
        this.full = true;
        return new Quad(0, 0, 0, 0);
    }

    private Quad getBestQuad(int w, int h) {
        Quad best = null;
        int bestLoss = Integer.MAX_VALUE;
        for (Quad quad : this.quads) {
            float aspect;
            int waste;
            int loss;
            if (quad.w < w || quad.h < h || (loss = (int)((float)(waste = quad.w * quad.h - w * h) * (aspect = (float)Math.max(quad.w, quad.h) / (float)Math.min(quad.w, quad.h)))) >= bestLoss) continue;
            best = quad;
            bestLoss = loss;
        }
        return best;
    }

    public synchronized void clear() {
        this.quads.clear();
        this.quads.add(new Quad(0, 0, this.size, this.size));
        this.allocated = 0;
        this.full = false;
        this.knownFurniture.clear();
        this.asyncRequestedFurniture.clear();
    }

    public boolean isFull() {
        return this.full;
    }

    public float getUsage() {
        return (float)this.allocated / (float)(this.size * this.size);
    }

    public class_2960 getLocation() {
        return this.location;
    }

    public int getSize() {
        return this.size;
    }

    public void setDirty() {
        this.dirty = true;
        ++this.lastStateId;
    }

    public void uploadIfDirty() {
        if (this.dirty && RenderSystem.isOnRenderThreadOrInit()) {
            this.method_4524();
            this.dirty = false;
        }
    }

    public int getLastStateId() {
        return this.lastStateId;
    }

    public record Quad(int x, int y, int w, int h) {
    }
}

