/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.client.Utils;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.model.AmbientOcclusion;
import net.conczin.immersive_furniture.client.model.ClientModelUtils;
import net.conczin.immersive_furniture.client.model.CompositeBlockModel;
import net.conczin.immersive_furniture.client.model.DynamicAtlas;
import net.conczin.immersive_furniture.client.model.MaterialSource;
import net.conczin.immersive_furniture.client.model.TransparencyManager;
import net.conczin.immersive_furniture.config.Config;
import net.conczin.immersive_furniture.data.ElementRotation;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.ModelUtils;
import net.conczin.immersive_furniture.data.TransparencyType;
import net.minecraft.class_1011;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_4730;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_787;
import net.minecraft.class_789;
import net.minecraft.class_793;
import net.minecraft.class_804;
import net.minecraft.class_809;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2i;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class FurnitureModelFactory {
    private final boolean inEditor;
    private final FurnitureData data;
    private final DynamicAtlas atlas;
    private final Map<Integer, AmbientOcclusion> aos;
    private int zFightingCounter = 0;
    private final Map<Integer, Map<FurnitureData.Element, Map<class_2350, class_783>>> faces = new HashMap<Integer, Map<FurnitureData.Element, Map<class_2350, class_783>>>();
    private final List<FurnitureData.Element> elements = new LinkedList<FurnitureData.Element>();
    private final Map<String, Either<class_4730, String>> textures = new HashMap<String, Either<class_4730, String>>();
    private final Map<FurnitureData.Element, Integer> elementToIndex = new HashMap<FurnitureData.Element, Integer>();
    private final Map<Integer, FurnitureData.Element> indexToElement = new HashMap<Integer, FurnitureData.Element>();

    private FurnitureModelFactory(FurnitureData data, DynamicAtlas atlas) {
        this.inEditor = class_310.method_1551().field_1755 instanceof ArtisansWorkstationEditorScreen;
        this.data = data;
        this.atlas = atlas;
        this.splitSprites();
        this.aos = new HashMap<Integer, AmbientOcclusion>();
        for (int state : data.getUniqueSolidStates()) {
            AmbientOcclusion ao = new AmbientOcclusion();
            for (FurnitureData.Element element : this.elements) {
                if (element.type != FurnitureData.ElementType.ELEMENT || !element.isMasked(state)) continue;
                ao.place(element, element.material.transparency == TransparencyType.SOLID ? 1.0f : 0.25f);
            }
            this.aos.put(state, ao);
        }
        this.textures.put("0", (Either<class_4730, String>)Either.left((Object)new class_4730(class_1723.field_21668, Common.locate("block/furniture"))));
        this.elements.stream().filter(e -> e.type == FurnitureData.ElementType.SPRITE).map(e -> e.sprite.sprite).distinct().forEach(source -> this.textures.put(source.toString(), (Either<class_4730, String>)Either.left((Object)new class_4730(class_1723.field_21668, source))));
        for (int state : data.getUniqueSolidStates()) {
            this.faces.put(state, this.elements.stream().filter(FurnitureModelFactory::hasFaces).filter(e -> e.isMasked(state)).collect(Collectors.toMap(e -> e, e -> this.getFaces((FurnitureData.Element)e, state))));
        }
    }

    float mod(float a, float b) {
        return (a % b + b) % b;
    }

    private class_783 getFace(FurnitureData.Element element, class_2350 direction, int state) {
        DynamicAtlas.Quad quad;
        float[] fs = ClientModelUtils.getShapeData(element);
        Vector3f[] vertices = ClientModelUtils.getVertices(element, direction, fs, null);
        for (FurnitureData.Element otherElement : this.elements) {
            if (otherElement == element || !otherElement.isMasked(state) || otherElement.material.transparency != TransparencyType.SOLID || otherElement.type != FurnitureData.ElementType.ELEMENT || FurnitureModelFactory.theSame(element, otherElement) && otherElement.hashCode() < element.hashCode() || !FurnitureModelFactory.fullyContained(otherElement, vertices)) continue;
            return null;
        }
        Vector2i dimensions = ClientModelUtils.getFaceDimensions(element, direction);
        int level = 1;
        if (this.atlas == DynamicAtlas.BAKED) {
            int i = (Integer)class_310.method_1551().field_1690.method_42563().method_41753();
            int panic = (double)this.atlas.getUsage() > 0.5 ? ((double)this.atlas.getUsage() > 0.75 ? 2 : 1) : 0;
            level = (int)Math.pow(2.0, Math.max(0, Math.min(i - panic, Config.getInstance().maxMipLevel)));
        }
        if ((quad = this.atlas.allocate((int)(Math.ceil((double)dimensions.x / (double)level) * (double)level), (int)(Math.ceil((double)dimensions.y / (double)level) * (double)level))).w() > 0 && quad.h() > 0) {
            int color;
            int y;
            int x;
            int[] baked;
            class_1011 pixels = this.atlas.method_4525();
            assert (pixels != null);
            boolean useBaked = true;
            int[] nArray = baked = this.inEditor ? null : element.bakedTextures.get(direction, state);
            if (baked == null || baked.length != dimensions.x * dimensions.y) {
                baked = new int[dimensions.x * dimensions.y];
                useBaked = false;
            }
            for (x = 0; x < dimensions.x; ++x) {
                for (y = 0; y < dimensions.y; ++y) {
                    if (!useBaked) {
                        color = MaterialSource.fromCube(element.material, direction, element.getCenter(), x, y, dimensions.x, dimensions.y);
                        int r = color >> 16 & 0xFF;
                        int g = color >> 8 & 0xFF;
                        int b = color & 0xFF;
                        int a = color >> 24 & 0xFF;
                        ElementRotation rotation = element.getRotation();
                        Vector3f pos = new Vector3f((Vector3ic)ClientModelUtils.to3D(element, direction, x, y));
                        ModelUtils.applyElementRotation(pos, rotation);
                        Vector3f normal = ModelUtils.getElementRotation(rotation).transform(direction.method_23955());
                        FurnitureData.LightMaterialEffect lightEffect = element.material.lightEffect;
                        float[] hsv = Utils.rgbToHsv((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
                        if (Math.abs(element.material.lightEffect.hue) >= 1.0f) {
                            hsv[0] = this.mod(element.material.lightEffect.hue * 1.8f, 360.0f);
                        }
                        hsv[1] = Math.max(0.0f, Math.min(1.0f, hsv[1] + element.material.lightEffect.saturation * 0.01f));
                        hsv[2] = Math.max(0.0f, Math.min(1.0f, hsv[2] + element.material.lightEffect.value * 0.01f));
                        float[] rgb = Utils.hsvToRgbRaw(hsv[0], hsv[1], hsv[2]);
                        r = (int)(rgb[0] * 255.0f);
                        g = (int)(rgb[1] * 255.0f);
                        b = (int)(rgb[2] * 255.0f);
                        float light = 1.0f;
                        float roundness = lightEffect.roundness / 75.0f;
                        if (roundness != 0.0f) {
                            light = FurnitureModelFactory.getLight(x, y, dimensions);
                            light = FurnitureModelFactory.quantize(x, y, light);
                            light = light * roundness + (1.0f - roundness * 0.5f);
                        }
                        light += lightEffect.brightness / 100.0f;
                        float ao = Math.min(1.0f, Math.max(0.0f, 1.0f - this.aos.get(state).sample(pos, normal) * 1.5f));
                        float emission = (float)element.emission / 15.0f;
                        float contrast = lightEffect.contrast / 100.0f;
                        r = (int)Math.max(0.0, Math.min(255.0, (double)(((float)(r - 128) * (1.0f + contrast) + 128.0f) * (light *= ao * (1.0f - emission) + emission))));
                        g = (int)Math.max(0.0, Math.min(255.0, (double)(((float)(g - 128) * (1.0f + contrast) + 128.0f) * light)));
                        b = (int)Math.max(0.0, Math.min(255.0, (double)(((float)(b - 128) * (1.0f + contrast) + 128.0f) * light)));
                        baked[x + y * dimensions.x] = color = a << 24 | r << 16 | g << 8 | b;
                    } else {
                        color = baked[x + y * dimensions.x];
                    }
                    pixels.method_4305(quad.x() + x, quad.y() + y, color);
                }
            }
            for (x = dimensions.x(); x < quad.w(); ++x) {
                for (y = 0; y < dimensions.y(); ++y) {
                    color = pixels.method_4315(quad.x() + x - 1, quad.y() + y);
                    pixels.method_4305(quad.x() + x, quad.y() + y, color);
                }
            }
            for (int y2 = dimensions.y(); y2 < quad.h(); ++y2) {
                for (int x2 = 0; x2 < quad.w(); ++x2) {
                    color = pixels.method_4315(quad.x() + x2, quad.y() + y2 - 1);
                    pixels.method_4305(quad.x() + x2, quad.y() + y2, color);
                }
            }
            this.atlas.setDirty();
            if (this.inEditor) {
                element.bakedTextures.put(direction, state, baked);
            }
        }
        float uvScale = 16.0f / (float)this.atlas.size;
        return new class_783(this.getCulledDirection(vertices), this.elementToIndex.get(element).intValue(), "0", new class_787(new float[]{(float)quad.x() * uvScale, (float)quad.y() * uvScale, (float)(quad.x() + dimensions.x()) * uvScale, (float)(quad.y() + dimensions.y()) * uvScale}, 0));
    }

    private class_2350 getCulledDirection(Vector3f[] vertices) {
        if (vertices[0].x() == 0.0f && vertices[1].x() == 0.0f && vertices[2].x() == 0.0f && vertices[3].x() == 0.0f) {
            return class_2350.field_11039;
        }
        if (vertices[0].x() == 1.0f && vertices[1].x() == 1.0f && vertices[2].x() == 1.0f && vertices[3].x() == 1.0f) {
            return class_2350.field_11034;
        }
        if (vertices[0].y() == 0.0f && vertices[1].y() == 0.0f && vertices[2].y() == 0.0f && vertices[3].y() == 0.0f) {
            return class_2350.field_11033;
        }
        if (vertices[0].y() == 1.0f && vertices[1].y() == 1.0f && vertices[2].y() == 1.0f && vertices[3].y() == 1.0f) {
            return class_2350.field_11036;
        }
        if (vertices[0].z() == 0.0f && vertices[1].z() == 0.0f && vertices[2].z() == 0.0f && vertices[3].z() == 0.0f) {
            return class_2350.field_11043;
        }
        if (vertices[0].z() == 1.0f && vertices[1].z() == 1.0f && vertices[2].z() == 1.0f && vertices[3].z() == 1.0f) {
            return class_2350.field_11035;
        }
        return null;
    }

    private static boolean theSame(FurnitureData.Element element, FurnitureData.Element otherElement) {
        return element.from.equals((Object)otherElement.from) && element.to.equals((Object)otherElement.to) && element.getRotation().equals(otherElement.getRotation());
    }

    private static boolean fullyContained(FurnitureData.Element otherElement, Vector3f[] vertices) {
        for (Vector3f vertex : vertices) {
            Vector3f localVertex = new Vector3f((Vector3fc)vertex);
            ModelUtils.applyInverseElementRotation(localVertex, otherElement.getRotation());
            if (otherElement.contains(localVertex.mul(16.0f))) continue;
            return false;
        }
        return true;
    }

    private boolean mightZFight(FurnitureData.Element element, Map<class_2350, class_783> faces, int state) {
        for (class_2350 direction : faces.keySet()) {
            float[] fs = ClientModelUtils.getShapeData(element);
            Vector3f[] vertices = ClientModelUtils.getVertices(element, direction, fs, null);
            for (FurnitureData.Element otherElement : this.elements) {
                if (otherElement == element || otherElement.getVolume() < element.getVolume() || !FurnitureModelFactory.hasFaces(otherElement)) continue;
                Vector3f[] localVerts = new Vector3f[vertices.length];
                for (int i = 0; i < vertices.length; ++i) {
                    Vector3f v = vertices[i];
                    Vector3f lv = new Vector3f((Vector3fc)v);
                    ModelUtils.applyInverseElementRotation(lv, otherElement.getRotation());
                    lv.mul(16.0f);
                    localVerts[i] = lv;
                }
                Map otherFaces = this.faces.get(state).getOrDefault(otherElement, Collections.emptyMap());
                float fromX = Math.min(localVerts[0].x, localVerts[2].x);
                float toX = Math.max(localVerts[0].x, localVerts[2].x);
                float fromY = Math.min(localVerts[0].y, localVerts[2].y);
                float toY = Math.max(localVerts[0].y, localVerts[2].y);
                float fromZ = Math.min(localVerts[0].z, localVerts[2].z);
                float toZ = Math.max(localVerts[0].z, localVerts[2].z);
                float m = 0.01f;
                if (Math.abs(fromX - toX) < m && fromY < otherElement.to.y - m && toY > otherElement.from.y + m && fromZ < otherElement.to.z - m && toZ > otherElement.from.z + m) {
                    if (otherFaces.containsKey(class_2350.field_11039) && Math.abs(fromX - otherElement.from.x) < m) {
                        return true;
                    }
                    if (otherFaces.containsKey(class_2350.field_11034) && Math.abs(toX - otherElement.to.x) < m) {
                        return true;
                    }
                }
                if (Math.abs(fromY - toY) < m && fromX < otherElement.to.x - m && toX > otherElement.from.x + m && fromZ < otherElement.to.z - m && toZ > otherElement.from.z + m) {
                    if (otherFaces.containsKey(class_2350.field_11033) && Math.abs(fromY - otherElement.from.y) < m) {
                        return true;
                    }
                    if (otherFaces.containsKey(class_2350.field_11036) && Math.abs(toY - otherElement.to.y) < m) {
                        return true;
                    }
                }
                if (!(Math.abs(fromZ - toZ) < m) || !(fromX < otherElement.to.x - m) || !(toX > otherElement.from.x + m) || !(fromY < otherElement.to.y - m) || !(toY > otherElement.from.y + m)) continue;
                if (otherFaces.containsKey(class_2350.field_11043) && Math.abs(fromZ - otherElement.from.z) < m) {
                    return true;
                }
                if (!otherFaces.containsKey(class_2350.field_11035) || !(Math.abs(toZ - otherElement.to.z) < m)) continue;
                return true;
            }
        }
        return false;
    }

    private static float getLight(int x, int y, Vector2i dimensions) {
        float rx = (float)x / ((float)dimensions.x - 1.0f) * 2.0f - 1.0f;
        float ry = (float)y / ((float)dimensions.y - 1.0f) * 2.0f - 1.0f;
        float r = 1.0f - Math.max(Math.abs(rx), Math.abs(ry)) * 0.95f;
        float dist = Math.max(0.0f, 1.0f - (float)Math.sqrt(rx * rx + ry * ry) / 1.42f);
        return (float)Math.sqrt(r * (1.0f - r) + dist * r);
    }

    private static float quantize(int x, int y, float light) {
        int levels = 8;
        int hash = x * 668265261 ^ y * -2048144789;
        hash ^= hash >>> 16;
        hash *= -2048144789;
        hash ^= hash >>> 13;
        hash *= -1028477387;
        hash ^= hash >>> 16;
        float n = (float)((long)hash & 0xFFFFFFFFL) / 4.2949673E9f;
        light = (float)Math.round(light * (float)levels + n) / (float)levels;
        return light;
    }

    private class_785 getElement(FurnitureData.Element element, int state) {
        Vector3f from = new Vector3f((Vector3fc)element.from);
        Vector3f to = new Vector3f((Vector3fc)element.to);
        Map<class_2350, class_783> faces = this.faces.get(state).getOrDefault(element, Collections.emptyMap());
        if (!this.inEditor && this.mightZFight(element, faces, state)) {
            ++this.zFightingCounter;
            float offset = 0.01f * (float)(this.zFightingCounter % 7);
            from.sub(offset, offset, offset);
            to.add(offset, offset, offset);
        }
        class_789 rotation = ClientModelUtils.toBlockElementRotation(element.getRotation());
        return new class_785(from, to, faces, rotation, true);
    }

    private Map<class_2350, class_783> getFaces(FurnitureData.Element element, int state) {
        if (element.type == FurnitureData.ElementType.SPRITE) {
            class_1059 atlas = class_310.method_1551().method_1554().method_24153(class_1723.field_21668);
            class_1058 sprite = atlas.method_4608(element.sprite.sprite);
            if (sprite.method_45851().method_45816().equals((Object)class_1047.method_4539())) {
                return Map.of();
            }
            return Map.of(class_2350.field_11043, this.getSpriteFace(element, true), class_2350.field_11035, this.getSpriteFace(element, false));
        }
        return EnumSet.allOf(class_2350.class).stream().map(dir -> Optional.ofNullable(this.getFace(element, (class_2350)dir, state)).map(face -> Map.entry(dir, face))).flatMap(Optional::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private class_783 getSpriteFace(FurnitureData.Element element, boolean front) {
        Vector3i size = element.getSize();
        return new class_783(null, this.elementToIndex.get(element).intValue(), element.sprite.sprite.toString(), new class_787(new float[]{front ? 0.0f : (float)size.x / element.sprite.size, 0.0f, front ? (float)size.x / element.sprite.size : 0.0f, (float)size.y / element.sprite.size}, element.sprite.rotation));
    }

    private class_793 getModel(TransparencyType type, int state) {
        return new class_793(null, this.elements.stream().filter(FurnitureModelFactory::hasFaces).filter(e -> e.isMasked(state)).filter(e -> type == null || this.getTransparencyType((FurnitureData.Element)e) == type).map(e -> this.getElement((FurnitureData.Element)e, state)).toList(), this.textures, Boolean.valueOf(false), class_793.class_4751.field_21859, this.getTransforms(), List.of());
    }

    private Map<Integer, class_793> getModels(TransparencyType type) {
        HashMap<Integer, class_793> models = new HashMap<Integer, class_793>();
        for (Integer state : this.data.getUniqueSolidStates()) {
            models.put(state, this.getModel(type, state));
        }
        return models;
    }

    private void splitSprites() {
        int index = 0;
        for (FurnitureData.Element element : this.data.elements) {
            if (element.type == FurnitureData.ElementType.SPRITE && element.sprite.tiled) {
                Vector3i size = element.getSize();
                int px = Math.round(16.0f * element.sprite.size);
                for (int x = 0; x < size.x; x += px) {
                    for (int y = 0; y < size.y; y += px) {
                        FurnitureData.Element tiledElement = new FurnitureData.Element(element);
                        float w = Math.min(size.x - x, px);
                        float h = Math.min(size.y - y, px);
                        tiledElement.from.add((float)x, (float)y, 0.0f);
                        tiledElement.to = new Vector3f((Vector3fc)tiledElement.from).add(w, h, 0.0f);
                        Vector3f east = element.getGlobalDirectionNormal(class_2350.field_11034);
                        Vector3f up = element.getGlobalDirectionNormal(class_2350.field_11033);
                        float hx = (float)x + w / 2.0f - (float)size.x / 2.0f;
                        float hy = (float)y + h / 2.0f - (float)size.y / 2.0f;
                        Vector3f offset = new Vector3f(east.x * hx + up.x * hy, east.y * hx + up.y * hy, east.z * hx + up.z * hy);
                        offset.add((Vector3fc)element.getCenter().sub((Vector3fc)tiledElement.getCenter()));
                        tiledElement.from.add((Vector3fc)offset);
                        tiledElement.to.add((Vector3fc)offset);
                        this.elements.add(tiledElement);
                        this.elementToIndex.put(tiledElement, index);
                    }
                }
            } else if (element.type != FurnitureData.ElementType.SPRITE || !element.sprite.item) {
                this.elements.add(element);
                this.elementToIndex.put(element, index);
            }
            this.indexToElement.put(index, element);
            ++index;
        }
    }

    private TransparencyType getTransparencyType(FurnitureData.Element e) {
        return e.type == FurnitureData.ElementType.SPRITE ? TransparencyManager.fromSprite(e) : e.material.transparency;
    }

    private static boolean hasFaces(FurnitureData.Element e) {
        return e.type == FurnitureData.ElementType.ELEMENT || e.type == FurnitureData.ElementType.SPRITE;
    }

    private class_809 getTransforms() {
        float scale = (float)(1.0 / (Math.max(16.0, this.data.getSize()) / 16.0));
        float sqrtScale = (float)Math.sqrt(scale);
        Vector3f o = new Vector3f(0.5f - (float)this.data.size.x / 2.0f, 0.5f - (float)this.data.size.y / 2.0f, 0.5f - (float)this.data.size.z / 2.0f);
        return new class_809(this.getItemTransform(o, 75.0f, 225.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f * sqrtScale), this.getItemTransform(o, 75.0f, 45.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f * sqrtScale), this.getItemTransform(o, 0.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f * sqrtScale), this.getItemTransform(o, 0.0f, 45.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f * sqrtScale), this.getItemTransform(o, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f), this.getItemTransform(o, 30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f * scale), this.getItemTransform(o, 0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f * sqrtScale), this.getItemTransform(o, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f * scale));
    }

    private class_804 getItemTransform(Vector3f offset, float rotX, float rotY, float rotZ, float x, float y, float z, float scale) {
        Vector3f offsetScaled = new Vector3f((Vector3fc)offset).mul(scale);
        Quaternionf rotation = new Quaternionf().rotateXYZ((float)Math.toRadians(rotX), (float)Math.toRadians(rotY), (float)Math.toRadians(rotZ));
        offsetScaled.rotate((Quaternionfc)rotation);
        return new class_804(new Vector3f(rotX, rotY, rotZ), offsetScaled.add(x / 16.0f, y / 16.0f, z / 16.0f), new Vector3f(scale));
    }

    public static CompositeBlockModel getModel(FurnitureData data, DynamicAtlas atlas) {
        FurnitureModelFactory factory = new FurnitureModelFactory(data, atlas);
        CompositeBlockModel composite = new CompositeBlockModel(factory.indexToElement);
        composite.addModel(class_1921.method_23577(), factory.getModels(TransparencyType.SOLID));
        composite.addModel(class_1921.method_23581(), factory.getModels(TransparencyType.CUTOUT));
        composite.addModel(class_1921.method_23579(), factory.getModels(TransparencyType.CUTOUT_MIPPED));
        composite.addModel(class_1921.method_23583(), factory.getModels(TransparencyType.TRANSLUCENT));
        return composite;
    }
}

