/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.TransparencyType;
import net.conczin.immersive_furniture.mixin.client.SpriteContentsAccessor;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_5253;
import net.minecraft.class_7764;
import net.minecraft.class_7923;

public class TransparencyManager {
    public static final TransparencyManager INSTANCE = new TransparencyManager();
    private final Map<class_2960, TransparencyType> transparencyCache = new ConcurrentHashMap<class_2960, TransparencyType>();

    public TransparencyType getTransparencyType(class_7764 s) {
        return this.transparencyCache.computeIfAbsent(s.method_45816(), location -> this.compute(s));
    }

    public boolean isCornerTransparent(class_7764 s) {
        class_1011 image = ((SpriteContentsAccessor)s).getMipLevelData()[0];
        return class_5253.class_8045.method_48342((int)image.method_4315(0, 0)) < 128 && class_5253.class_8045.method_48342((int)image.method_4315(image.method_4307() - 1, 0)) < 128 && class_5253.class_8045.method_48342((int)image.method_4315(image.method_4307() - 1, image.method_4323() - 1)) < 128 && class_5253.class_8045.method_48342((int)image.method_4315(0, image.method_4323() - 1)) < 128;
    }

    private TransparencyType compute(class_7764 s) {
        class_1011 image = ((SpriteContentsAccessor)s).getMipLevelData()[0];
        boolean hasTransparency = false;
        for (int y = 0; y < image.method_4323(); ++y) {
            for (int x = 0; x < image.method_4307(); ++x) {
                int alpha = class_5253.class_8045.method_48342((int)image.method_4315(x, y));
                if (alpha == 0) {
                    hasTransparency = true;
                    continue;
                }
                if (alpha >= 255) continue;
                return TransparencyType.TRANSLUCENT;
            }
        }
        return hasTransparency ? TransparencyType.CUTOUT_MIPPED : TransparencyType.SOLID;
    }

    public static void prepare(FurnitureData data) {
        for (FurnitureData.Element element : data.elements) {
            if (element.type != FurnitureData.ElementType.ELEMENT) continue;
            class_2680 state = ((class_2248)class_7923.field_41175.method_10223(element.material.source)).method_9564();
            class_1921 renderType = class_4696.method_23679((class_2680)state);
            element.material.transparency = TransparencyManager.fromRenderType(renderType);
        }
    }

    public static TransparencyType fromRenderType(class_1921 renderType) {
        if (renderType == class_1921.method_23583()) {
            return TransparencyType.TRANSLUCENT;
        }
        if (renderType == class_1921.method_23579()) {
            return TransparencyType.CUTOUT_MIPPED;
        }
        if (renderType == class_1921.method_23581()) {
            return TransparencyType.CUTOUT;
        }
        return TransparencyType.SOLID;
    }

    public static TransparencyType fromSprite(FurnitureData.Element element) {
        class_1059 atlas = class_310.method_1551().method_1554().method_24153(class_1723.field_21668);
        class_1058 sprite = atlas.method_4608(element.sprite.sprite);
        return INSTANCE.getTransparencyType(sprite.method_45851());
    }

    public static void heySodiumImInUse(FurnitureData data) {
        for (FurnitureData.Element element : data.elements) {
            if (element.type != FurnitureData.ElementType.SPRITE) continue;
            class_1059 atlas = class_310.method_1551().method_1554().method_24153(class_1723.field_21668);
            atlas.method_4608(element.sprite.sprite);
        }
    }
}

