/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.fabric;

import immersive_melodies.Common;
import immersive_melodies.ItemGroups;
import immersive_melodies.Items;
import immersive_melodies.Sounds;
import immersive_melodies.fabric.resources.FabricMelody;
import immersive_melodies.network.ImmersivePayload;
import immersive_melodies.network.Network;
import immersive_melodies.resources.ServerMelodyManager;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_7923;

public final class CommonFabric
implements ModInitializer {
    FabricRegistrar fabricRegistrar = new FabricRegistrar();

    private static <T> void registerHelper(class_2378<T> register, Consumer<Common.RegisterHelper<T>> consumer) {
        consumer.accept((name, value) -> class_2378.method_10230((class_2378)register, (class_2960)name, (Object)value));
    }

    public void onInitialize() {
        CommonFabric.registerHelper(class_7923.field_41178, Items::registerItems);
        CommonFabric.registerHelper(class_7923.field_41172, Sounds::registerSounds);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new FabricMelody());
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            ServerMelodyManager.server = server;
        });
        class_1761 group = FabricItemGroup.builder().method_47321(ItemGroups.getDisplayName()).method_47320(ItemGroups::getIcon).method_47317((enabledFeatures, entries) -> entries.method_45423(Items.getSortedItems())).method_47324();
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)Common.locate("group"), (Object)group);
        Network.register(this.fabricRegistrar);
        Network.registerSender((payload, player) -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            payload.encode(buf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.fabricRegistrar.getMessageIdentifier(payload), (class_2540)buf);
        });
        Network.registerClientSender(payload -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            payload.encode(buf);
            ClientPlayNetworking.send((class_2960)this.fabricRegistrar.getMessageIdentifier(payload), (class_2540)buf);
        });
    }

    public static class FabricRegistrar
    implements Network.Registrar {
        private final Map<Class<?>, class_2960> identifiers = new HashMap();
        private int id = 0;

        private <T> class_2960 createMessageIdentifier(Class<T> msg) {
            return Common.locate(msg.getSimpleName().toLowerCase(Locale.ROOT).substring(0, 8) + this.id++);
        }

        private class_2960 getMessageIdentifier(ImmersivePayload msg) {
            return Objects.requireNonNull(this.identifiers.get(msg.getClass()), "Used unregistered message!");
        }

        @Override
        public <T extends ImmersivePayload> void register(Class<T> msg, Function<class_2540, T> constructor) {
            class_2960 identifier = this.createMessageIdentifier(msg);
            this.identifiers.put(msg, identifier);
            ServerPlayNetworking.registerGlobalReceiver((class_2960)identifier, (server, player, handler, buffer, responder) -> {
                ImmersivePayload m = (ImmersivePayload)constructor.apply(buffer);
                server.execute(() -> m.handle((class_1657)player));
            });
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ClientProxy.register(identifier, constructor);
            }
        }
    }

    private static final class ClientProxy {
        private ClientProxy() {
        }

        public static <T extends ImmersivePayload> void register(class_2960 id, Function<class_2540, T> constructor) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)id, (client, ignore1, buffer, ignore2) -> {
                ImmersivePayload m = (ImmersivePayload)constructor.apply(buffer);
                client.execute(() -> m.handle((class_1657)client.field_1724));
            });
        }
    }
}

