/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.CreateLang;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_5348;
import net.minecraft.class_6328;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@class_6328
public abstract class CreateRecipeCategory<T extends class_1860<?>>
implements IRecipeCategory<T> {
    private static final IDrawable BASIC_SLOT = CreateRecipeCategory.asDrawable(AllGuiTextures.JEI_SLOT);
    private static final IDrawable CHANCE_SLOT = CreateRecipeCategory.asDrawable(AllGuiTextures.JEI_CHANCE_SLOT);
    protected final RecipeType<T> type;
    protected final class_2561 title;
    protected final IDrawable background;
    protected final IDrawable icon;
    private final Supplier<List<T>> recipes;
    private final List<Supplier<? extends class_1799>> catalysts;

    public CreateRecipeCategory(Info<T> info) {
        this.type = info.recipeType();
        this.title = info.title();
        this.background = info.background();
        this.icon = info.icon();
        this.recipes = info.recipes();
        this.catalysts = info.catalysts();
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(this.type, this.recipes.get());
    }

    public void registerCatalysts(IRecipeCatalystRegistration registration) {
        this.catalysts.forEach(s -> registration.addRecipeCatalyst((class_1799)s.get(), new RecipeType[]{this.type}));
    }

    public static IDrawable getRenderedSlot() {
        return BASIC_SLOT;
    }

    public static IDrawable getRenderedSlot(ProcessingOutput output) {
        return CreateRecipeCategory.getRenderedSlot(output.getChance());
    }

    public static IDrawable getRenderedSlot(float chance) {
        if (chance == 1.0f) {
            return BASIC_SLOT;
        }
        return CHANCE_SLOT;
    }

    public static class_1799 getResultItem(class_1860<?> recipe) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return class_1799.field_8037;
        }
        return recipe.method_8110(level.method_30349());
    }

    public static IRecipeSlotRichTooltipCallback addStochasticTooltip(ProcessingOutput output) {
        return (view, tooltip) -> {
            float chance = output.getChance();
            if (chance != 1.0f) {
                tooltip.add((class_5348)CreateLang.translateDirect("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).method_27692(class_124.field_1065));
            }
        };
    }

    public static IRecipeSlotBuilder addFluidSlot(IRecipeLayoutBuilder builder, int x, int y, FluidIngredient ingredient) {
        return (IRecipeSlotBuilder)CreateRecipeCategory.addFluidSlot(builder, x, y, RecipeIngredientRole.INPUT).addIngredients((IIngredientType)FabricTypes.FLUID_STACK, CreateRecipeCategory.toJei(ingredient.getMatchingFluidStacks()));
    }

    public static IRecipeSlotBuilder addFluidSlot(IRecipeLayoutBuilder builder, int x, int y, FluidStack stack) {
        return (IRecipeSlotBuilder)CreateRecipeCategory.addFluidSlot(builder, x, y, RecipeIngredientRole.OUTPUT).addIngredient((IIngredientType)FabricTypes.FLUID_STACK, (Object)CreateRecipeCategory.toJei(stack));
    }

    public static IRecipeSlotBuilder addFluidSlot(IRecipeLayoutBuilder builder, int x, int y, RecipeIngredientRole role) {
        return builder.addSlot(role, x, y).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).setFluidRenderer(1L, false, 16, 16);
    }

    public static FluidStack fromJei(IJeiFluidIngredient jei) {
        return new FluidStack(jei.getFluid(), jei.getAmount(), (class_2487)jei.getTag().orElse(null));
    }

    public static IJeiFluidIngredient toJei(final FluidStack stack) {
        return new IJeiFluidIngredient(){

            public class_3611 getFluid() {
                return stack.getFluid();
            }

            public long getAmount() {
                return stack.getAmount();
            }

            public Optional<class_2487> getTag() {
                return Optional.ofNullable(stack.getTag());
            }
        };
    }

    public static List<FluidStack> fromJei(List<IJeiFluidIngredient> stacks) {
        return stacks.stream().map(CreateRecipeCategory::fromJei).toList();
    }

    public static List<IJeiFluidIngredient> toJei(Collection<FluidStack> stacks) {
        return stacks.stream().map(CreateRecipeCategory::toJei).toList();
    }

    protected static IDrawable asDrawable(final AllGuiTextures texture) {
        return new IDrawable(){

            public int getWidth() {
                return texture.getWidth();
            }

            public int getHeight() {
                return texture.getHeight();
            }

            public void draw(class_332 graphics, int xOffset, int yOffset) {
                texture.render(graphics, xOffset, yOffset);
            }
        };
    }

    public record Info<T extends class_1860<?>>(RecipeType<T> recipeType, class_2561 title, IDrawable background, IDrawable icon, Supplier<List<T>> recipes, List<Supplier<? extends class_1799>> catalysts) {
    }

    public static interface Factory<T extends class_1860<?>> {
        public CreateRecipeCategory<T> create(Info<T> var1);
    }
}

