/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.pojav;

import com.simibubi.create.compat.pojav.PojavWarningScreen;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojavChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojavChecker.class);
    private static final Pattern KNOWN_ANDROID_PATH = Pattern.compile("/data/user/[0-9]+/net\\.kdt\\.pojavlaunch");
    public static final boolean IS_PRESENT = (Boolean)class_156.method_656(() -> {
        String workingDirectory;
        if (System.getenv("POJAV_RENDERER") != null) {
            LOGGER.warn("[Create]: Detected presence of environment variable POJAV_LAUNCHER, which seems to indicate we are running on Android");
            return true;
        }
        String librarySearchPaths = System.getProperty("java.library.path", null);
        if (librarySearchPaths != null) {
            for (String path : librarySearchPaths.split(":")) {
                if (!PojavChecker.isKnownAndroidPathFragment(path)) continue;
                LOGGER.warn("[Create]: Found a library search path which seems to be hosted in an Android filesystem: {}", (Object)path);
                return true;
            }
        }
        if ((workingDirectory = System.getProperty("user.home", null)) != null && PojavChecker.isKnownAndroidPathFragment(workingDirectory)) {
            LOGGER.warn("[Create]: Working directory seems to be hosted in an Android filesystem: {}", (Object)workingDirectory);
            return true;
        }
        return false;
    });
    private static boolean screenShown = false;

    public static void init() {
        if (!IS_PRESENT) {
            return;
        }
        ScreenEvents.AFTER_INIT.register(PojavChecker::onScreenInit);
    }

    public static void onScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (!screenShown && screen instanceof class_442) {
            class_442 titleScreen = (class_442)screen;
            class_310.method_1551().method_1507((class_437)new PojavWarningScreen(titleScreen));
            screenShown = true;
        }
    }

    private static boolean isKnownAndroidPathFragment(String path) {
        return KNOWN_ANDROID_PATH.matcher(path).matches();
    }
}

