/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageWrapper;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionRelocationPacket;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.minecart.MinecartSim2020;
import com.simibubi.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.minecart.capability.MinecartController;
import com.simibubi.create.content.contraptions.mounted.CartAssemblerBlockEntity;
import com.simibubi.create.content.contraptions.mounted.MountedContraption;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import io.github.fabricators_of_create.porting_lib.util.MinecartAndRailUtil;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class OrientedContraptionEntity
extends AbstractContraptionEntity {
    private static final class_1856 FUEL_ITEMS = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8713, class_1802.field_8665});
    private static final class_2940<Optional<UUID>> COUPLING = class_2945.method_12791(OrientedContraptionEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<class_2350> INITIAL_ORIENTATION = class_2945.method_12791(OrientedContraptionEntity.class, (class_2941)class_2943.field_13321);
    protected class_243 motionBeforeStall = class_243.field_1353;
    protected boolean forceAngle;
    private boolean isSerializingFurnaceCart = false;
    private boolean attachedExtraInventories = false;
    private boolean manuallyPlaced;
    public float prevYaw;
    public float yaw;
    public float targetYaw;
    public float prevPitch;
    public float pitch;
    public int nonDamageTicks = 10;

    public OrientedContraptionEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public static OrientedContraptionEntity create(class_1937 world, Contraption contraption, class_2350 initialOrientation) {
        OrientedContraptionEntity entity = new OrientedContraptionEntity((class_1299)AllEntityTypes.ORIENTED_CONTRAPTION.get(), world);
        entity.setContraption(contraption);
        entity.setInitialOrientation(initialOrientation);
        entity.startAtInitialYaw();
        return entity;
    }

    public static OrientedContraptionEntity createAtYaw(class_1937 world, Contraption contraption, class_2350 initialOrientation, float initialYaw) {
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        entity.startAtYaw(initialYaw);
        entity.manuallyPlaced = true;
        return entity;
    }

    public void setInitialOrientation(class_2350 direction) {
        this.field_6011.method_12778(INITIAL_ORIENTATION, (Object)direction);
    }

    public class_2350 getInitialOrientation() {
        return (class_2350)this.field_6011.method_12789(INITIAL_ORIENTATION);
    }

    @Override
    public float getYawOffset() {
        return this.getInitialYaw();
    }

    public float getInitialYaw() {
        return (this.isInitialOrientationPresent() ? (class_2350)this.field_6011.method_12789(INITIAL_ORIENTATION) : class_2350.field_11035).method_10144();
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COUPLING, Optional.empty());
        this.field_6011.method_12784(INITIAL_ORIENTATION, (Object)class_2350.field_11036);
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        AbstractContraptionEntity.ContraptionRotationState crs = new AbstractContraptionEntity.ContraptionRotationState();
        float yawOffset = this.getYawOffset();
        crs.zRotation = this.pitch;
        crs.yRotation = -this.yaw + yawOffset;
        if (this.pitch != 0.0f && this.yaw != 0.0f) {
            crs.secondYRotation = -this.yaw;
            crs.yRotation = yawOffset;
        }
        return crs;
    }

    @Override
    public void method_5650(class_1297.class_5529 p_146834_) {
        super.method_5650(p_146834_);
    }

    public void method_5848() {
        if (!this.method_37908().field_9236 && this.method_5805()) {
            this.disassemble();
        }
        super.method_5848();
    }

    @Override
    protected void readAdditional(class_2487 compound, boolean spawnPacket) {
        class_2499 vecNBT;
        super.readAdditional(compound, spawnPacket);
        if (compound.method_10545("InitialOrientation")) {
            this.setInitialOrientation((class_2350)NBTHelper.readEnum((class_2487)compound, (String)"InitialOrientation", class_2350.class));
        }
        this.yaw = compound.method_10583("Yaw");
        this.pitch = compound.method_10583("Pitch");
        this.manuallyPlaced = compound.method_10577("Placed");
        if (compound.method_10545("ForceYaw")) {
            this.startAtYaw(compound.method_10583("ForceYaw"));
        }
        if (!(vecNBT = compound.method_10554("CachedMotion", 6)).isEmpty()) {
            this.motionBeforeStall = new class_243(vecNBT.method_10611(0), vecNBT.method_10611(1), vecNBT.method_10611(2));
            if (!this.motionBeforeStall.equals((Object)class_243.field_1353)) {
                this.prevYaw = this.yaw += OrientedContraptionEntity.yawFromVector(this.motionBeforeStall);
                this.targetYaw = this.yaw;
            }
            this.method_18799(class_243.field_1353);
        }
        this.setCouplingId(compound.method_10545("OnCoupling") ? compound.method_25926("OnCoupling") : null);
    }

    @Override
    protected void writeAdditional(class_2487 compound, boolean spawnPacket) {
        class_2350 optional;
        super.writeAdditional(compound, spawnPacket);
        if (this.motionBeforeStall != null) {
            compound.method_10566("CachedMotion", (class_2520)this.method_5846(new double[]{this.motionBeforeStall.field_1352, this.motionBeforeStall.field_1351, this.motionBeforeStall.field_1350}));
        }
        if ((optional = (class_2350)this.field_6011.method_12789(INITIAL_ORIENTATION)).method_10166().method_10179()) {
            NBTHelper.writeEnum((class_2487)compound, (String)"InitialOrientation", (Enum)optional);
        }
        if (this.forceAngle) {
            compound.method_10548("ForceYaw", this.yaw);
            this.forceAngle = false;
        }
        compound.method_10556("Placed", this.manuallyPlaced);
        compound.method_10548("Yaw", this.yaw);
        compound.method_10548("Pitch", this.pitch);
        if (this.getCouplingId() != null) {
            compound.method_25927("OnCoupling", this.getCouplingId());
        }
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (INITIAL_ORIENTATION.equals(key) && this.isInitialOrientationPresent() && !this.manuallyPlaced) {
            this.startAtInitialYaw();
        }
    }

    public boolean isInitialOrientationPresent() {
        return ((class_2350)this.field_6011.method_12789(INITIAL_ORIENTATION)).method_10166().method_10179();
    }

    public void startAtInitialYaw() {
        this.startAtYaw(this.getInitialYaw());
    }

    public void startAtYaw(float yaw) {
        this.yaw = this.prevYaw = yaw;
        this.targetYaw = this.prevYaw;
        this.forceAngle = true;
    }

    @Override
    public class_243 applyRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate((class_243)localPos, (double)this.getInitialYaw(), (class_2350.class_2351)class_2350.class_2351.field_11052);
        localPos = VecHelper.rotate((class_243)localPos, (double)this.method_5695(partialTicks), (class_2350.class_2351)class_2350.class_2351.field_11051);
        localPos = VecHelper.rotate((class_243)localPos, (double)this.method_5705(partialTicks), (class_2350.class_2351)class_2350.class_2351.field_11052);
        return localPos;
    }

    @Override
    public class_243 reverseRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate((class_243)localPos, (double)(-this.method_5705(partialTicks)), (class_2350.class_2351)class_2350.class_2351.field_11052);
        localPos = VecHelper.rotate((class_243)localPos, (double)(-this.method_5695(partialTicks)), (class_2350.class_2351)class_2350.class_2351.field_11051);
        localPos = VecHelper.rotate((class_243)localPos, (double)(-this.getInitialYaw()), (class_2350.class_2351)class_2350.class_2351.field_11052);
        return localPos;
    }

    public float method_5705(float partialTicks) {
        return -(partialTicks == 1.0f ? this.yaw : AngleHelper.angleLerp((double)partialTicks, (double)this.prevYaw, (double)this.yaw));
    }

    public float method_5695(float partialTicks) {
        return partialTicks == 1.0f ? this.pitch : AngleHelper.angleLerp((double)partialTicks, (double)this.prevPitch, (double)this.pitch);
    }

    @Override
    protected void tickContraption() {
        boolean rotating;
        class_1297 e;
        if (this.nonDamageTicks > 0) {
            --this.nonDamageTicks;
        }
        if ((e = this.method_5854()) == null) {
            return;
        }
        boolean rotationLock = false;
        boolean pauseWhileRotating = false;
        boolean wasStalled = this.isStalled();
        Contraption contraption = this.contraption;
        if (contraption instanceof MountedContraption) {
            MountedContraption mountedContraption = (MountedContraption)contraption;
            rotationLock = mountedContraption.rotationMode == CartAssemblerBlockEntity.CartMovementMode.ROTATION_LOCKED;
            pauseWhileRotating = mountedContraption.rotationMode == CartAssemblerBlockEntity.CartMovementMode.ROTATE_PAUSED;
        }
        class_1297 riding = e;
        while (riding.method_5854() != null && !(this.contraption instanceof StabilizedContraption)) {
            riding = riding.method_5854();
        }
        boolean isOnCoupling = false;
        UUID couplingId = this.getCouplingId();
        boolean bl = isOnCoupling = couplingId != null && riding instanceof class_1688;
        if (!this.attachedExtraInventories) {
            this.attachInventoriesFromRidingCarts(riding, isOnCoupling, couplingId);
            this.attachedExtraInventories = true;
        }
        if (!(rotating = this.updateOrientation(rotationLock, wasStalled, riding, isOnCoupling)) || !pauseWhileRotating) {
            this.tickActors();
        }
        boolean isStalled = this.isStalled();
        MinecartController capability = null;
        if (riding instanceof class_1688) {
            class_1688 minecart = (class_1688)riding;
            capability = minecart.create$getController();
        }
        if (capability != null) {
            if (!this.method_37908().method_8608()) {
                capability.setStalledExternally(isStalled);
            }
        } else {
            if (isStalled) {
                if (!wasStalled) {
                    this.motionBeforeStall = riding.method_18798();
                }
                riding.method_18800(0.0, 0.0, 0.0);
            }
            if (wasStalled && !isStalled) {
                riding.method_18799(this.motionBeforeStall);
                this.motionBeforeStall = class_243.field_1353;
            }
        }
        if (this.method_37908().field_9236) {
            return;
        }
        if (!this.isStalled()) {
            if (isOnCoupling) {
                Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
                if (coupledCarts == null) {
                    return;
                }
                coupledCarts.map(MinecartController::cart).forEach(this::powerFurnaceCartWithFuelFromStorage);
                return;
            }
            this.powerFurnaceCartWithFuelFromStorage(riding);
        }
    }

    protected boolean updateOrientation(boolean rotationLock, boolean wasStalled, class_1297 riding, boolean isOnCoupling) {
        if (isOnCoupling) {
            Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
            if (coupledCarts == null) {
                return false;
            }
            class_243 positionVec = ((MinecartController)coupledCarts.getFirst()).cart().method_19538();
            class_243 coupledVec = ((MinecartController)coupledCarts.getSecond()).cart().method_19538();
            double diffX = positionVec.field_1352 - coupledVec.field_1352;
            double diffY = positionVec.field_1351 - coupledVec.field_1351;
            double diffZ = positionVec.field_1350 - coupledVec.field_1350;
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            this.yaw = (float)(class_3532.method_15349((double)diffZ, (double)diffX) * 180.0 / Math.PI);
            this.pitch = (float)(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)) * 180.0 / Math.PI);
            if (this.getCouplingId().equals(riding.method_5667())) {
                this.pitch *= -1.0f;
                this.yaw += 180.0f;
            }
            return false;
        }
        Contraption positionVec = this.contraption;
        if (positionVec instanceof StabilizedContraption) {
            StabilizedContraption stabilized = (StabilizedContraption)positionVec;
            if (!(riding instanceof OrientedContraptionEntity)) {
                return false;
            }
            OrientedContraptionEntity parent = (OrientedContraptionEntity)riding;
            class_2350 facing = stabilized.getFacing();
            if (facing.method_10166().method_10178()) {
                return false;
            }
            this.prevYaw = this.yaw;
            this.yaw = AngleHelper.wrapAngle180((float)(this.getInitialYaw() - parent.getInitialYaw())) - parent.method_5705(1.0f);
            return false;
        }
        this.prevYaw = this.yaw;
        if (wasStalled) {
            return false;
        }
        boolean rotating = false;
        class_243 movementVector = riding.method_18798();
        class_243 locationDiff = riding.method_19538().method_1023(riding.field_6014, riding.field_6036, riding.field_5969);
        if (!(riding instanceof class_1688)) {
            movementVector = locationDiff;
        }
        class_243 motion = movementVector.method_1029();
        if (!rotationLock) {
            if (riding instanceof class_1688) {
                class_1688 minecartEntity = (class_1688)riding;
                class_2338 railPosition = minecartEntity.getCurrentRailPos();
                class_2680 blockState = this.method_37908().method_8320(railPosition);
                class_2248 class_22482 = blockState.method_26204();
                if (class_22482 instanceof class_2241) {
                    class_2241 abstractRailBlock = (class_2241)class_22482;
                    class_2768 railDirection = MinecartAndRailUtil.getDirectionOfRail((class_2680)blockState, (class_1922)this.method_37908(), (class_2338)railPosition, (class_2241)abstractRailBlock);
                    motion = VecHelper.project((class_243)motion, (class_243)MinecartSim2020.getRailVec(railDirection));
                }
            }
            if (motion.method_1033() > 0.0) {
                this.targetYaw = OrientedContraptionEntity.yawFromVector(motion);
                if (this.targetYaw < 0.0f) {
                    this.targetYaw += 360.0f;
                }
                if (this.yaw < 0.0f) {
                    this.yaw += 360.0f;
                }
            }
            this.prevYaw = this.yaw;
            float maxApproachSpeed = (float)(motion.method_1033() * 12.0 / Math.max(1.0, this.method_5829().method_17939() / 6.0));
            float yawHint = AngleHelper.getShortestAngleDiff((double)this.yaw, (double)OrientedContraptionEntity.yawFromVector(locationDiff));
            float approach = AngleHelper.getShortestAngleDiff((double)this.yaw, (double)this.targetYaw, (float)yawHint);
            approach = class_3532.method_15363((float)approach, (float)(-maxApproachSpeed), (float)maxApproachSpeed);
            this.yaw += approach;
            if (Math.abs(AngleHelper.getShortestAngleDiff((double)this.yaw, (double)this.targetYaw)) < 1.0f) {
                this.yaw = this.targetYaw;
            } else {
                rotating = true;
            }
        }
        return rotating;
    }

    protected void powerFurnaceCartWithFuelFromStorage(class_1297 riding) {
        class_1799 coal;
        MountedItemStorageWrapper fuelItems;
        int fuel;
        if (!(riding instanceof class_1696)) {
            return;
        }
        class_1696 furnaceCart = (class_1696)riding;
        this.isSerializingFurnaceCart = true;
        class_2487 nbt = NBTSerializer.serializeNBTCompound((Object)furnaceCart);
        this.isSerializingFurnaceCart = false;
        int fuelBefore = fuel = nbt.method_10550("Fuel");
        double pushX = nbt.method_10574("PushX");
        double pushZ = nbt.method_10574("PushZ");
        int i = class_3532.method_15357((double)furnaceCart.method_23317());
        int j = class_3532.method_15357((double)furnaceCart.method_23318());
        int k = class_3532.method_15357((double)furnaceCart.method_23321());
        if (furnaceCart.method_37908().method_8320(new class_2338(i, j - 1, k)).method_26164(class_3481.field_15463)) {
            --j;
        }
        class_2338 blockpos = new class_2338(i, j, k);
        class_2680 blockstate = this.method_37908().method_8320(blockpos);
        if (blockstate.method_26164(class_3481.field_15463) && fuel > 1) {
            riding.method_18799(riding.method_18798().method_1029().method_1021(1.0));
        }
        if (fuel < 5 && this.contraption != null && (fuelItems = this.contraption.getStorage().getFuelItems()) != null && !(coal = ItemHelper.extract((Storage<ItemVariant>)fuelItems, (Predicate<class_1799>)FUEL_ITEMS, 1, false)).method_7960()) {
            fuel += 3600;
        }
        if (fuel != fuelBefore || pushX != 0.0 || pushZ != 0.0) {
            nbt.method_10569("Fuel", fuel);
            nbt.method_10549("PushX", 0.0);
            nbt.method_10549("PushZ", 0.0);
            NBTSerializer.deserializeNBT((Object)furnaceCart, (class_2520)nbt);
        }
    }

    @Nullable
    public Couple<MinecartController> getCoupledCartsIfPresent() {
        UUID couplingId = this.getCouplingId();
        if (couplingId == null) {
            return null;
        }
        MinecartController controller = CapabilityMinecartController.getIfPresent(this.method_37908(), couplingId);
        if (controller == null || !controller.isPresent()) {
            return null;
        }
        UUID coupledCart = controller.getCoupledCart(true);
        MinecartController coupledController = CapabilityMinecartController.getIfPresent(this.method_37908(), coupledCart);
        if (coupledController == null || !coupledController.isPresent()) {
            return null;
        }
        return Couple.create((Object)controller, (Object)coupledController);
    }

    protected void attachInventoriesFromRidingCarts(class_1297 riding, boolean isOnCoupling, UUID couplingId) {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof MountedContraption)) {
            return;
        }
        MountedContraption mc = (MountedContraption)contraption;
        if (!isOnCoupling) {
            mc.addExtraInventories(riding);
            return;
        }
        Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
        if (coupledCarts == null) {
            return;
        }
        coupledCarts.map(MinecartController::cart).forEach(mc::addExtraInventories);
    }

    @Override
    public class_2487 method_5647(class_2487 nbt) {
        return this.isSerializingFurnaceCart ? nbt : super.method_5647(nbt);
    }

    @Nullable
    public UUID getCouplingId() {
        Optional uuid = (Optional)this.field_6011.method_12789(COUPLING);
        return uuid == null ? null : (uuid.isPresent() ? (UUID)uuid.get() : null);
    }

    public void setCouplingId(UUID id) {
        this.field_6011.method_12778(COUPLING, Optional.ofNullable(id));
    }

    @Override
    public class_243 getAnchorVec() {
        class_243 anchorVec = super.getAnchorVec();
        return anchorVec.method_1023(0.5, 0.0, 0.5);
    }

    @Override
    public class_243 getPrevAnchorVec() {
        class_243 prevAnchorVec = super.getPrevAnchorVec();
        return prevAnchorVec.method_1023(0.5, 0.0, 0.5);
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        class_2338 offset = class_2338.method_49638((class_2374)this.getAnchorVec().method_1031(0.5, 0.5, 0.5));
        return new StructureTransform(offset, 0.0f, -this.yaw + this.getInitialYaw(), 0.0f);
    }

    @Override
    protected float getStalledAngle() {
        return this.yaw;
    }

    @Override
    protected void handleStallInformation(double x, double y, double z, float angle) {
        this.yaw = angle;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void applyLocalTransforms(class_4587 matrixStack, float partialTicks) {
        float angleInitialYaw = this.getInitialYaw();
        float angleYaw = this.method_5705(partialTicks);
        float anglePitch = this.method_5695(partialTicks);
        matrixStack.method_46416(-0.5f, 0.0f, -0.5f);
        class_1297 ridingEntity = this.method_5854();
        if (ridingEntity instanceof class_1688) {
            this.repositionOnCart(matrixStack, partialTicks, ridingEntity);
        } else if (ridingEntity instanceof AbstractContraptionEntity) {
            if (ridingEntity.method_5854() instanceof class_1688) {
                this.repositionOnCart(matrixStack, partialTicks, ridingEntity.method_5854());
            } else {
                this.repositionOnContraption(matrixStack, partialTicks, ridingEntity);
            }
        }
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((class_4587)matrixStack).nudge(this.method_5628())).center()).rotateYDegrees(angleYaw)).rotateZDegrees(anglePitch)).rotateYDegrees(angleInitialYaw)).uncenter();
    }

    @Environment(value=EnvType.CLIENT)
    private void repositionOnContraption(class_4587 matrixStack, float partialTicks, class_1297 ridingEntity) {
        class_243 pos = this.getContraptionOffset(partialTicks, ridingEntity);
        matrixStack.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    @Environment(value=EnvType.CLIENT)
    private void repositionOnCart(class_4587 matrixStack, float partialTicks, class_1297 ridingEntity) {
        class_243 cartPos = this.getCartOffset(partialTicks, ridingEntity);
        if (cartPos == class_243.field_1353) {
            return;
        }
        matrixStack.method_22904(cartPos.field_1352, cartPos.field_1351, cartPos.field_1350);
    }

    @Environment(value=EnvType.CLIENT)
    private class_243 getContraptionOffset(float partialTicks, class_1297 ridingEntity) {
        AbstractContraptionEntity parent = (AbstractContraptionEntity)ridingEntity;
        class_243 passengerPosition = parent.getPassengerPosition(this, partialTicks);
        if (passengerPosition == null) {
            return class_243.field_1353;
        }
        double x = passengerPosition.field_1352 - class_3532.method_16436((double)partialTicks, (double)this.field_6038, (double)this.method_23317());
        double y = passengerPosition.field_1351 - class_3532.method_16436((double)partialTicks, (double)this.field_5971, (double)this.method_23318());
        double z = passengerPosition.field_1350 - class_3532.method_16436((double)partialTicks, (double)this.field_5989, (double)this.method_23321());
        return new class_243(x, y, z);
    }

    @Environment(value=EnvType.CLIENT)
    private class_243 getCartOffset(float partialTicks, class_1297 ridingEntity) {
        double cartZ;
        double cartY;
        class_1688 cart = (class_1688)ridingEntity;
        double cartX = class_3532.method_16436((double)partialTicks, (double)cart.field_6038, (double)cart.method_23317());
        class_243 cartPos = cart.method_7508(cartX, cartY = class_3532.method_16436((double)partialTicks, (double)cart.field_5971, (double)cart.method_23318()), cartZ = class_3532.method_16436((double)partialTicks, (double)cart.field_5989, (double)cart.method_23321()));
        if (cartPos != null) {
            class_243 cartPosFront = cart.method_7505(cartX, cartY, cartZ, (double)0.3f);
            class_243 cartPosBack = cart.method_7505(cartX, cartY, cartZ, (double)-0.3f);
            if (cartPosFront == null) {
                cartPosFront = cartPos;
            }
            if (cartPosBack == null) {
                cartPosBack = cartPos;
            }
            cartX = cartPos.field_1352 - cartX;
            cartY = (cartPosFront.field_1351 + cartPosBack.field_1351) / 2.0 - cartY;
            cartZ = cartPos.field_1350 - cartZ;
            return new class_243(cartX, cartY, cartZ);
        }
        return class_243.field_1353;
    }

    @Environment(value=EnvType.CLIENT)
    public static void handleRelocationPacket(ContraptionRelocationPacket packet) {
        class_1297 class_12972 = class_310.method_1551().field_1687.method_8469(packet.entityID);
        if (class_12972 instanceof OrientedContraptionEntity) {
            OrientedContraptionEntity oce = (OrientedContraptionEntity)class_12972;
            oce.nonDamageTicks = 10;
        }
    }
}

