/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.minecart;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.minecart.CouplingHandler;
import com.simibubi.create.content.contraptions.minecart.capability.MinecartController;
import com.simibubi.create.content.kinetics.KineticDebugger;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.theme.Color;
import net.minecraft.class_1688;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_761;

public class CouplingRenderer {
    public static void renderAll(class_4587 ms, class_4597 buffer, class_243 camera) {
        CouplingHandler.forEachLoadedCoupling((class_1937)class_310.method_1551().field_1687, c -> {
            if (((MinecartController)c.getFirst()).hasContraptionCoupling(true)) {
                return;
            }
            CouplingRenderer.renderCoupling(ms, buffer, camera, (Couple<class_1688>)c.map(MinecartController::cart));
        });
    }

    public static void tickDebugModeRenders() {
        if (KineticDebugger.isActive()) {
            CouplingHandler.forEachLoadedCoupling((class_1937)class_310.method_1551().field_1687, CouplingRenderer::doDebugRender);
        }
    }

    public static void renderCoupling(class_4587 ms, class_4597 buffer, class_243 camera, Couple<class_1688> carts) {
        class_638 world = class_310.method_1551().field_1687;
        if (carts.getFirst() == null || carts.getSecond() == null) {
            return;
        }
        Couple lightValues = carts.map(c -> class_761.method_23794((class_1920)world, (class_2338)class_2338.method_49638((class_2374)c.method_5829().method_1005())));
        class_243 center = ((class_1688)carts.getFirst()).method_19538().method_1019(((class_1688)carts.getSecond()).method_19538()).method_1021(0.5);
        Couple transforms = carts.map(c -> CouplingRenderer.getSuitableCartEndpoint(c, center));
        class_2680 renderState = class_2246.field_10124.method_9564();
        class_4588 builder = buffer.getBuffer(class_1921.method_23577());
        SuperByteBuffer attachment = CachedBuffers.partial((PartialModel)AllPartialModels.COUPLING_ATTACHMENT, (class_2680)renderState);
        SuperByteBuffer ring = CachedBuffers.partial((PartialModel)AllPartialModels.COUPLING_RING, (class_2680)renderState);
        SuperByteBuffer connector = CachedBuffers.partial((PartialModel)AllPartialModels.COUPLING_CONNECTOR, (class_2680)renderState);
        class_243 zero = class_243.field_1353;
        class_243 firstEndpoint = ((CartEndpoint)transforms.getFirst()).apply(zero);
        class_243 secondEndpoint = ((CartEndpoint)transforms.getSecond()).apply(zero);
        class_243 endPointDiff = secondEndpoint.method_1020(firstEndpoint);
        double connectorYaw = -Math.atan2(endPointDiff.field_1350, endPointDiff.field_1352) * 180.0 / Math.PI;
        double connectorPitch = Math.atan2(endPointDiff.field_1351, endPointDiff.method_18805(1.0, 0.0, 1.0).method_1033()) * 180.0 / Math.PI;
        PoseTransformStack msr = TransformStack.of((class_4587)ms);
        carts.forEachWithContext((cart, isFirst) -> {
            CartEndpoint cartTransform = (CartEndpoint)transforms.get(isFirst.booleanValue());
            ms.method_22903();
            cartTransform.apply(ms, camera);
            attachment.light(((Integer)lightValues.get(isFirst.booleanValue())).intValue()).renderInto(ms, builder);
            msr.rotateYDegrees((float)connectorYaw - cartTransform.yaw);
            ring.light(((Integer)lightValues.get(isFirst.booleanValue())).intValue()).renderInto(ms, builder);
            ms.method_22909();
        });
        int l1 = (Integer)lightValues.getFirst();
        int l2 = (Integer)lightValues.getSecond();
        int meanBlockLight = ((l1 >> 4 & 0xF) + (l2 >> 4 & 0xF)) / 2;
        int meanSkyLight = ((l1 >> 20 & 0xF) + (l2 >> 20 & 0xF)) / 2;
        ms.method_22903();
        ((PoseTransformStack)((PoseTransformStack)msr.translate(firstEndpoint.method_1020(camera))).rotateYDegrees((float)connectorYaw)).rotateZDegrees((float)connectorPitch);
        ms.method_22905((float)endPointDiff.method_1033(), 1.0f, 1.0f);
        connector.light(meanSkyLight << 20 | meanBlockLight << 4).renderInto(ms, builder);
        ms.method_22909();
    }

    private static CartEndpoint getSuitableCartEndpoint(class_1688 cart, class_243 centerOfCoupling) {
        boolean isBackFaceCloser;
        long i = (long)cart.method_5628() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        double x = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        double y = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f + 0.375f;
        double z = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float pt = AnimationTickHolder.getPartialTicks();
        double xIn = class_3532.method_16436((double)pt, (double)cart.field_6038, (double)cart.method_23317());
        double yIn = class_3532.method_16436((double)pt, (double)cart.field_5971, (double)cart.method_23318());
        double zIn = class_3532.method_16436((double)pt, (double)cart.field_5989, (double)cart.method_23321());
        float yaw = class_3532.method_16439((float)pt, (float)cart.field_5982, (float)cart.method_36454());
        float pitch = class_3532.method_16439((float)pt, (float)cart.field_6004, (float)cart.method_36455());
        float roll = (float)cart.method_7507() - pt;
        float rollAmplifier = cart.method_7521() - pt;
        if (rollAmplifier < 0.0f) {
            rollAmplifier = 0.0f;
        }
        roll = roll > 0.0f ? class_3532.method_15374((float)roll) * roll * rollAmplifier / 10.0f * (float)cart.method_7522() : 0.0f;
        class_243 positionVec = new class_243(xIn, yIn, zIn);
        class_243 frontVec = positionVec.method_1019(VecHelper.rotate((class_243)new class_243(0.5, 0.0, 0.0), (double)(180.0f - yaw), (class_2350.class_2351)class_2350.class_2351.field_11052));
        class_243 backVec = positionVec.method_1019(VecHelper.rotate((class_243)new class_243(-0.5, 0.0, 0.0), (double)(180.0f - yaw), (class_2350.class_2351)class_2350.class_2351.field_11052));
        class_243 railVecOfPos = cart.method_7508(xIn, yIn, zIn);
        boolean flip = false;
        if (railVecOfPos != null) {
            frontVec = cart.method_7505(xIn, yIn, zIn, (double)0.3f);
            backVec = cart.method_7505(xIn, yIn, zIn, (double)-0.3f);
            if (frontVec == null) {
                frontVec = railVecOfPos;
            }
            if (backVec == null) {
                backVec = railVecOfPos;
            }
            x += railVecOfPos.field_1352;
            y += (frontVec.field_1351 + backVec.field_1351) / 2.0;
            z += railVecOfPos.field_1350;
            class_243 endPointDiff = backVec.method_1031(-frontVec.field_1352, -frontVec.field_1351, -frontVec.field_1350);
            if (endPointDiff.method_1033() != 0.0) {
                endPointDiff = endPointDiff.method_1029();
                yaw = (float)(Math.atan2(endPointDiff.field_1350, endPointDiff.field_1352) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(endPointDiff.field_1351) * 73.0);
            }
        } else {
            x += xIn;
            y += yIn;
            z += zIn;
        }
        float offsetMagnitude = 0.8125f;
        flip = isBackFaceCloser = frontVec.method_1025(centerOfCoupling) > backVec.method_1025(centerOfCoupling);
        float offset = isBackFaceCloser ? -0.8125f : 0.8125f;
        return new CartEndpoint(x, y + 0.125, z, 180.0f - yaw, -pitch, roll, offset, flip);
    }

    public static void doDebugRender(Couple<MinecartController> c) {
        boolean yOffset = true;
        MinecartController first = (MinecartController)c.getFirst();
        class_1688 mainCart = first.cart();
        class_243 mainCenter = mainCart.method_19538().method_1031(0.0, (double)yOffset, 0.0);
        class_243 connectedCenter = ((MinecartController)c.getSecond()).cart().method_19538().method_1031(0.0, (double)yOffset, 0.0);
        int color = Color.mixColors((int)11268329, (int)15631730, (float)((float)class_3532.method_15350((double)(Math.abs((double)first.getCouplingLength(true) - connectedCenter.method_1022(mainCenter)) * 8.0), (double)0.0, (double)1.0)));
        Outliner.getInstance().showLine((Object)("" + mainCart.method_5628()), mainCenter, connectedCenter).colored(color).lineWidth(0.125f);
        class_243 point = mainCart.method_19538().method_1031(0.0, (double)yOffset, 0.0);
        Outliner.getInstance().showLine((Object)(mainCart.method_5628() + "_dot"), point, point.method_1031(0.0, 0.0078125, 0.0)).colored(0xFFFFFF).lineWidth(0.25f);
    }

    static class CartEndpoint {
        double x;
        double y;
        double z;
        float yaw;
        float pitch;
        float roll;
        float offset;
        boolean flip;

        public CartEndpoint(double x, double y, double z, float yaw, float pitch, float roll, float offset, boolean flip) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
            this.roll = roll;
            this.offset = offset;
            this.flip = flip;
        }

        public class_243 apply(class_243 vec) {
            vec = vec.method_1031((double)this.offset, 0.0, 0.0);
            vec = VecHelper.rotate((class_243)vec, (double)this.roll, (class_2350.class_2351)class_2350.class_2351.field_11048);
            vec = VecHelper.rotate((class_243)vec, (double)this.pitch, (class_2350.class_2351)class_2350.class_2351.field_11051);
            vec = VecHelper.rotate((class_243)vec, (double)this.yaw, (class_2350.class_2351)class_2350.class_2351.field_11052);
            return vec.method_1031(this.x, this.y, this.z);
        }

        public void apply(class_4587 ms, class_243 camera) {
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((class_4587)ms).translate(camera.method_1021(-1.0).method_1031(this.x, this.y, this.z))).rotateYDegrees(this.yaw)).rotateZDegrees(this.pitch)).rotateXDegrees(this.roll)).translate(this.offset, 0.0f, 0.0f).rotateYDegrees(this.flip ? 180.0f : 0.0f);
        }
    }
}

