/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.piston;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllContraptionTypes;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.Queue;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2764;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import net.minecraft.class_3619;
import net.minecraft.class_5815;
import org.apache.commons.lang3.tuple.Pair;

public class PistonContraption
extends TranslatingContraption {
    protected int extensionLength;
    protected int initialExtensionProgress;
    protected class_2350 orientation;
    private class_238 pistonExtensionCollisionBox;
    private boolean retract;

    @Override
    public ContraptionType getType() {
        return (ContraptionType)AllContraptionTypes.PISTON.comp_349();
    }

    public PistonContraption() {
    }

    public PistonContraption(class_2350 direction, boolean retract) {
        this.orientation = direction;
        this.retract = retract;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        if (!this.collectExtensions(world, pos, this.orientation)) {
            return false;
        }
        int count = this.blocks.size();
        if (!this.searchMovedStructure(world, this.anchor, this.retract ? this.orientation.method_10153() : this.orientation)) {
            return false;
        }
        this.bounds = this.blocks.size() == count ? this.pistonExtensionCollisionBox : this.bounds.method_991(this.pistonExtensionCollisionBox);
        this.startMoving(world);
        return true;
    }

    private boolean collectExtensions(class_1937 world, class_2338 pos, class_2350 direction) throws AssemblyException {
        ArrayList<class_3499.class_3501> poles = new ArrayList<class_3499.class_3501>();
        class_2338 actualStart = pos;
        class_2680 nextBlock = world.method_8320(actualStart.method_10093(direction));
        int extensionsInFront = 0;
        class_2680 blockState = world.method_8320(pos);
        boolean sticky = MechanicalPistonBlock.isStickyPiston(blockState);
        if (!MechanicalPistonBlock.isPiston(blockState)) {
            return false;
        }
        if (blockState.method_11654(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
            while (PistonExtensionPoleBlock.PlacementHelper.get().matchesAxis(nextBlock, direction.method_10166()) || MechanicalPistonBlock.isPistonHead(nextBlock) && nextBlock.method_11654((class_2769)class_2741.field_12525) == direction) {
                actualStart = actualStart.method_10093(direction);
                poles.add(new class_3499.class_3501(actualStart, (class_2680)nextBlock.method_11657((class_2769)class_2741.field_12525, (Comparable)direction), null));
                ++extensionsInFront;
                if (MechanicalPistonBlock.isPistonHead(nextBlock)) break;
                nextBlock = world.method_8320(actualStart.method_10093(direction));
                if (extensionsInFront <= MechanicalPistonBlock.maxAllowedPistonPoles()) continue;
                throw AssemblyException.tooManyPistonPoles();
            }
        }
        if (extensionsInFront == 0) {
            poles.add(new class_3499.class_3501(pos, (class_2680)((class_2680)AllBlocks.MECHANICAL_PISTON_HEAD.getDefaultState().method_11657((class_2769)class_2741.field_12525, (Comparable)direction)).method_11657((class_2769)class_2741.field_12492, (Comparable)(sticky ? class_2764.field_12634 : class_2764.field_12637)), null));
        } else {
            poles.add(new class_3499.class_3501(pos, (class_2680)AllBlocks.PISTON_EXTENSION_POLE.getDefaultState().method_11657((class_2769)class_2741.field_12525, (Comparable)direction), null));
        }
        class_2338 end = pos;
        nextBlock = world.method_8320(end.method_10093(direction.method_10153()));
        int extensionsInBack = 0;
        while (PistonExtensionPoleBlock.PlacementHelper.get().matchesAxis(nextBlock, direction.method_10166())) {
            end = end.method_10093(direction.method_10153());
            poles.add(new class_3499.class_3501(end, (class_2680)nextBlock.method_11657((class_2769)class_2741.field_12525, (Comparable)direction), null));
            nextBlock = world.method_8320(end.method_10093(direction.method_10153()));
            if (extensionsInFront + ++extensionsInBack <= MechanicalPistonBlock.maxAllowedPistonPoles()) continue;
            throw AssemblyException.tooManyPistonPoles();
        }
        this.anchor = pos.method_10079(direction, this.initialExtensionProgress + 1);
        this.extensionLength = extensionsInBack + extensionsInFront;
        this.initialExtensionProgress = extensionsInFront;
        this.pistonExtensionCollisionBox = new class_238(class_2338.field_10980.method_10079(direction, -1), class_2338.field_10980.method_10079(direction, -this.extensionLength - 1)).method_1012(1.0, 1.0, 1.0);
        if (this.extensionLength == 0) {
            throw AssemblyException.noPistonPoles();
        }
        this.bounds = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (class_3499.class_3501 pole : poles) {
            class_2338 relPos = pole.comp_1341().method_10079(direction, -extensionsInFront);
            class_2338 localPos = relPos.method_10059((class_2382)this.anchor);
            this.getBlocks().put(localPos, new class_3499.class_3501(localPos, pole.comp_1342(), null));
        }
        return true;
    }

    @Override
    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return this.pistonExtensionCollisionBox.method_1006(VecHelper.getCenterOf((class_2382)pos.method_10059((class_2382)this.anchor)));
    }

    @Override
    protected boolean addToInitialFrontier(class_1937 world, class_2338 pos, class_2350 direction, Queue<class_2338> frontier) throws AssemblyException {
        boolean retracting;
        frontier.clear();
        boolean sticky = MechanicalPistonBlock.isStickyPiston(world.method_8320(pos.method_10079(this.orientation, -1)));
        boolean bl = retracting = direction != this.orientation;
        if (retracting && !sticky) {
            return true;
        }
        for (int offset = 0; offset <= (Integer)AllConfigs.server().kinetics.maxChassisRange.get(); ++offset) {
            if (offset == 1 && retracting) {
                return true;
            }
            class_2338 currentPos = pos.method_10079(this.orientation, offset + this.initialExtensionProgress);
            if (retracting && world.method_31606(currentPos)) {
                return true;
            }
            if (!world.method_8477(currentPos)) {
                throw AssemblyException.unloadedChunk(currentPos);
            }
            class_2680 state = world.method_8320(currentPos);
            if (!BlockMovementChecks.isMovementNecessary(state, world, currentPos)) {
                return true;
            }
            if (BlockMovementChecks.isBrittle(state) && !(state.method_26204() instanceof class_5815)) {
                return true;
            }
            if (MechanicalPistonBlock.isPistonHead(state) && state.method_11654((class_2769)class_2741.field_12525) == direction.method_10153()) {
                return true;
            }
            if (!BlockMovementChecks.isMovementAllowed(state, world, currentPos)) {
                if (retracting) {
                    return true;
                }
                throw AssemblyException.unmovableBlock(currentPos, state);
            }
            if (retracting && state.method_26223() == class_3619.field_15970) {
                return true;
            }
            frontier.add(currentPos);
            if (!BlockMovementChecks.isNotSupportive(state, this.orientation)) continue;
            return true;
        }
        return true;
    }

    @Override
    public void addBlock(class_1937 level, class_2338 pos, Pair<class_3499.class_3501, class_2586> capture) {
        super.addBlock(level, pos.method_10079(this.orientation, -this.initialExtensionProgress), capture);
    }

    @Override
    public class_2338 toLocalPos(class_2338 globalPos) {
        return globalPos.method_10059((class_2382)this.anchor).method_10079(this.orientation, -this.initialExtensionProgress);
    }

    @Override
    protected boolean customBlockPlacement(class_1936 world, class_2338 pos, class_2680 state) {
        class_2338 pistonPos = this.anchor.method_10079(this.orientation, -1);
        class_2680 pistonState = world.method_8320(pistonPos);
        class_2586 be = world.method_8321(pistonPos);
        if (pos.equals((Object)pistonPos)) {
            if (be == null || be.method_11015()) {
                return true;
            }
            if (!MechanicalPistonBlock.isExtensionPole(state) && MechanicalPistonBlock.isPiston(pistonState)) {
                world.method_8652(pistonPos, (class_2680)pistonState.method_11657(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.RETRACTED)), 19);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean customBlockRemoval(class_1936 world, class_2338 pos, class_2680 state) {
        class_2338 pistonPos = this.anchor.method_10079(this.orientation, -1);
        class_2680 blockState = world.method_8320(pos);
        if (pos.equals((Object)pistonPos) && MechanicalPistonBlock.isPiston(blockState)) {
            world.method_8652(pos, (class_2680)blockState.method_11657(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.MOVING)), 82);
            return true;
        }
        return false;
    }

    @Override
    public void readNBT(class_1937 world, class_2487 nbt, boolean spawnData) {
        super.readNBT(world, nbt, spawnData);
        this.initialExtensionProgress = nbt.method_10550("InitialLength");
        this.extensionLength = nbt.method_10550("ExtensionLength");
        this.orientation = class_2350.method_10143((int)nbt.method_10550("Orientation"));
    }

    @Override
    public class_2487 writeNBT(boolean spawnPacket) {
        class_2487 tag = super.writeNBT(spawnPacket);
        tag.method_10569("InitialLength", this.initialExtensionProgress);
        tag.method_10569("ExtensionLength", this.extensionLength);
        tag.method_10569("Orientation", this.orientation.method_10146());
        return tag;
    }
}

