/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids;

import com.simibubi.create.AllFluids;
import com.simibubi.create.api.effect.OpenPipeEffectHandler;
import com.simibubi.create.content.fluids.FlowSource;
import com.simibubi.create.content.fluids.FluidReactions;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.mixin.accessor.FlowingFluidAccessor;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.tropheusj.milk.Milk;
import net.createmod.catnip.math.BlockFace;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;

public class OpenEndedPipe
extends FlowSource {
    private class_1937 world;
    private class_2338 pos;
    private class_238 aoe;
    private OpenEndFluidHandler fluidHandler = new OpenEndFluidHandler();
    private class_2338 outputPos;
    private boolean wasPulling;

    public OpenEndedPipe(BlockFace face) {
        super(face);
        this.outputPos = face.getConnectedPos();
        this.pos = face.getPos();
        this.aoe = new class_238(this.outputPos).method_1012(0.0, -1.0, 0.0);
        if (face.getFace() == class_2350.field_11033) {
            this.aoe = this.aoe.method_1012(0.0, -1.0, 0.0);
        }
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2338 getOutputPos() {
        return this.outputPos;
    }

    public class_238 getAOE() {
        return this.aoe;
    }

    @Override
    public void manageSource(class_1937 world) {
        this.world = world;
    }

    @Override
    public Storage<FluidVariant> provideHandler() {
        return this.fluidHandler;
    }

    @Override
    public boolean isEndpoint() {
        return true;
    }

    public class_2487 serializeNBT() {
        class_2487 compound = new class_2487();
        this.fluidHandler.writeToNBT(compound);
        compound.method_10556("Pulling", this.wasPulling);
        compound.method_10566("Location", (class_2520)this.location.serializeNBT());
        return compound;
    }

    public static OpenEndedPipe fromNBT(class_2487 compound, class_2338 blockEntityPos) {
        BlockFace fromNBT = BlockFace.fromNBT((class_2487)compound.method_10562("Location"));
        OpenEndedPipe oep = new OpenEndedPipe(new BlockFace(blockEntityPos, fromNBT.getFace()));
        oep.fluidHandler.readFromNBT(compound);
        oep.wasPulling = compound.method_10577("Pulling");
        return oep;
    }

    private FluidStack removeFluidFromSpace(TransactionContext ctx) {
        FluidStack empty = FluidStack.EMPTY;
        if (this.world == null) {
            return empty;
        }
        if (!this.world.method_8477(this.outputPos)) {
            return empty;
        }
        class_2680 state = this.world.method_8320(this.outputPos);
        class_3610 fluidState = state.method_26227();
        boolean waterlog = state.method_28498((class_2769)class_2741.field_12508);
        FluidStack drainBlock = VanillaFluidTargets.drainBlock(this.world, this.outputPos, state, ctx);
        if (!drainBlock.isEmpty()) {
            if (state.method_28498((class_2769)class_2741.field_20432) && AllFluids.HONEY.is((Object)drainBlock.getFluid())) {
                TransactionCallback.onSuccess((TransactionContext)ctx, () -> AdvancementBehaviour.tryAward((class_1922)this.world, this.pos, AllAdvancements.HONEY_DRAIN));
            }
            return drainBlock;
        }
        if (!waterlog && !state.method_45474()) {
            return empty;
        }
        if (fluidState.method_15769() || !fluidState.method_15771()) {
            return empty;
        }
        FluidStack stack = new FluidStack(fluidState.method_15772(), 81000L);
        if (FluidHelper.isWater(stack.getFluid())) {
            AdvancementBehaviour.tryAward((class_1922)this.world, this.pos, AllAdvancements.WATER_SUPPLY);
        }
        this.world.updateSnapshots(ctx);
        if (waterlog) {
            this.world.method_8652(this.outputPos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), 3);
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> this.world.method_39281(this.outputPos, (class_3611)class_3612.field_15910, 1));
        } else {
            FlowingFluidAccessor flowing;
            class_3610 potentiallyFilled;
            class_2680 newState = (class_2680)fluidState.method_15759().method_11657((class_2769)class_2404.field_11278, (Comparable)Integer.valueOf(14));
            class_3610 newFluidState = newState.method_26227();
            class_3611 class_36112 = newFluidState.method_15772();
            if (class_36112 instanceof FlowingFluidAccessor && (potentiallyFilled = (flowing = (FlowingFluidAccessor)class_36112).create$getNewLiquid(this.world, this.outputPos, newState)).equals(fluidState)) {
                return stack;
            }
            this.world.method_8652(this.outputPos, newState, 3);
        }
        return stack;
    }

    private boolean provideFluidToSpace(FluidStack fluid, TransactionContext ctx) {
        if (this.world == null) {
            return false;
        }
        if (!this.world.method_8477(this.outputPos)) {
            return false;
        }
        class_2680 state = this.world.method_8320(this.outputPos);
        class_3610 fluidState = state.method_26227();
        boolean waterlog = state.method_28498((class_2769)class_2741.field_12508);
        if (!waterlog && !state.method_45474()) {
            return false;
        }
        if (fluid.isEmpty()) {
            return false;
        }
        if (!(fluid.getFluid() instanceof class_3609)) {
            return false;
        }
        if (!(fluid.getFluid() instanceof class_3609)) {
            return false;
        }
        if (!OpenEndedPipe.isPlaceable(fluid.getFluid())) {
            return true;
        }
        if (!fluidState.method_15769() && FluidHelper.convertToStill(fluidState.method_15772()) != fluid.getFluid()) {
            FluidReactions.handlePipeSpillCollision(this.world, this.outputPos, fluid.getFluid(), fluidState);
            return false;
        }
        if (fluidState.method_15771()) {
            return false;
        }
        if (waterlog && fluid.getFluid() != class_3612.field_15910) {
            return false;
        }
        if (!((Boolean)AllConfigs.server().fluids.pipesPlaceFluidSourceBlocks.get()).booleanValue()) {
            return true;
        }
        if (this.world.method_8597().comp_644() && FluidHelper.isTag(fluid, (class_6862<class_3611>)class_3486.field_15517)) {
            int i = this.outputPos.method_10263();
            int j = this.outputPos.method_10264();
            int k = this.outputPos.method_10260();
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> this.world.method_43128(null, (double)i, (double)j, (double)k, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (this.world.field_9229.method_43057() - this.world.field_9229.method_43057()) * 0.8f));
            return true;
        }
        this.world.updateSnapshots(ctx);
        if (waterlog) {
            this.world.method_8652(this.outputPos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 3);
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> this.world.method_39281(this.outputPos, (class_3611)class_3612.field_15910, 1));
            return true;
        }
        this.world.method_8652(this.outputPos, fluid.getFluid().method_15785().method_15759(), 3);
        return true;
    }

    private static boolean isPlaceable(class_3611 fluid) {
        return FluidHelper.hasBlockState(fluid) && !fluid.method_15791(Milk.MILK_FLUID_TAG);
    }

    private class OpenEndFluidHandler
    extends FluidTank {
        public OpenEndFluidHandler() {
            super(81000L);
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            OpenPipeEffectHandler effectHandler;
            if (OpenEndedPipe.this.world == null) {
                return 0L;
            }
            if (!OpenEndedPipe.this.world.method_8477(OpenEndedPipe.this.outputPos)) {
                return 0L;
            }
            if (resource.isBlank()) {
                return 0L;
            }
            FluidStack stack = new FluidStack(resource, 81L);
            this.updateSnapshots(transaction);
            try (Transaction provideTest = transaction.openNested();){
                if (!OpenEndedPipe.this.provideFluidToSpace(stack, (TransactionContext)provideTest)) {
                    long l = 0L;
                    return l;
                }
            }
            FluidStack containedFluidStack = this.getFluid();
            boolean hasBlockState = OpenEndedPipe.isPlaceable(containedFluidStack.getFluid());
            if (!containedFluidStack.isEmpty() && !containedFluidStack.canFill(resource)) {
                this.setFluid(FluidStack.EMPTY);
            }
            if (OpenEndedPipe.this.wasPulling) {
                OpenEndedPipe.this.wasPulling = false;
            }
            if ((effectHandler = OpenPipeEffectHandler.REGISTRY.get(resource.getFluid())) != null && !hasBlockState) {
                maxAmount = 81L;
            }
            long fill = super.insert(resource, maxAmount, transaction);
            if (effectHandler != null) {
                FluidStack exposed = new FluidStack(resource, 81L);
                effectHandler.apply(OpenEndedPipe.this.world, OpenEndedPipe.this.aoe, exposed);
            }
            if ((this.getFluidAmount() == 81000L || !hasBlockState) && OpenEndedPipe.this.provideFluidToSpace(containedFluidStack, transaction)) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fill;
        }

        public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            if (OpenEndedPipe.this.world == null) {
                return 0L;
            }
            if (!OpenEndedPipe.this.world.method_8477(OpenEndedPipe.this.outputPos)) {
                return 0L;
            }
            if (maxAmount == 0L) {
                return 0L;
            }
            if (maxAmount > 81000L) {
                maxAmount = 81000L;
            }
            if (!OpenEndedPipe.this.wasPulling) {
                OpenEndedPipe.this.wasPulling = true;
            }
            this.updateSnapshots(transaction);
            long drainedFromInternal = super.extract(extractedVariant, maxAmount, transaction);
            if (drainedFromInternal != 0L) {
                return drainedFromInternal;
            }
            FluidStack drainedFromWorld = OpenEndedPipe.this.removeFluidFromSpace(transaction);
            if (drainedFromWorld.isEmpty()) {
                return 0L;
            }
            if (!drainedFromWorld.canFill(extractedVariant)) {
                return 0L;
            }
            long remainder = drainedFromWorld.getAmount() - maxAmount;
            drainedFromWorld.setAmount(maxAmount);
            if (remainder > 0L) {
                if (!this.getFluid().isEmpty() && !this.getFluid().isFluidEqual(drainedFromWorld)) {
                    this.setFluid(FluidStack.EMPTY);
                }
                super.insert(drainedFromWorld.getType(), remainder, transaction);
            }
            return drainedFromWorld.getAmount();
        }

        public boolean isResourceBlank() {
            if (!super.isResourceBlank()) {
                return false;
            }
            return this.getResource().isBlank();
        }

        public FluidVariant getResource() {
            if (!super.isResourceBlank()) {
                return (FluidVariant)super.getResource();
            }
            try (Transaction t = TransferUtil.getTransaction();){
                FluidStack stack = OpenEndedPipe.this.removeFluidFromSpace((TransactionContext)t);
                FluidVariant fluidVariant = stack.getType();
                return fluidVariant;
            }
        }

        public long getAmount() {
            long amount = super.getAmount();
            if (amount != 0L) {
                return amount;
            }
            return this.isResourceBlank() ? 0L : 81000L;
        }
    }
}

