/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllParticleTypes;
import com.simibubi.create.content.fluids.particle.FluidStackParticle;
import com.simibubi.create.foundation.particle.ICustomParticleData;
import com.simibubi.create.foundation.utility.CreateCodecs;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import net.createmod.catnip.platform.CatnipServices;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class FluidParticleData
implements class_2394,
ICustomParticleData<FluidParticleData> {
    private class_2396<FluidParticleData> type;
    private FluidStack fluid;
    public static final Codec<FluidParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)CreateCodecs.FLUID_STACK_CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)i, fs -> new FluidParticleData(AllParticleTypes.FLUID_PARTICLE.get(), (FluidStack)fs)));
    public static final Codec<FluidParticleData> BASIN_CODEC = RecordCodecBuilder.create(i -> i.group((App)CreateCodecs.FLUID_STACK_CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)i, fs -> new FluidParticleData(AllParticleTypes.BASIN_FLUID.get(), (FluidStack)fs)));
    public static final Codec<FluidParticleData> DRIP_CODEC = RecordCodecBuilder.create(i -> i.group((App)CreateCodecs.FLUID_STACK_CODEC.fieldOf("fluid").forGetter(p -> p.fluid)).apply((Applicative)i, fs -> new FluidParticleData(AllParticleTypes.FLUID_DRIP.get(), (FluidStack)fs)));
    public static final class_2394.class_2395<FluidParticleData> DESERIALIZER = new class_2394.class_2395<FluidParticleData>(){

        public FluidParticleData fromCommand(class_2396<FluidParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new FluidParticleData(particleTypeIn, new FluidStack((class_3611)class_3612.field_15910, 1L));
        }

        public FluidParticleData fromNetwork(class_2396<FluidParticleData> particleTypeIn, class_2540 buffer) {
            return new FluidParticleData(particleTypeIn, FluidStack.readFromPacket((class_2540)buffer));
        }
    };

    public FluidParticleData() {
    }

    public FluidParticleData(class_2396<?> type, FluidStack fluid) {
        this.type = type;
        this.fluid = fluid;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_707<FluidParticleData> getFactory() {
        return this::create;
    }

    @Environment(value=EnvType.CLIENT)
    private class_703 create(FluidParticleData type, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return FluidStackParticle.create(type.type, level, type.fluid, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public class_2396<?> method_10295() {
        return this.type;
    }

    public void method_10294(class_2540 buffer) {
        this.fluid.writeToPacket(buffer);
    }

    public String method_10293() {
        return String.valueOf(CatnipServices.REGISTRIES.getKeyOrThrow(this.type)) + " " + String.valueOf(CatnipServices.REGISTRIES.getKeyOrThrow(this.fluid.getFluid()));
    }

    @Override
    public class_2394.class_2395<FluidParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    @Override
    public Codec<FluidParticleData> getCodec(class_2396<FluidParticleData> type) {
        if (type == AllParticleTypes.BASIN_FLUID.get()) {
            return BASIN_CODEC;
        }
        if (type == AllParticleTypes.FLUID_DRIP.get()) {
            return DRIP_CODEC;
        }
        return CODEC;
    }
}

