/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pipes;

import com.simibubi.create.content.fluids.FluidInstance;
import com.simibubi.create.content.fluids.FluidMesh;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.content.fluids.pipes.StraightPipeBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import dev.engine_room.flywheel.lib.visual.util.SmartRecycler;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.function.Consumer;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_1922;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class GlassPipeVisual
extends AbstractBlockEntityVisual<StraightPipeBlockEntity>
implements SimpleDynamicVisual {
    private int light;
    private final SmartRecycler<class_1058, FluidInstance> stream = new SmartRecycler(sprite -> (FluidInstance)ctx.instancerProvider().instancer(AllInstanceTypes.FLUID, FluidMesh.stream(sprite)).createInstance());
    private final SmartRecycler<class_1058, TransformedInstance> surface = new SmartRecycler(sprite -> (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, FluidMesh.surface(sprite, 0.1875f)).createInstance());

    public GlassPipeVisual(VisualizationContext ctx, StraightPipeBlockEntity blockEntity, float partialTick) {
        super(ctx, (class_2586)blockEntity, partialTick);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.stream.resetCount();
        this.surface.resetCount();
        FluidTransportBehaviour pipe = ((StraightPipeBlockEntity)this.blockEntity).getBehaviour(FluidTransportBehaviour.TYPE);
        if (pipe == null) {
            this.stream.discardExtra();
            this.surface.discardExtra();
            return;
        }
        for (class_2350 side : Iterate.directions) {
            FluidVariant variant;
            class_1058[] sprites;
            LerpedFloat progressLerp;
            FluidStack fluidStack;
            PipeConnection.Flow flow = pipe.getFlow(side);
            if (flow == null || (fluidStack = flow.fluid).isEmpty() || (progressLerp = flow.progress) == null) continue;
            float progress = progressLerp.getValue(ctx.partialTick());
            boolean inbound = flow.inbound;
            if (progress == 1.0f) {
                if (inbound) {
                    PipeConnection.Flow opposite = pipe.getFlow(side.method_10153());
                    if (opposite == null) {
                        progress -= 1.0E-6f;
                    }
                } else {
                    FluidTransportBehaviour adjacent = BlockEntityBehaviour.get((class_1922)this.level, this.pos.method_10093(side), FluidTransportBehaviour.TYPE);
                    if (adjacent == null) {
                        progress -= 1.0E-6f;
                    } else {
                        PipeConnection.Flow other = adjacent.getFlow(side.method_10153());
                        if (other == null || !other.inbound && !other.complete) {
                            progress -= 1.0E-6f;
                        }
                    }
                }
            }
            if ((sprites = FluidVariantRendering.getSprites((FluidVariant)(variant = fluidStack.getType()))) == null) {
                this.stream.discardExtra();
                this.surface.discardExtra();
                return;
            }
            class_1058 flowTexture = sprites[1];
            int color = FluidVariantRendering.getColor((FluidVariant)fluidStack.getType());
            int blockLightIn = this.light >> 4 & 0xF;
            int luminosity = Math.max(blockLightIn, FluidVariantAttributes.getLuminance((FluidVariant)variant));
            int light = this.light & 0xF00000 | luminosity << 4;
            if (inbound) {
                side = side.method_10153();
            }
            float yStart = inbound ? 0.0f : 0.5f;
            float progressOffset = class_3532.method_15363((float)(progress * 0.5f), (float)0.0f, (float)1.0f);
            FluidInstance fluidInstance = (FluidInstance)this.stream.get((Object)flowTexture);
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)fluidInstance.setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotateTo(class_2350.field_11036, side)).translate(0.0f, -0.5f + yStart, 0.0f);
            fluidInstance.light(light).colorArgb(color);
            fluidInstance.vScale = (flowTexture.method_4575() - flowTexture.method_4593()) * 0.5f;
            fluidInstance.v0 = flowTexture.method_4593() + yStart * fluidInstance.vScale;
            fluidInstance.progress = progressOffset;
            fluidInstance.setChanged();
            if (progress == 1.0f) continue;
            class_1058 stillTexture = sprites[1];
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.surface.get((Object)stillTexture)).setIdentityTransform().translate((class_2382)this.getVisualPosition())).center()).rotateTo(class_2350.field_11036, side)).translate(0.0f, -0.5f + yStart + progressOffset, 0.0f).light(light).colorArgb(color).setChanged();
        }
        this.stream.discardExtra();
        this.surface.discardExtra();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    public void updateLight(float partialTick) {
        this.light = this.computePackedLight();
    }

    protected void _delete() {
        this.stream.delete();
        this.surface.delete();
    }
}

