/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.pump;

import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeAttachmentBlockEntity;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.BlockFace;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PumpBlockEntity
extends KineticBlockEntity
implements PipeAttachmentBlockEntity {
    Couple<MutableBoolean> sidesToUpdate = Couple.create(MutableBoolean::new);
    boolean pressureUpdate;
    boolean scheduleFlip;

    public PumpBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add(new PumpFluidTransferBehaviour(this));
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
        this.registerAwardables(behaviours, AllAdvancements.PUMP);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        if (this.scheduleFlip) {
            this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)PumpBlock.FACING, (Comparable)((class_2350)this.method_11010().method_11654((class_2769)PumpBlock.FACING)).method_10153()));
            this.scheduleFlip = false;
        }
        this.sidesToUpdate.forEachWithContext((update, isFront) -> {
            if (update.isFalse()) {
                return;
            }
            update.setFalse();
            this.distributePressureTo(isFront != false ? this.getFront() : this.getFront().method_10153());
        });
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        if (Math.abs(previousSpeed) == Math.abs(this.getSpeed())) {
            return;
        }
        if (this.speed != 0.0f) {
            this.award(AllAdvancements.PUMP);
        }
        if (this.field_11863.field_9236 && !this.isVirtual()) {
            return;
        }
        this.updatePressureChange();
    }

    public void updatePressureChange() {
        this.pressureUpdate = false;
        class_2338 frontPos = this.field_11867.method_10093(this.getFront());
        class_2338 backPos = this.field_11867.method_10093(this.getFront().method_10153());
        FluidPropagator.propagateChangedPipe((class_1936)this.field_11863, frontPos, this.field_11863.method_8320(frontPos));
        FluidPropagator.propagateChangedPipe((class_1936)this.field_11863, backPos, this.field_11863.method_8320(backPos));
        FluidTransportBehaviour behaviour = this.getBehaviour(FluidTransportBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.wipePressure();
        }
        this.sidesToUpdate.forEach(MutableBoolean::setTrue);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.method_10577("Reversed")) {
            this.scheduleFlip = true;
        }
    }

    protected void distributePressureTo(class_2350 side) {
        if (this.getSpeed() == 0.0f) {
            return;
        }
        BlockFace start = new BlockFace(this.field_11867, side);
        boolean pull = this.isPullingOnSide(this.isFront(side));
        HashSet<BlockFace> targets = new HashSet<BlockFace>();
        HashMap<class_2338, Pair<Integer, Map<class_2350, Boolean>>> pipeGraph = new HashMap<class_2338, Pair<Integer, Map<class_2350, Boolean>>>();
        if (!pull) {
            FluidPropagator.resetAffectedFluidNetworks(this.field_11863, this.field_11867, side.method_10153());
        }
        if (!this.hasReachedValidEndpoint(this.field_11863, start, pull)) {
            ((Map)pipeGraph.computeIfAbsent(this.field_11867, $ -> Pair.of((Object)0, new IdentityHashMap())).getSecond()).put(side, pull);
            ((Map)pipeGraph.computeIfAbsent(start.getConnectedPos(), $ -> Pair.of((Object)1, new IdentityHashMap())).getSecond()).put(side.method_10153(), !pull);
            ArrayList<Pair> frontier = new ArrayList<Pair>();
            HashSet<class_2338> visited = new HashSet<class_2338>();
            int maxDistance = FluidPropagator.getPumpRange();
            frontier.add(Pair.of((Object)1, (Object)start.getConnectedPos()));
            while (!frontier.isEmpty()) {
                Pair entry = (Pair)frontier.remove(0);
                int distance = (Integer)entry.getFirst();
                class_2338 currentPos = (class_2338)entry.getSecond();
                if (!this.field_11863.method_8477(currentPos) || visited.contains(currentPos)) continue;
                visited.add(currentPos);
                class_2680 currentState = this.field_11863.method_8320(currentPos);
                FluidTransportBehaviour pipe = FluidPropagator.getPipe((class_1922)this.field_11863, currentPos);
                if (pipe == null) continue;
                for (class_2350 face : FluidPropagator.getPipeConnections(currentState, pipe)) {
                    BlockFace blockFace = new BlockFace(currentPos, face);
                    class_2338 connectedPos = blockFace.getConnectedPos();
                    if (!this.field_11863.method_8477(connectedPos) || blockFace.isEquivalent(start)) continue;
                    if (this.hasReachedValidEndpoint(this.field_11863, blockFace, pull)) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((class_1922)this.field_11863, connectedPos);
                    if (pipeBehaviour == null || pipeBehaviour instanceof PumpFluidTransferBehaviour || visited.contains(connectedPos)) continue;
                    if (distance + 1 >= maxDistance) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                    ((Map)pipeGraph.computeIfAbsent(connectedPos, $ -> Pair.of((Object)(distance + 1), new IdentityHashMap())).getSecond()).put(face.method_10153(), !pull);
                    frontier.add(Pair.of((Object)(distance + 1), (Object)connectedPos));
                }
            }
        }
        HashMap<Integer, Set<BlockFace>> validFaces = new HashMap<Integer, Set<BlockFace>>();
        this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(start.getPos(), start.getOppositeFace()), pull);
        float pressure = Math.abs(this.getSpeed());
        for (Set set : validFaces.values()) {
            int parallelBranches = Math.max(1, set.size() - 1);
            for (BlockFace face : set) {
                class_2338 pipePos = face.getPos();
                class_2350 pipeSide = face.getFace();
                if (pipePos.equals((Object)this.field_11867)) continue;
                boolean inbound = (Boolean)((Map)((Pair)pipeGraph.get(pipePos)).getSecond()).get(pipeSide);
                FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((class_1922)this.field_11863, pipePos);
                if (pipeBehaviour == null) continue;
                pipeBehaviour.addPressure(pipeSide, inbound, pressure / (float)parallelBranches);
            }
        }
    }

    protected boolean searchForEndpointRecursively(Map<class_2338, Pair<Integer, Map<class_2350, Boolean>>> pipeGraph, Set<BlockFace> targets, Map<Integer, Set<BlockFace>> validFaces, BlockFace currentFace, boolean pull) {
        class_2338 currentPos = currentFace.getPos();
        if (!pipeGraph.containsKey(currentPos)) {
            return false;
        }
        Pair<Integer, Map<class_2350, Boolean>> pair = pipeGraph.get(currentPos);
        int distance = (Integer)pair.getFirst();
        boolean atLeastOneBranchSuccessful = false;
        for (class_2350 nextFacing : Iterate.directions) {
            Map map;
            if (nextFacing == currentFace.getFace() || !(map = (Map)pair.getSecond()).containsKey(nextFacing)) continue;
            BlockFace localTarget = new BlockFace(currentPos, nextFacing);
            if (targets.contains(localTarget)) {
                validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(localTarget);
                atLeastOneBranchSuccessful = true;
                continue;
            }
            if ((Boolean)map.get(nextFacing) != pull || !this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(currentPos.method_10093(nextFacing), nextFacing.method_10153()), pull)) continue;
            validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(localTarget);
            atLeastOneBranchSuccessful = true;
        }
        if (atLeastOneBranchSuccessful) {
            validFaces.computeIfAbsent(distance, $ -> new HashSet()).add(currentFace);
        }
        return atLeastOneBranchSuccessful;
    }

    private boolean hasReachedValidEndpoint(class_1937 world, BlockFace blockFace, boolean pull) {
        class_2338 connectedPos = blockFace.getConnectedPos();
        class_2586 blockEntity = world.method_8321(connectedPos);
        class_2680 connectedState = blockEntity != null ? blockEntity.method_11010() : world.method_8320(connectedPos);
        class_2350 face = blockFace.getFace();
        if (PumpBlock.isPump(connectedState) && ((class_2350)connectedState.method_11654((class_2769)PumpBlock.FACING)).method_10166() == face.method_10166() && blockEntity instanceof PumpBlockEntity) {
            PumpBlockEntity pumpBE = (PumpBlockEntity)blockEntity;
            return pumpBE.isPullingOnSide(pumpBE.isFront(blockFace.getOppositeFace())) != pull;
        }
        FluidTransportBehaviour pipe = FluidPropagator.getPipe((class_1922)world, connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, blockFace.getOppositeFace())) {
            return false;
        }
        if (FluidStorage.SIDED.find(world, connectedPos, null, blockEntity, (Object)face.method_10153()) != null) {
            return true;
        }
        return FluidPropagator.isOpenEnd((class_1922)world, blockFace.getPos(), face);
    }

    public void updatePipesOnSide(class_2350 side) {
        if (!this.isSideAccessible(side)) {
            return;
        }
        this.updatePipeNetwork(this.isFront(side));
        this.getBehaviour(FluidTransportBehaviour.TYPE).wipePressure();
    }

    protected boolean isFront(class_2350 side) {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof PumpBlock)) {
            return false;
        }
        class_2350 front = (class_2350)blockState.method_11654((class_2769)PumpBlock.FACING);
        boolean isFront = side == front;
        return isFront;
    }

    @Nullable
    protected class_2350 getFront() {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof PumpBlock)) {
            return null;
        }
        return (class_2350)blockState.method_11654((class_2769)PumpBlock.FACING);
    }

    protected void updatePipeNetwork(boolean front) {
        ((MutableBoolean)this.sidesToUpdate.get(front)).setTrue();
    }

    public boolean isSideAccessible(class_2350 side) {
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof PumpBlock)) {
            return false;
        }
        return ((class_2350)blockState.method_11654((class_2769)PumpBlock.FACING)).method_10166() == side.method_10166();
    }

    public boolean isPullingOnSide(boolean front) {
        return !front;
    }

    @Nullable
    public Object getRenderData() {
        return PipeAttachmentBlockEntity.getAttachments(this);
    }

    class PumpFluidTransferBehaviour
    extends FluidTransportBehaviour {
        public PumpFluidTransferBehaviour(SmartBlockEntity be) {
            super(be);
        }

        @Override
        public void tick() {
            super.tick();
            for (Map.Entry entry : this.interfaces.entrySet()) {
                boolean pull = PumpBlockEntity.this.isPullingOnSide(PumpBlockEntity.this.isFront((class_2350)entry.getKey()));
                Couple<Float> pressure = ((PipeConnection)entry.getValue()).getPressure();
                pressure.set(pull, (Object)Float.valueOf(Math.abs(PumpBlockEntity.this.getSpeed())));
                pressure.set(!pull, (Object)Float.valueOf(0.0f));
            }
        }

        @Override
        public boolean canHaveFlowToward(class_2680 state, class_2350 direction) {
            return PumpBlockEntity.this.isSideAccessible(direction);
        }

        @Override
        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(class_1920 world, class_2338 pos, class_2680 state, class_2350 direction) {
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            return attachment;
        }
    }
}

