/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.tank;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.platform.FabricCatnipServices;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;

public class FluidTankRenderer
extends SafeBlockEntityRenderer<FluidTankBlockEntity> {
    public FluidTankRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(FluidTankBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        if (!be.window) {
            if (be.boiler.isActive()) {
                this.renderAsBoiler(be, partialTicks, ms, buffer, light, overlay);
            }
            return;
        }
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.height - 2.0f * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = class_3532.method_15363((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        SmartFluidTank tank = be.tankInventory;
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = FluidVariantAttributes.isLighterThanAir((FluidVariant)fluidStack.getType());
        float xMin = tankHullWidth;
        float xMax = xMin + (float)be.width - 2.0f * tankHullWidth;
        float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = tankHullWidth;
        float zMax = zMin + (float)be.width - 2.0f * tankHullWidth;
        ms.method_22903();
        ms.method_46416(0.0f, clampedLevel - totalHeight, 0.0f);
        FabricCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false, true);
        ms.method_22909();
    }

    protected void renderAsBoiler(FluidTankBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_2680 blockState = be.method_11010();
        class_4588 vb = buffer.getBuffer(class_1921.method_23581());
        ms.method_22903();
        PoseTransformStack msr = TransformStack.of((class_4587)ms);
        msr.translate((double)((float)be.width / 2.0f), 0.5, (double)((float)be.width / 2.0f));
        float dialPivotY = 0.375f;
        float dialPivotZ = 0.5f;
        float progress = be.boiler.gauge.getValue(partialTicks);
        for (class_2350 d : Iterate.horizontalDirections) {
            if (be.boiler.occludedDirections[d.method_10161()]) continue;
            ms.method_22903();
            float yRot = -d.method_10144() - 90.0f;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)AllPartialModels.BOILER_GAUGE, (class_2680)blockState).rotateYDegrees(yRot)).uncenter()).translate((float)be.width / 2.0f - 0.375f, 0.0f, 0.0f)).light(light).renderInto(ms, vb);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)AllPartialModels.BOILER_GAUGE_DIAL, (class_2680)blockState).rotateYDegrees(yRot)).uncenter()).translate((float)be.width / 2.0f - 0.375f, 0.0f, 0.0f)).translate(0.0f, dialPivotY, dialPivotZ)).rotateXDegrees(-145.0f * progress + 90.0f)).translate(0.0f, -dialPivotY, -dialPivotZ)).light(light).renderInto(ms, vb);
            ms.method_22909();
        }
        ms.method_22909();
    }

    public boolean shouldRenderOffScreen(FluidTankBlockEntity be) {
        return be.isController();
    }
}

