/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.base;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.KineticDebugger;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.createmod.catnip.theme.Color;
import net.minecraft.class_1921;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4696;
import net.minecraft.class_5614;

public class KineticBlockEntityRenderer<T extends KineticBlockEntity>
extends SafeBlockEntityRenderer<T> {
    public static final SuperByteBufferCache.Compartment<class_2680> KINETIC_BLOCK = new SuperByteBufferCache.Compartment();
    public static boolean rainbowMode = false;

    public KineticBlockEntityRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(T be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((class_1936)be.method_10997())) {
            return;
        }
        class_2680 state = this.getRenderedBlockState(be);
        class_1921 type = this.getRenderType(be, state);
        KineticBlockEntityRenderer.renderRotatingBuffer(be, this.getRotatedModel(be, state), ms, buffer.getBuffer(type), light);
    }

    protected class_2680 getRenderedBlockState(T be) {
        return be.method_11010();
    }

    protected class_1921 getRenderType(T be, class_2680 state) {
        return class_4696.method_23679((class_2680)state);
    }

    protected SuperByteBuffer getRotatedModel(T be, class_2680 state) {
        return CachedBuffers.block(KINETIC_BLOCK, (class_2680)state);
    }

    public static void renderRotatingKineticBlock(KineticBlockEntity be, class_2680 renderedState, class_4587 ms, class_4588 buffer, int light) {
        SuperByteBuffer superByteBuffer = CachedBuffers.block(KINETIC_BLOCK, (class_2680)renderedState);
        KineticBlockEntityRenderer.renderRotatingBuffer(be, superByteBuffer, ms, buffer, light);
    }

    public static void renderRotatingBuffer(KineticBlockEntity be, SuperByteBuffer superBuffer, class_4587 ms, class_4588 buffer, int light) {
        KineticBlockEntityRenderer.standardKineticRotationTransform(superBuffer, be, light).renderInto(ms, buffer);
    }

    public static float getAngleForBe(KineticBlockEntity be, class_2338 pos, class_2350.class_2351 axis) {
        float time = AnimationTickHolder.getRenderTime((class_1936)be.method_10997());
        float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, axis);
        float angle = (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        return angle;
    }

    public static SuperByteBuffer standardKineticRotationTransform(SuperByteBuffer buffer, KineticBlockEntity be, int light) {
        class_2338 pos = be.method_11016();
        class_2350.class_2351 axis = ((IRotate)be.method_11010().method_26204()).getRotationAxis(be.method_11010());
        return KineticBlockEntityRenderer.kineticRotationTransform(buffer, be, axis, KineticBlockEntityRenderer.getAngleForBe(be, pos, axis), light);
    }

    public static SuperByteBuffer kineticRotationTransform(SuperByteBuffer buffer, KineticBlockEntity be, class_2350.class_2351 axis, float angle, int light) {
        buffer.light(light);
        buffer.rotateCentered(angle, class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis));
        if (KineticDebugger.isActive()) {
            rainbowMode = true;
            buffer.color(be.hasNetwork() ? Color.generateFromLong((long)be.network) : Color.WHITE);
        } else {
            float overStressedEffect = be.effects.overStressedEffect;
            if (overStressedEffect != 0.0f) {
                boolean overstressed = overStressedEffect > 0.0f;
                Color color = overstressed ? Color.RED : Color.SPRING_GREEN;
                float weight = overstressed ? overStressedEffect : -overStressedEffect;
                buffer.color(Color.WHITE.mixWith(color, weight));
            } else {
                buffer.color(Color.WHITE);
            }
        }
        return buffer;
    }

    public static float getRotationOffsetForPosition(KineticBlockEntity be, class_2338 pos, class_2350.class_2351 axis) {
        return KineticBlockEntityVisual.rotationOffset(be.method_11010(), axis, (class_2382)pos) + (float)be.getRotationAngleOffset(axis);
    }

    public static class_2680 shaft(class_2350.class_2351 axis) {
        return (class_2680)AllBlocks.SHAFT.getDefaultState().method_11657((class_2769)class_2741.field_12496, (Comparable)axis);
    }

    public static class_2350.class_2351 getRotationAxisOf(KineticBlockEntity be) {
        return ((IRotate)be.method_11010().method_26204()).getRotationAxis(be.method_11010());
    }
}

