/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.mechanicalArm;

import com.google.common.collect.Lists;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlock;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmRenderer;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.AbstractInstance;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.util.RecyclingPoseStack;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.theme.Color;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_918;

public class ArmVisual
extends SingleAxisRotatingVisual<ArmBlockEntity>
implements SimpleDynamicVisual {
    final TransformedInstance base;
    final TransformedInstance lowerBody;
    final TransformedInstance upperBody;
    final TransformedInstance claw;
    private final ArrayList<TransformedInstance> clawGrips;
    private final ArrayList<TransformedInstance> models;
    private final boolean ceiling;
    private final RecyclingPoseStack poseStack = new RecyclingPoseStack();
    private boolean wasDancing = false;
    private float baseAngle = Float.NaN;
    private float lowerArmAngle = Float.NaN;
    private float upperArmAngle = Float.NaN;
    private float headAngle = Float.NaN;

    public ArmVisual(VisualizationContext context, ArmBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, Models.partial((PartialModel)AllPartialModels.ARM_COG));
        this.base = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.ARM_BASE)).createInstance();
        this.lowerBody = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.ARM_LOWER_BODY)).createInstance();
        this.upperBody = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.ARM_UPPER_BODY)).createInstance();
        this.claw = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)(blockEntity.goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE))).createInstance();
        TransformedInstance clawGrip1 = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.ARM_CLAW_GRIP_UPPER)).createInstance();
        TransformedInstance clawGrip2 = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.ARM_CLAW_GRIP_LOWER)).createInstance();
        this.clawGrips = Lists.newArrayList((Object[])new TransformedInstance[]{clawGrip1, clawGrip2});
        this.models = Lists.newArrayList((Object[])new TransformedInstance[]{this.base, this.lowerBody, this.upperBody, this.claw, clawGrip1, clawGrip2});
        this.ceiling = (Boolean)this.blockState.method_11654((class_2769)ArmBlock.CEILING);
        PoseTransformStack msr = TransformStack.of((class_4587)this.poseStack);
        msr.translate((class_2382)this.getVisualPosition());
        msr.center();
        if (this.ceiling) {
            msr.rotateXDegrees(180.0f);
        }
        this.animate(partialTick);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    private void animate(float pt) {
        if (((ArmBlockEntity)this.blockEntity).phase == ArmBlockEntity.Phase.DANCING && ((ArmBlockEntity)this.blockEntity).getSpeed() != 0.0f) {
            this.animateRave(pt);
            this.wasDancing = true;
            return;
        }
        float baseAngleNow = ((ArmBlockEntity)this.blockEntity).baseAngle.getValue(pt);
        float lowerArmAngleNow = ((ArmBlockEntity)this.blockEntity).lowerArmAngle.getValue(pt);
        float upperArmAngleNow = ((ArmBlockEntity)this.blockEntity).upperArmAngle.getValue(pt);
        float headAngleNow = ((ArmBlockEntity)this.blockEntity).headAngle.getValue(pt);
        boolean settled = class_3532.method_15347((float)this.baseAngle, (float)baseAngleNow) && class_3532.method_15347((float)this.lowerArmAngle, (float)lowerArmAngleNow) && class_3532.method_15347((float)this.upperArmAngle, (float)upperArmAngleNow) && class_3532.method_15347((float)this.headAngle, (float)headAngleNow);
        this.baseAngle = baseAngleNow;
        this.lowerArmAngle = lowerArmAngleNow;
        this.upperArmAngle = upperArmAngleNow;
        this.headAngle = headAngleNow;
        if (!settled || this.wasDancing) {
            this.animateArm();
        }
        this.wasDancing = false;
    }

    private void animateRave(float partialTick) {
        int ticks = AnimationTickHolder.getTicks((class_1936)((ArmBlockEntity)this.blockEntity).method_10997());
        float renderTick = (float)ticks + partialTick + (float)(((ArmBlockEntity)this.blockEntity).hashCode() % 64);
        float baseAngle = renderTick * 10.0f % 360.0f;
        float lowerArmAngle = class_3532.method_16439((float)((class_3532.method_15374((float)(renderTick / 4.0f)) + 1.0f) / 2.0f), (float)-45.0f, (float)15.0f);
        float upperArmAngle = class_3532.method_16439((float)((class_3532.method_15374((float)(renderTick / 8.0f)) + 1.0f) / 4.0f), (float)-45.0f, (float)95.0f);
        float headAngle = -lowerArmAngle;
        int color = Color.rainbowColor((int)(ticks * 100)).getRGB();
        this.updateAngles(baseAngle, lowerArmAngle, upperArmAngle, headAngle, color);
    }

    private void animateArm() {
        this.updateAngles(this.baseAngle, this.lowerArmAngle - 135.0f, this.upperArmAngle - 90.0f, this.headAngle, 0xFFFFFF);
    }

    private void updateAngles(float baseAngle, float lowerArmAngle, float upperArmAngle, float headAngle, int color) {
        this.poseStack.method_22903();
        PoseTransformStack msr = TransformStack.of((class_4587)this.poseStack);
        ArmRenderer.transformBase((TransformStack)msr, baseAngle);
        this.base.setTransform((class_4587)this.poseStack).setChanged();
        ArmRenderer.transformLowerArm((TransformStack)msr, lowerArmAngle);
        this.lowerBody.setTransform((class_4587)this.poseStack).colorRgb(color).setChanged();
        ArmRenderer.transformUpperArm((TransformStack)msr, upperArmAngle);
        this.upperBody.setTransform((class_4587)this.poseStack).colorRgb(color).setChanged();
        ArmRenderer.transformHead((TransformStack)msr, headAngle);
        if (this.ceiling && ((ArmBlockEntity)this.blockEntity).goggles) {
            msr.rotateZDegrees(180.0f);
        }
        this.claw.setTransform((class_4587)this.poseStack).setChanged();
        if (this.ceiling && ((ArmBlockEntity)this.blockEntity).goggles) {
            msr.rotateZDegrees(180.0f);
        }
        class_1799 item = ((ArmBlockEntity)this.blockEntity).heldItem;
        class_918 itemRenderer = class_310.method_1551().method_1480();
        boolean hasItem = !item.method_7960();
        boolean isBlockItem = hasItem && item.method_7909() instanceof class_1747 && itemRenderer.method_4019(item, (class_1937)class_310.method_1551().field_1687, null, 0).method_4712();
        for (int index : Iterate.zeroAndOne) {
            this.poseStack.method_22903();
            int flip = index * 2 - 1;
            ArmRenderer.transformClawHalf((TransformStack)msr, hasItem, isBlockItem, flip);
            this.clawGrips.get(index).setTransform((class_4587)this.poseStack).setChanged();
            this.poseStack.method_22909();
        }
        this.poseStack.method_22909();
    }

    @Override
    public void update(float pt) {
        super.update(pt);
        this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)(((ArmBlockEntity)this.blockEntity).goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE))).stealInstance((Instance)this.claw);
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight((FlatLit[])this.models.toArray(FlatLit[]::new));
    }

    @Override
    protected void _delete() {
        super._delete();
        this.models.forEach(AbstractInstance::delete);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        this.models.forEach((Consumer<TransformedInstance>)consumer);
    }
}

