/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.box;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.box.PackageDestroyPacket;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.chute.ChuteBlock;
import io.github.fabricators_of_create.porting_lib.entity.IEntityAdditionalSpawnData;
import io.github.fabricators_of_create.porting_lib.entity.PortingLibEntity;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingAttackEvent;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.ponder.api.level.PonderLevel;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;

public class PackageEntity
extends class_1309
implements IEntityAdditionalSpawnData {
    private class_1297 originalEntity;
    public class_1799 box;
    public int insertionDelay;
    public WeakReference<class_1657> tossedBy = new WeakReference<Object>(null);

    public PackageEntity(class_1299<?> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        this.box = class_1799.field_8037;
        this.method_36456(this.field_5974.method_43057() * 360.0f);
        this.method_5847(this.method_36454());
        this.field_5982 = this.method_36454();
        this.insertionDelay = 30;
    }

    public PackageEntity(class_1937 worldIn, double x, double y, double z) {
        this((class_1299)AllEntityTypes.PACKAGE.get(), worldIn);
        this.method_5814(x, y, z);
        this.method_18382();
    }

    public static PackageEntity fromDroppedItem(class_1937 world, class_1297 originalEntity, class_1799 itemstack) {
        PackageEntity packageEntity = (PackageEntity)((class_1299)AllEntityTypes.PACKAGE.get()).method_5883(world);
        class_243 position = originalEntity.method_19538();
        packageEntity.method_33574(position);
        packageEntity.setBox(itemstack);
        packageEntity.method_18799(originalEntity.method_18798().method_1021(1.5));
        packageEntity.originalEntity = originalEntity;
        if (world != null && !world.field_9236 && ChuteBlock.isChute(world.method_8320(class_2338.method_49637((double)position.field_1352, (double)(position.field_1351 + 0.5), (double)position.field_1350)))) {
            packageEntity.method_36456((int)packageEntity.method_36454() / 90 * 90);
        }
        return packageEntity;
    }

    public static PackageEntity fromItemStack(class_1937 world, class_243 position, class_1799 itemstack) {
        PackageEntity packageEntity = (PackageEntity)((class_1299)AllEntityTypes.PACKAGE.get()).method_5883(world);
        packageEntity.method_33574(position);
        packageEntity.setBox(itemstack);
        return packageEntity;
    }

    @Nullable
    public class_1799 method_31480() {
        return this.box.method_7972();
    }

    public static class_5132.class_5133 createPackageAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 5.0).method_26868(class_5134.field_23719, 1.0);
    }

    public static FabricEntityTypeBuilder<?> build(FabricEntityTypeBuilder<?> builder) {
        return builder.dimensions(class_4048.method_18384((float)1.0f, (float)1.0f));
    }

    public void method_6091(class_243 p_213352_1_) {
        super.method_6091(p_213352_1_);
        if (!this.method_37908().field_9236) {
            return;
        }
        if (this.method_18798().method_1033() < 0.0078125) {
            return;
        }
        if (this.field_6012 >= 20) {
            return;
        }
        class_243 motion = this.method_18798().method_1021(0.75);
        class_238 bb = this.method_5829();
        List entityStream = this.method_37908().method_20743((class_1297)this, bb.method_18804(motion));
        motion = PackageEntity.method_20736((class_1297)this, (class_243)motion, (class_238)bb, (class_1937)this.method_37908(), (List)entityStream);
        class_243 clientPos = this.method_19538().method_1019(motion);
        if (this.field_6210 != 0) {
            clientPos = VecHelper.lerp((float)Math.min(1.0f, (float)this.field_6012 / 20.0f), (class_243)clientPos, (class_243)new class_243(this.field_6224, this.field_6245, this.field_6263));
        }
        if (this.field_6012 < 5) {
            this.method_5814(clientPos.field_1352, clientPos.field_1351, clientPos.field_1350);
        }
        if (this.field_6012 < 20) {
            this.method_5759(clientPos.field_1352, clientPos.field_1351, clientPos.field_1350, this.method_36454(), this.method_36455(), this.field_6210 == 0 ? 3 : this.field_6210, true);
        }
    }

    public void method_5750(double x, double y, double z) {
        this.method_18799(this.method_18798().method_1031(x, y, z).method_1021(0.5));
    }

    public String getAddress() {
        return this.box.method_7969().method_10558("Address");
    }

    public void method_5773() {
        if (this.field_5953) {
            this.verifyInitialEntity();
            this.originalEntity = null;
        }
        if (this.method_37908() instanceof PonderLevel) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.06, 0.0));
            if (this.method_19538().field_1351 < 0.125) {
                this.method_31472();
            }
        }
        this.insertionDelay = Math.min(this.insertionDelay + 1, 30);
        super.method_5773();
        if (!PackageItem.isPackage(this.box)) {
            this.method_31472();
        }
    }

    protected void verifyInitialEntity() {
        class_1297 class_12972 = this.originalEntity;
        if (!(class_12972 instanceof class_1542)) {
            return;
        }
        class_1542 itemEntity = (class_1542)class_12972;
        class_2487 nbt = new class_2487();
        itemEntity.method_5652(nbt);
        if (nbt.method_10550("PickupDelay") != Short.MAX_VALUE) {
            return;
        }
        this.method_31472();
    }

    public class_4048 method_18377(class_4050 pPose) {
        if (this.box == null) {
            return super.method_18377(pPose);
        }
        return new class_4048(PackageItem.getWidth(this.box), PackageItem.getHeight(this.box), true);
    }

    public class_1799 getBox() {
        return this.box;
    }

    public static boolean centerPackage(class_1297 entity, class_243 target) {
        if (!(entity instanceof PackageEntity)) {
            return true;
        }
        PackageEntity packageEntity = (PackageEntity)entity;
        return packageEntity.decreaseInsertionTimer(target);
    }

    public boolean decreaseInsertionTimer(@Nullable class_243 targetSpot) {
        if (targetSpot != null) {
            this.method_18799(this.method_18798().method_1021(0.75).method_18805(1.0, 0.25, 1.0));
            class_243 pos = this.method_19538().method_1019(targetSpot.method_1020(this.method_19538()).method_1021((double)0.2f));
            this.method_5814(pos.field_1352, pos.field_1351, pos.field_1350);
            float yawTarget = (int)this.method_36454() / 90 * 90;
            this.method_36456(AngleHelper.angleLerp((double)0.5, (double)this.method_36454(), (double)yawTarget));
        }
        this.insertionDelay = Math.max(this.insertionDelay - 3, 0);
        return this.insertionDelay == 0;
    }

    public void setBox(class_1799 box) {
        this.box = box.method_7972();
        this.method_18382();
    }

    public boolean method_5810() {
        return true;
    }

    public boolean method_30949(class_1297 pEntity) {
        return pEntity instanceof PackageEntity && pEntity.method_5829().field_1325 < this.method_5829().field_1322 + 0.125;
    }

    public boolean method_30948() {
        return false;
    }

    public class_1269 method_5688(class_1657 pPlayer, class_1268 pHand) {
        if (!pPlayer.method_5998(pHand).method_7960()) {
            return super.method_5688(pPlayer, pHand);
        }
        if (pPlayer.method_37908().field_9236) {
            return class_1269.field_5812;
        }
        pPlayer.method_6122(pHand, this.box);
        this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15197, class_3419.field_15248, 0.2f, 0.75f + this.method_37908().field_9229.method_43057());
        this.method_5650(class_1297.class_5529.field_26999);
        return class_1269.field_5812;
    }

    public void method_5697(class_1297 entityIn) {
        boolean isOtherPackage = entityIn instanceof PackageEntity;
        if (!isOtherPackage && this.tossedBy.get() != null) {
            this.tossedBy = new WeakReference<Object>(null);
        }
        if (isOtherPackage) {
            if (entityIn.method_5829().field_1322 < this.method_5829().field_1325) {
                super.method_5697(entityIn);
            }
        } else if (entityIn.method_5829().field_1322 <= this.method_5829().field_1322) {
            super.method_5697(entityIn);
        }
    }

    public double method_5621() {
        return this.method_18377((class_4050)this.method_18376()).field_18068;
    }

    protected void method_5622(class_2680 state) {
        super.method_5622(state);
        if (!this.method_5805()) {
            return;
        }
        if (state.method_26204() == class_2246.field_10382 || state.method_28498((class_2769)class_2741.field_12508) && ((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
            this.destroy(this.method_48923().method_48824());
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean shotCanPierce;
        LivingAttackEvent event = new LivingAttackEvent((class_1309)this, source, amount);
        event.sendEvent();
        if (event.isCanceled()) {
            return false;
        }
        if (this.method_37908().field_9236 || !this.method_5805()) {
            return false;
        }
        if (source.method_48789(class_8103.field_42242)) {
            this.method_5650(class_1297.class_5529.field_26998);
            return false;
        }
        if (!this.box.method_7909().method_24357(source)) {
            return false;
        }
        if (source.equals(this.method_48923().method_48822()) && (this.method_5765() || this.insertionDelay < 20)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42250)) {
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        if (source.method_48789(class_8103.field_42249)) {
            this.destroy(source);
            this.method_5650(class_1297.class_5529.field_26998);
            return false;
        }
        if (source.method_48789(class_8103.field_42246)) {
            if (this.method_5809()) {
                this.takeDamage(source, 0.15f);
            } else {
                this.method_5639(5);
            }
            return false;
        }
        boolean wasShot = source.method_5526() instanceof class_1665;
        boolean bl = shotCanPierce = wasShot && ((class_1665)source.method_5526()).method_7447() > 0;
        if (source.method_5529() instanceof class_1657 && !((class_1657)source.method_5529()).method_31549().field_7476) {
            return false;
        }
        this.destroy(source);
        this.method_5650(class_1297.class_5529.field_26998);
        return shotCanPierce;
    }

    private void takeDamage(class_1282 source, float amount) {
        float hp = this.method_6032();
        if ((hp -= amount) <= 0.5f) {
            this.destroy(source);
            this.method_5650(class_1297.class_5529.field_26998);
        } else {
            this.method_6033(hp);
        }
    }

    private void destroy(class_1282 source) {
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new PackageDestroyPacket(this.method_5829().method_1005(), this.box), (class_1297)this);
        AllSoundEvents.PACKAGE_POP.playOnServer(this.method_37908(), (class_2382)this.method_24515());
        this.method_16080(source);
    }

    protected void method_16080(class_1282 pDamageSource) {
        super.method_16080(pDamageSource);
        ItemStackHandler contents = PackageItem.getContents(this.box);
        for (int i = 0; i < contents.getSlotCount(); ++i) {
            class_1799 itemstack = contents.getStackInSlot(i);
            class_1792 class_17922 = itemstack.method_7909();
            if (class_17922 instanceof class_1826) {
                class_1826 sei = (class_1826)class_17922;
                class_17922 = this.method_37908();
                if (class_17922 instanceof class_3218) {
                    class_3218 sl = (class_3218)class_17922;
                    class_1299 entitytype = sei.method_8015(itemstack.method_7969());
                    class_1297 entity = entitytype.method_5894(sl, itemstack, null, this.method_24515(), class_3730.field_16465, false, false);
                    if (entity != null) {
                        itemstack.method_7934(1);
                    }
                }
            }
            if (itemstack.method_7960()) continue;
            class_1542 entityIn = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), itemstack);
            this.method_37908().method_8649((class_1297)entityIn);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.box = class_1799.method_7915((class_2487)compound.method_10562("Box"));
        this.method_18382();
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("Box", this.box.serializeNBT());
    }

    public class_2596<class_2602> method_18002() {
        return PortingLibEntity.getEntitySpawningPacket((class_1297)this);
    }

    public Iterable<class_1799> method_5661() {
        return Collections.emptyList();
    }

    public class_1799 method_6118(class_1304 pSlot) {
        if (pSlot == class_1304.field_6173) {
            return this.getBox();
        }
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 pSlot, class_1799 pStack) {
        if (pSlot == class_1304.field_6173) {
            this.setBox(pStack);
        }
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public class_1268 method_6058() {
        return class_1268.field_5808;
    }

    public void writeSpawnData(class_2540 buffer) {
        buffer.method_10793(this.getBox());
        class_243 motion = this.method_18798();
        buffer.writeFloat((float)motion.field_1352);
        buffer.writeFloat((float)motion.field_1351);
        buffer.writeFloat((float)motion.field_1350);
    }

    public void readSpawnData(class_2540 additionalData) {
        this.setBox(additionalData.method_10819());
        this.method_18800(additionalData.readFloat(), additionalData.readFloat(), additionalData.readFloat());
    }

    public float method_6017() {
        return 1.5f;
    }

    public class_1309.class_6823 method_39760() {
        return new class_1309.class_6823(class_3417.field_40968, class_3417.field_40968);
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return null;
    }

    @Nullable
    protected class_3414 method_6002() {
        return null;
    }

    public boolean method_6086() {
        return false;
    }

    public boolean method_5753() {
        return this.box.method_7909().method_24358() || super.method_5753();
    }
}

