/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public final class SingletonItemAttribute
implements ItemAttribute {
    private final Type type;
    private final BiPredicate<class_1799, class_1937> predicate;
    private final String translationKey;

    public SingletonItemAttribute(Type type, BiPredicate<class_1799, class_1937> predicate, String translationKey) {
        this.type = type;
        this.predicate = predicate;
        this.translationKey = translationKey;
    }

    @Override
    public boolean appliesTo(class_1799 stack, class_1937 world) {
        return this.predicate.test(stack, world);
    }

    @Override
    public ItemAttributeType getType() {
        return this.type;
    }

    @Override
    public void save(class_2487 nbt) {
    }

    @Override
    public void load(class_2487 nbt) {
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    public static final class Type
    implements ItemAttributeType {
        private final SingletonItemAttribute attribute;

        public Type(Function<Type, SingletonItemAttribute> singletonFunc) {
            this.attribute = singletonFunc.apply(this);
        }

        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return this.attribute;
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            if (this.attribute.appliesTo(stack, level)) {
                return List.of(this.attribute);
            }
            return List.of();
        }
    }
}

