/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packager;

import com.google.common.collect.Lists;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.stockTicker.LogisticalStockResponsePacket;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import me.pepperbell.simplenetworking.S2CPacket;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.apache.commons.lang3.mutable.MutableInt;

public class InventorySummary {
    public static final InventorySummary EMPTY = new InventorySummary();
    private Map<class_1792, List<BigItemStack>> items = new IdentityHashMap<class_1792, List<BigItemStack>>();
    private List<BigItemStack> stacksByCount;
    private int totalCount;
    public int contributingLinks;

    public void add(InventorySummary summary) {
        summary.items.forEach((i, list) -> list.forEach(this::add));
        this.contributingLinks += summary.contributingLinks;
    }

    public void add(class_1799 stack) {
        this.add(stack, stack.method_7947());
    }

    public void add(BigItemStack entry) {
        this.add(entry.stack, entry.count);
    }

    public void add(StorageView<ItemVariant> view) {
        int count = TransferUtil.truncateLong((long)view.getAmount());
        this.add(((ItemVariant)view.getResource()).toStack(count), count);
    }

    public void add(ItemVariant variant, long amount) {
        this.add(variant.toStack(TransferUtil.truncateLong((long)amount)));
    }

    public Map<class_1792, List<BigItemStack>> getItemMap() {
        return this.items;
    }

    public InventorySummary copy() {
        InventorySummary inventorySummary = new InventorySummary();
        this.items.forEach((i, list) -> list.forEach(entry -> inventorySummary.add(entry.stack, entry.count)));
        return inventorySummary;
    }

    public void add(class_1799 stack, int count) {
        if (count == 0 || stack.method_7960()) {
            return;
        }
        if (this.totalCount < 1000000000) {
            this.totalCount += count;
        }
        List stacks = this.items.computeIfAbsent(stack.method_7909(), $ -> Lists.newArrayList());
        for (BigItemStack existing : stacks) {
            class_1799 existingStack = existing.stack;
            if (!ItemHandlerHelper.canItemStacksStack((class_1799)existingStack, (class_1799)stack)) continue;
            if (existing.count < 1000000000) {
                existing.count += count;
            }
            return;
        }
        if (stack.method_7947() > stack.method_7914()) {
            stack = stack.method_46651(1);
        }
        BigItemStack newEntry = new BigItemStack(stack, count);
        stacks.add(newEntry);
    }

    public boolean erase(class_1799 stack) {
        List<BigItemStack> stacks = this.items.get(stack.method_7909());
        if (stacks == null) {
            return false;
        }
        Iterator<BigItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            BigItemStack existing = iterator.next();
            class_1799 existingStack = existing.stack;
            if (!ItemHandlerHelper.canItemStacksStack((class_1799)existingStack, (class_1799)stack)) continue;
            this.totalCount -= existing.count;
            iterator.remove();
            return true;
        }
        return false;
    }

    public int getCountOf(class_1799 stack) {
        List<BigItemStack> list = this.items.get(stack.method_7909());
        if (list == null) {
            return 0;
        }
        for (BigItemStack entry : list) {
            if (!ItemHandlerHelper.canItemStacksStack((class_1799)entry.stack, (class_1799)stack)) continue;
            return entry.count;
        }
        return 0;
    }

    public int getTotalOfMatching(Predicate<class_1799> filter) {
        MutableInt sum = new MutableInt();
        this.items.forEach(($, list) -> {
            for (BigItemStack entry : list) {
                if (!filter.test(entry.stack)) continue;
                sum.add(entry.count);
            }
        });
        return sum.getValue();
    }

    public List<BigItemStack> getStacks() {
        if (this.stacksByCount == null) {
            ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>();
            this.items.forEach((i, list) -> list.forEach(stacks::add));
            return stacks;
        }
        return this.stacksByCount;
    }

    public List<BigItemStack> getStacksByCount() {
        if (this.stacksByCount == null) {
            this.stacksByCount = new ArrayList<BigItemStack>();
            this.items.forEach((i, list) -> list.forEach(this.stacksByCount::add));
            Collections.sort(this.stacksByCount, BigItemStack.comparator());
        }
        return this.stacksByCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void divideAndSendTo(class_3222 player, class_2338 pos) {
        List<BigItemStack> stacks = this.getStacksByCount();
        int remaining = stacks.size();
        ArrayList<BigItemStack> currentList = null;
        if (stacks.isEmpty()) {
            LogisticalStockResponsePacket packet = new LogisticalStockResponsePacket(true, pos, Collections.emptyList());
            AllPackets.getChannel().sendToClient((S2CPacket)packet, player);
        }
        for (BigItemStack entry : stacks) {
            if (currentList == null) {
                currentList = new ArrayList<BigItemStack>(Math.min(100, remaining));
            }
            currentList.add(entry);
            if (--remaining == 0) break;
            if (currentList.size() < 100) continue;
            AllPackets.getChannel().sendToClient((S2CPacket)new LogisticalStockResponsePacket(false, pos, currentList), player);
            currentList = null;
        }
        if (currentList != null) {
            AllPackets.getChannel().sendToClient((S2CPacket)new LogisticalStockResponsePacket(true, pos, (List<BigItemStack>)currentList), player);
        }
    }

    public class_2487 write() {
        ArrayList all = new ArrayList();
        this.items.forEach((key, list) -> all.addAll(list));
        class_2487 tag = new class_2487();
        tag.method_10566("List", (class_2520)NBTHelper.writeCompoundList(all, BigItemStack::write));
        return tag;
    }

    public static InventorySummary read(class_2487 tag) {
        InventorySummary summary = new InventorySummary();
        NBTHelper.iterateCompoundList((class_2499)tag.method_10554("List", 10), c -> summary.add(BigItemStack.read(c)));
        return summary;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }
}

