/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagerLink;

import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetworkSavedData;
import com.simibubi.create.content.logistics.packagerLink.RequestPromiseQueue;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_4208;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GlobalLogisticsManager {
    public Map<UUID, LogisticsNetwork> logisticsNetworks = new HashMap<UUID, LogisticsNetwork>();
    private LogisticsNetworkSavedData savedData;

    public void levelLoaded(class_1936 level) {
        MinecraftServer server = level.method_8503();
        if (server == null || server.method_30002() != level) {
            return;
        }
        this.logisticsNetworks = new HashMap<UUID, LogisticsNetwork>();
        this.savedData = null;
        this.loadLogisticsData(server);
    }

    public boolean mayInteract(UUID networkId, class_1657 player) {
        LogisticsNetwork network = this.logisticsNetworks.get(networkId);
        return network == null || network.owner == null || !network.locked || network.owner.equals(player.method_5667());
    }

    public boolean mayAdministrate(UUID networkId, class_1657 player) {
        LogisticsNetwork network = this.logisticsNetworks.get(networkId);
        return network == null || network.owner == null || network.owner.equals(player.method_5667());
    }

    public boolean isLockable(UUID networkId) {
        LogisticsNetwork network = this.logisticsNetworks.get(networkId);
        return network != null;
    }

    public boolean isLocked(UUID networkId) {
        LogisticsNetwork network = this.logisticsNetworks.get(networkId);
        return network != null && network.locked;
    }

    public void linkAdded(UUID networkId, class_4208 pos, UUID ownedBy) {
        LogisticsNetwork network = this.logisticsNetworks.computeIfAbsent(networkId, $ -> new LogisticsNetwork(networkId));
        network.totalLinks.add(pos);
        if (ownedBy != null && network.owner == null) {
            network.owner = ownedBy;
        }
        this.markDirty();
    }

    public void linkLoaded(UUID networkId, class_4208 pos) {
        this.logisticsNetworks.computeIfAbsent((UUID)networkId, (Function<UUID, LogisticsNetwork>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$linkLoaded$1(java.util.UUID java.util.UUID ), (Ljava/util/UUID;)Lcom/simibubi/create/content/logistics/packagerLink/LogisticsNetwork;)((UUID)networkId)).loadedLinks.add(pos);
    }

    public void linkRemoved(UUID networkId, class_4208 pos) {
        LogisticsNetwork logisticsNetwork = this.logisticsNetworks.get(networkId);
        if (logisticsNetwork == null) {
            return;
        }
        logisticsNetwork.totalLinks.remove(pos);
        logisticsNetwork.loadedLinks.remove(pos);
        if (logisticsNetwork.totalLinks.size() <= 0) {
            this.logisticsNetworks.remove(networkId);
        }
        this.markDirty();
    }

    public void linkInvalidated(UUID networkId, class_4208 pos) {
        LogisticsNetwork logisticsNetwork = this.logisticsNetworks.get(networkId);
        if (logisticsNetwork == null) {
            return;
        }
        logisticsNetwork.loadedLinks.remove(pos);
    }

    public int getUnloadedLinkCount(UUID networkId) {
        LogisticsNetwork logisticsNetwork = this.logisticsNetworks.get(networkId);
        if (logisticsNetwork == null) {
            return 0;
        }
        return logisticsNetwork.totalLinks.size() - logisticsNetwork.loadedLinks.size();
    }

    @Nullable
    public RequestPromiseQueue getQueuedPromises(UUID networkId) {
        return !this.logisticsNetworks.containsKey(networkId) ? null : this.logisticsNetworks.get((Object)networkId).panelPromises;
    }

    public boolean hasQueuedPromises(UUID networkId) {
        return this.logisticsNetworks.containsKey(networkId) && !this.logisticsNetworks.get((Object)networkId).panelPromises.isEmpty();
    }

    private void loadLogisticsData(MinecraftServer server) {
        if (this.savedData != null) {
            return;
        }
        this.savedData = LogisticsNetworkSavedData.load(server);
        this.logisticsNetworks = this.savedData.getLogisticsNetworks();
    }

    public void tick(class_1937 level) {
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        this.logisticsNetworks.forEach((id, network) -> network.panelPromises.tick());
    }

    public void markDirty() {
        if (this.savedData != null) {
            this.savedData.method_80();
        }
    }

    private static /* synthetic */ LogisticsNetwork lambda$linkLoaded$1(UUID networkId, UUID $) {
        return new LogisticsNetwork(networkId);
    }
}

