/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagerLink;

import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packagerLink.RequestPromise;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class RequestPromiseQueue {
    private Map<class_1792, List<RequestPromise>> promisesByItem = new IdentityHashMap<class_1792, List<RequestPromise>>();
    private Runnable onChanged;

    public RequestPromiseQueue(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    public void add(RequestPromise promise) {
        this.promisesByItem.computeIfAbsent(promise.promisedStack.stack.method_7909(), $ -> new LinkedList()).add(promise);
        this.onChanged.run();
    }

    public void setOnChanged(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    public int getTotalPromisedAndRemoveExpired(class_1799 stack, int expiryTime) {
        int promised = 0;
        List<RequestPromise> list = this.promisesByItem.get(stack.method_7909());
        if (list == null) {
            return promised;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = iterator.next();
            if (!ItemHandlerHelper.canItemStacksStack((class_1799)promise.promisedStack.stack, (class_1799)stack)) continue;
            if (expiryTime != -1 && promise.ticksExisted >= expiryTime) {
                iterator.remove();
                this.onChanged.run();
                continue;
            }
            promised += promise.promisedStack.count;
        }
        return promised;
    }

    public void forceClear(class_1799 stack) {
        List<RequestPromise> list = this.promisesByItem.get(stack.method_7909());
        if (list == null) {
            return;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise promise = iterator.next();
            if (!ItemHandlerHelper.canItemStacksStack((class_1799)promise.promisedStack.stack, (class_1799)stack)) continue;
            iterator.remove();
            this.onChanged.run();
        }
        if (list.isEmpty()) {
            this.promisesByItem.remove(stack.method_7909());
        }
    }

    public void itemEnteredSystem(class_1799 stack, int amount) {
        List<RequestPromise> list = this.promisesByItem.get(stack.method_7909());
        if (list == null) {
            return;
        }
        Iterator<RequestPromise> iterator = list.iterator();
        while (iterator.hasNext()) {
            RequestPromise requestPromise = iterator.next();
            if (!ItemHandlerHelper.canItemStacksStack((class_1799)requestPromise.promisedStack.stack, (class_1799)stack)) continue;
            int toSubtract = Math.min(amount, requestPromise.promisedStack.count);
            amount -= toSubtract;
            requestPromise.promisedStack.count -= toSubtract;
            if (requestPromise.promisedStack.count <= 0) {
                iterator.remove();
                this.onChanged.run();
            }
            if (amount > 0) continue;
            break;
        }
        if (list.isEmpty()) {
            this.promisesByItem.remove(stack.method_7909());
        }
    }

    public List<RequestPromise> flatten(boolean sorted) {
        ArrayList<RequestPromise> all = new ArrayList<RequestPromise>();
        this.promisesByItem.forEach((key, list) -> all.addAll((Collection<RequestPromise>)list));
        if (sorted) {
            Collections.sort(all, RequestPromise.ageComparator());
        }
        return all;
    }

    public class_2487 write() {
        class_2487 tag = new class_2487();
        tag.method_10566("List", (class_2520)NBTHelper.writeCompoundList(this.flatten(false), rp -> {
            class_2487 c = rp.promisedStack.write();
            c.method_10569("Age", rp.ticksExisted);
            return c;
        }));
        return tag;
    }

    public static RequestPromiseQueue read(class_2487 tag, Runnable onChanged) {
        RequestPromiseQueue queue = new RequestPromiseQueue(onChanged);
        NBTHelper.iterateCompoundList((class_2499)tag.method_10554("List", 10), c -> {
            RequestPromise promise = new RequestPromise(BigItemStack.read(c));
            promise.ticksExisted = c.method_10550("Age");
            queue.add(promise);
        });
        return queue;
    }

    public void tick() {
        this.promisesByItem.forEach((key, list) -> list.forEach(RequestPromise::tick));
    }

    public boolean isEmpty() {
        return this.promisesByItem.isEmpty();
    }
}

